/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin.processing;

import java.util.Collection;
import java.util.List;
import org.apache.felix.scr.annotations.sling.SlingFilter;
import org.apache.felix.scr.annotations.sling.SlingFilterScope;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.felix.scrplugin.SCRDescriptorException;
import org.apache.felix.scrplugin.SCRDescriptorFailureException;
import org.apache.felix.scrplugin.annotations.AnnotationProcessor;
import org.apache.felix.scrplugin.annotations.ClassAnnotation;
import org.apache.felix.scrplugin.annotations.ScannedAnnotation;
import org.apache.felix.scrplugin.annotations.ScannedClass;
import org.apache.felix.scrplugin.description.AbstractDescription;
import org.apache.felix.scrplugin.description.ClassDescription;
import org.apache.felix.scrplugin.description.ComponentConfigurationPolicy;
import org.apache.felix.scrplugin.description.ComponentDescription;
import org.apache.felix.scrplugin.description.PropertyDescription;
import org.apache.felix.scrplugin.description.PropertyType;
import org.apache.felix.scrplugin.description.ServiceDescription;

public class SlingAnnotationProcessor
implements AnnotationProcessor {
    public String getName() {
        return "Apache Sling Annotation Processor";
    }

    public void process(ScannedClass scannedClass, ClassDescription describedClass) throws SCRDescriptorFailureException, SCRDescriptorException {
        List servlets = scannedClass.getClassAnnotations(SlingServlet.class.getName());
        scannedClass.processed((Collection)servlets);
        for (ClassAnnotation cad : servlets) {
            this.processSlingServlet(cad, describedClass);
        }
        List filters = scannedClass.getClassAnnotations(SlingFilter.class.getName());
        scannedClass.processed((Collection)filters);
        for (ClassAnnotation cad : filters) {
            this.processSlingFilter(cad, describedClass);
        }
    }

    public int getRanking() {
        return 500;
    }

    private void processSlingServlet(ClassAnnotation cad, ClassDescription classDescription) {
        String[] methods;
        String[] extensions;
        String[] selectors;
        String[] resourceTypes;
        String[] paths;
        boolean generateService;
        boolean generateComponent = cad.getBooleanValue("generateComponent", true);
        if (generateComponent) {
            ComponentDescription cd = new ComponentDescription((ScannedAnnotation)cad);
            cd.setName(cad.getStringValue("name", classDescription.getDescribedClass().getName()));
            cd.setConfigurationPolicy(ComponentConfigurationPolicy.OPTIONAL);
            cd.setLabel(cad.getStringValue("label", null));
            cd.setDescription(cad.getStringValue("description", null));
            cd.setCreateMetatype(cad.getBooleanValue("metatype", false));
            classDescription.add((AbstractDescription)cd);
        }
        if (generateService = cad.getBooleanValue("generateService", true)) {
            ServiceDescription sd = new ServiceDescription((ScannedAnnotation)cad);
            sd.addInterface("javax.servlet.Servlet");
            classDescription.add((AbstractDescription)sd);
        }
        if ((paths = (String[])cad.getValue("paths")) != null) {
            PropertyDescription pd = new PropertyDescription((ScannedAnnotation)cad);
            pd.setName("sling.servlet.paths");
            pd.setMultiValue(paths);
            pd.setType(PropertyType.String);
            pd.setPrivate(Boolean.valueOf(true));
            classDescription.add((AbstractDescription)pd);
        }
        if ((resourceTypes = (String[])cad.getValue("resourceTypes")) != null) {
            PropertyDescription pd = new PropertyDescription((ScannedAnnotation)cad);
            pd.setName("sling.servlet.resourceTypes");
            pd.setMultiValue(resourceTypes);
            pd.setType(PropertyType.String);
            pd.setPrivate(Boolean.valueOf(true));
            classDescription.add((AbstractDescription)pd);
        }
        if ((selectors = (String[])cad.getValue("selectors")) != null) {
            PropertyDescription pd = new PropertyDescription((ScannedAnnotation)cad);
            pd.setName("sling.servlet.selectors");
            pd.setMultiValue(selectors);
            pd.setType(PropertyType.String);
            pd.setPrivate(Boolean.valueOf(true));
            classDescription.add((AbstractDescription)pd);
        }
        if ((extensions = (String[])cad.getValue("extensions")) != null) {
            PropertyDescription pd = new PropertyDescription((ScannedAnnotation)cad);
            pd.setName("sling.servlet.extensions");
            pd.setMultiValue(extensions);
            pd.setType(PropertyType.String);
            pd.setPrivate(Boolean.valueOf(true));
            classDescription.add((AbstractDescription)pd);
        }
        if ((methods = (String[])cad.getValue("methods")) != null) {
            PropertyDescription pd = new PropertyDescription((ScannedAnnotation)cad);
            pd.setName("sling.servlet.methods");
            pd.setMultiValue(methods);
            pd.setType(PropertyType.String);
            pd.setPrivate(Boolean.valueOf(true));
            classDescription.add((AbstractDescription)pd);
        }
    }

    private void processSlingFilter(ClassAnnotation cad, ClassDescription classDescription) {
        boolean generateService;
        boolean generateComponent = cad.getBooleanValue("generateComponent", true);
        if (generateComponent) {
            ComponentDescription cd = new ComponentDescription((ScannedAnnotation)cad);
            cd.setName(cad.getStringValue("name", classDescription.getDescribedClass().getName()));
            cd.setConfigurationPolicy(ComponentConfigurationPolicy.OPTIONAL);
            cd.setLabel(cad.getStringValue("label", null));
            cd.setDescription(cad.getStringValue("description", null));
            cd.setCreateMetatype(cad.getBooleanValue("metatype", false));
            classDescription.add((AbstractDescription)cd);
        }
        if (generateService = cad.getBooleanValue("generateService", true)) {
            ServiceDescription sd = new ServiceDescription((ScannedAnnotation)cad);
            sd.addInterface("javax.servlet.Filter");
            classDescription.add((AbstractDescription)sd);
        }
        int order = cad.getIntegerValue("order", 0);
        PropertyDescription pd = new PropertyDescription((ScannedAnnotation)cad);
        pd.setName("service.ranking");
        pd.setValue(String.valueOf(order));
        pd.setType(PropertyType.Integer);
        pd.setPrivate(Boolean.valueOf(true));
        classDescription.add((AbstractDescription)pd);
        String scope = cad.getEnumValue("scope", SlingFilterScope.REQUEST.getScope());
        PropertyDescription pd2 = new PropertyDescription((ScannedAnnotation)cad);
        pd2.setName("sling.filter.scope");
        pd2.setValue(scope);
        pd2.setType(PropertyType.String);
        pd2.setPrivate(Boolean.valueOf(true));
        classDescription.add((AbstractDescription)pd2);
    }
}

