/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class IOUtils {
    private static final SAXTransformerFactory FACTORY = (SAXTransformerFactory)TransformerFactory.newInstance();

    public static final void parse(InputStream file, ContentHandler handler) throws TransformerException {
        Transformer transformer = FACTORY.newTransformer();
        transformer.transform(new StreamSource(file), new SAXResult(handler));
    }

    public static ContentHandler getSerializer(File file) throws TransformerException, IOException {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        TransformerHandler transformerHandler = FACTORY.newTransformerHandler();
        Transformer transformer = transformerHandler.getTransformer();
        Properties format = new Properties();
        format.put("method", "xml");
        format.put("omit-xml-declaration", "no");
        format.put("encoding", "UTF-8");
        format.put("indent", "yes");
        transformer.setOutputProperties(format);
        transformerHandler.setResult(new StreamResult(writer));
        return transformerHandler;
    }

    public static void addAttribute(AttributesImpl ai, String name, Object value) {
        if (value != null) {
            ai.addAttribute("", name, name, "CDATA", value.toString());
        }
    }

    public static void text(ContentHandler ch, String text) throws SAXException {
        if (text != null) {
            char[] c = text.toCharArray();
            ch.characters(c, 0, c.length);
        }
    }

    public static void indent(ContentHandler ch, int level) throws SAXException {
        for (int i = 0; i < level; ++i) {
            IOUtils.text(ch, "    ");
        }
    }

    public static void newline(ContentHandler ch) throws SAXException {
        IOUtils.text(ch, "\n");
    }
}

