/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin.xml;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.TransformerException;
import org.apache.felix.scrplugin.Log;
import org.apache.felix.scrplugin.Options;
import org.apache.felix.scrplugin.SCRDescriptorException;
import org.apache.felix.scrplugin.helper.ComponentContainer;
import org.apache.felix.scrplugin.helper.ComponentContainerUtil;
import org.apache.felix.scrplugin.helper.DescriptionContainer;
import org.apache.felix.scrplugin.helper.MetatypeAttributeDefinition;
import org.apache.felix.scrplugin.helper.MetatypeContainer;
import org.apache.felix.scrplugin.xml.IOUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaTypeIO {
    private static final String NAMESPACE_URI_10 = "http://www.osgi.org/xmlns/metatype/v1.0.0";
    private static final String NAMESPACE_URI_12 = "http://www.osgi.org/xmlns/metatype/v1.2.0";
    private static final String INNER_NAMESPACE_URI = "";
    private static final String PREFIX = "metatype";
    private static final String METADATA_ELEMENT = "MetaData";
    private static final String METADATA_ELEMENT_QNAME = "metatype:MetaData";
    private static final String OCD_ELEMENT = "OCD";
    private static final String OCD_ELEMENT_QNAME = "OCD";
    private static final String DESIGNATE_ELEMENT = "Designate";
    private static final String DESIGNATE_ELEMENT_QNAME = "Designate";
    private static final String OBJECT_ELEMENT = "Object";
    private static final String OBJECT_ELEMENT_QNAME = "Object";
    private static final String AD_ELEMENT = "AD";
    private static final String AD_ELEMENT_QNAME = "AD";
    private static final String OPTION_ELEMENT = "Option";
    private static final String OPTION_ELEMENT_QNAME = "Option";

    public static List<String> generateDescriptors(DescriptionContainer module, Options options, Log logger) throws SCRDescriptorException {
        ArrayList<ComponentContainer> components = new ArrayList<ComponentContainer>();
        for (ComponentContainer component : module.getComponents()) {
            if (component.getMetatypeContainer() == null) continue;
            components.add(component);
        }
        File mtDir = options.getMetaTypeDirectory();
        File parentDir = mtDir.getParentFile();
        if (components.size() > 0) {
            mtDir.mkdirs();
            ArrayList<String> fileNames = new ArrayList<String>();
            List<ComponentContainerUtil.ComponentContainerContainer> containers = ComponentContainerUtil.split(components);
            for (ComponentContainerUtil.ComponentContainerContainer ccc : containers) {
                File useFile = new File(mtDir, ccc.className + ".xml");
                String metatypeLocation = "OSGI-INF/metatype/metatype";
                boolean allInlined = true;
                for (ComponentContainer cc : ccc.components) {
                    MetatypeContainer mc = cc.getMetatypeContainer();
                    if (mc.getName() != null && mc.getName().startsWith("%")) {
                        allInlined = false;
                    }
                    if (mc.getDescription() != null && mc.getDescription().startsWith("%")) {
                        allInlined = false;
                    }
                    for (MetatypeAttributeDefinition mad : mc.getProperties()) {
                        if (mad.getName() != null && mad.getName().startsWith("%")) {
                            allInlined = false;
                        }
                        if (mad.getDescription() == null || !mad.getDescription().startsWith("%")) continue;
                        allInlined = false;
                    }
                }
                if (allInlined) {
                    Properties metatypeProps = new Properties();
                    for (ComponentContainer cc : ccc.components) {
                        String key;
                        MetatypeContainer mc = cc.getMetatypeContainer();
                        String baseKey = cc.getClassDescription().getDescribedClass().getName().replace("$", ".");
                        if (mc.getName() != null) {
                            key = baseKey + ".name";
                            metatypeProps.put(key, mc.getName());
                            mc.setName("%" + key);
                        }
                        if (mc.getDescription() != null) {
                            key = baseKey + ".description";
                            metatypeProps.put(key, mc.getDescription());
                            mc.setDescription("%" + key);
                        }
                        for (MetatypeAttributeDefinition mad : mc.getProperties()) {
                            String key2;
                            if (mad.getName() != null) {
                                key2 = baseKey + "." + mad.getId() + ".name";
                                metatypeProps.put(key2, mad.getName());
                                mad.setName("%" + key2);
                            }
                            if (mad.getDescription() == null) continue;
                            key2 = baseKey + "." + mad.getId() + ".description";
                            metatypeProps.put(key2, mad.getDescription());
                            mad.setDescription("%" + key2);
                        }
                    }
                    if (metatypeProps.size() > 0) {
                        int lastDot = useFile.getName().lastIndexOf(".");
                        String baseName = useFile.getName().substring(0, lastDot);
                        File propsFile = new File(useFile.getParentFile(), baseName + ".properties");
                        try {
                            metatypeProps.store(new FileWriter(propsFile), null);
                        }
                        catch (IOException e) {
                            throw new SCRDescriptorException("Unable to get metatype.properties", propsFile.getAbsolutePath());
                        }
                        fileNames.add(parentDir.getName() + '/' + mtDir.getName() + '/' + propsFile.getName());
                        metatypeLocation = "OSGI-INF/metatype/" + baseName;
                    }
                }
                logger.info("Generating " + ccc.components.size() + " MetaType Descriptors in " + useFile);
                MetaTypeIO.write(module, ccc.components, useFile, metatypeLocation);
                fileNames.add(parentDir.getName() + '/' + mtDir.getName() + '/' + useFile.getName());
            }
            return fileNames;
        }
        if (mtDir.exists()) {
            for (File f : mtDir.listFiles()) {
                if (!f.isFile()) continue;
                logger.debug("Removing obsolete metatype file " + f);
                f.delete();
            }
        }
        return null;
    }

    private static String detectMetatypeVersion(DescriptionContainer container) {
        for (ComponentContainer comp : container.getComponents()) {
            if (comp.getMetatypeContainer() == null) continue;
            for (MetatypeAttributeDefinition ad : comp.getMetatypeContainer().getProperties()) {
                if (!ad.getType().equalsIgnoreCase("password")) continue;
                return NAMESPACE_URI_12;
            }
        }
        return NAMESPACE_URI_10;
    }

    private static void write(DescriptionContainer metaData, List<ComponentContainer> components, File file, String localization) throws SCRDescriptorException {
        String namespace = MetaTypeIO.detectMetatypeVersion(metaData);
        try {
            ContentHandler contentHandler = IOUtils.getSerializer(file);
            contentHandler.startDocument();
            contentHandler.startPrefixMapping(PREFIX, namespace);
            AttributesImpl ai = new AttributesImpl();
            IOUtils.addAttribute(ai, "localization", localization);
            contentHandler.startElement(namespace, METADATA_ELEMENT, METADATA_ELEMENT_QNAME, ai);
            IOUtils.newline(contentHandler);
            for (ComponentContainer comp : components) {
                if (comp.getMetatypeContainer() == null) continue;
                MetaTypeIO.generateOCDXML(comp.getMetatypeContainer(), contentHandler);
                MetaTypeIO.generateDesignateXML(comp.getMetatypeContainer(), contentHandler);
            }
            contentHandler.endElement(namespace, METADATA_ELEMENT, METADATA_ELEMENT_QNAME);
            IOUtils.newline(contentHandler);
            contentHandler.endPrefixMapping(PREFIX);
            contentHandler.endDocument();
        }
        catch (IOException e) {
            throw new SCRDescriptorException("Unable to generate xml", file.toString(), e);
        }
        catch (TransformerException e) {
            throw new SCRDescriptorException("Unable to generate xml", file.toString(), e);
        }
        catch (SAXException e) {
            throw new SCRDescriptorException("Unable to generate xml", file.toString(), e);
        }
    }

    private static void generateOCDXML(MetatypeContainer ocd, ContentHandler contentHandler) throws SAXException {
        AttributesImpl ai = new AttributesImpl();
        IOUtils.addAttribute(ai, "id", ocd.getId());
        IOUtils.addAttribute(ai, "name", ocd.getName());
        IOUtils.addAttribute(ai, "description", ocd.getDescription());
        IOUtils.indent(contentHandler, 1);
        contentHandler.startElement(INNER_NAMESPACE_URI, "OCD", "OCD", ai);
        if (ocd.getProperties().size() > 0) {
            IOUtils.newline(contentHandler);
            for (MetatypeAttributeDefinition ad : ocd.getProperties()) {
                MetaTypeIO.generateAttributeXML(ad, contentHandler);
            }
            IOUtils.indent(contentHandler, 1);
        }
        contentHandler.endElement(INNER_NAMESPACE_URI, "OCD", "OCD");
        IOUtils.newline(contentHandler);
    }

    private static String escapeDefaultValue(String value) {
        if (value == null) {
            return value;
        }
        String result = value.trim();
        result = result.replace(" ", "\\ ");
        result = result.replace(",", "\\,");
        result = result.replace("\\", "\\\\");
        return result;
    }

    private static void generateAttributeXML(MetatypeAttributeDefinition ad, ContentHandler contentHandler) throws SAXException {
        AttributesImpl ai = new AttributesImpl();
        IOUtils.addAttribute(ai, "id", ad.getId());
        IOUtils.addAttribute(ai, "type", ad.getType());
        if (ad.getDefaultMultiValue() != null) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < ad.getDefaultMultiValue().length; ++i) {
                if (i > 0) {
                    buf.append(',');
                }
                buf.append(MetaTypeIO.escapeDefaultValue(ad.getDefaultMultiValue()[i]));
            }
            IOUtils.addAttribute(ai, "default", buf);
        } else {
            IOUtils.addAttribute(ai, "default", MetaTypeIO.escapeDefaultValue(ad.getDefaultValue()));
        }
        IOUtils.addAttribute(ai, "name", ad.getName());
        IOUtils.addAttribute(ai, "description", ad.getDescription());
        IOUtils.addAttribute(ai, "cardinality", ad.getCardinality());
        IOUtils.indent(contentHandler, 2);
        contentHandler.startElement(INNER_NAMESPACE_URI, "AD", "AD", ai);
        if (ad.getOptions() != null && ad.getOptions().size() > 0) {
            IOUtils.newline(contentHandler);
            for (Map.Entry<String, String> entry : ad.getOptions().entrySet()) {
                ai.clear();
                IOUtils.addAttribute(ai, "value", entry.getKey());
                IOUtils.addAttribute(ai, "label", entry.getValue());
                IOUtils.indent(contentHandler, 3);
                contentHandler.startElement(INNER_NAMESPACE_URI, "Option", "Option", ai);
                contentHandler.endElement(INNER_NAMESPACE_URI, "Option", "Option");
                IOUtils.newline(contentHandler);
            }
            IOUtils.indent(contentHandler, 2);
        }
        contentHandler.endElement(INNER_NAMESPACE_URI, "AD", "AD");
        IOUtils.newline(contentHandler);
    }

    private static void generateDesignateXML(MetatypeContainer designate, ContentHandler contentHandler) throws SAXException {
        AttributesImpl ai = new AttributesImpl();
        IOUtils.addAttribute(ai, "pid", designate.getId());
        IOUtils.addAttribute(ai, "factoryPid", designate.getFactoryPid());
        IOUtils.indent(contentHandler, 1);
        contentHandler.startElement(INNER_NAMESPACE_URI, "Designate", "Designate", ai);
        IOUtils.newline(contentHandler);
        MetaTypeIO.generateObjectXML(designate, contentHandler);
        IOUtils.indent(contentHandler, 1);
        contentHandler.endElement(INNER_NAMESPACE_URI, "Designate", "Designate");
        IOUtils.newline(contentHandler);
    }

    private static void generateObjectXML(MetatypeContainer obj, ContentHandler contentHandler) throws SAXException {
        AttributesImpl ai = new AttributesImpl();
        IOUtils.addAttribute(ai, "ocdref", obj.getId());
        IOUtils.indent(contentHandler, 2);
        contentHandler.startElement(INNER_NAMESPACE_URI, "Object", "Object", ai);
        contentHandler.endElement(INNER_NAMESPACE_URI, "Object", "Object");
        IOUtils.newline(contentHandler);
    }
}

