/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.felix.scr.Component;
import org.apache.felix.scr.impl.BundleComponentActivator;
import org.apache.felix.scr.impl.config.ComponentHolder;
import org.apache.felix.scr.impl.helper.ComponentMethods;
import org.apache.felix.scr.impl.manager.AbstractComponentManager;
import org.apache.felix.scr.impl.manager.DependencyManager;
import org.apache.felix.scr.impl.manager.ImmediateComponentManager;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;
import org.apache.felix.scr.impl.metadata.ReferenceMetadata;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentException;
import org.osgi.service.component.ComponentFactory;
import org.osgi.service.component.ComponentInstance;

public class ComponentFactoryImpl
extends AbstractComponentManager
implements ComponentFactory,
ComponentHolder {
    private final Map m_componentInstances = new IdentityHashMap();
    private volatile Dictionary m_configuration = new Hashtable();
    public volatile boolean m_isConfigured;

    public ComponentFactoryImpl(BundleComponentActivator activator, ComponentMetadata metadata) {
        super(activator, metadata, new ComponentMethods());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentInstance newInstance(Dictionary dictionary) {
        ImmediateComponentManager cm = this.createComponentManager();
        this.log(4, "Creating new instance from component factory {0} with configuration {1}", new Object[]{this.getComponentMetadata().getName(), dictionary}, null);
        cm.setFactoryProperties(dictionary);
        cm.enableInternal();
        cm.reconfigure(this.m_configuration);
        cm.activateInternal();
        ComponentInstance instance = cm.getComponentInstance();
        if (instance == null) {
            cm.disposeInternal(5);
            throw new ComponentException("Failed activating component");
        }
        Map map = this.m_componentInstances;
        synchronized (map) {
            this.m_componentInstances.put(cm, cm);
        }
        return instance;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ComponentFactoryImpl)) {
            return false;
        }
        ComponentFactoryImpl other = (ComponentFactoryImpl)object;
        return this.getComponentMetadata().getName().equals(other.getComponentMetadata().getName());
    }

    public int hashCode() {
        return this.getComponentMetadata().getName().hashCode();
    }

    protected boolean createComponent() {
        return true;
    }

    protected void deleteComponent(int reason) {
    }

    protected void registerService() {
        this.log(4, "registering component factory", null);
        this.registerService(new String[]{ComponentFactory.class.getName()});
    }

    public Object getInstance() {
        return null;
    }

    public boolean hasConfiguration() {
        return this.m_isConfigured;
    }

    public Dictionary getProperties() {
        Dictionary props = this.getServiceProperties();
        List depMetaData = this.getComponentMetadata().getDependencies();
        for (ReferenceMetadata rm : depMetaData) {
            if (rm.getTarget() == null) continue;
            props.put(rm.getTargetPropertyName(), rm.getTarget());
        }
        for (Object key : Collections.list(this.m_configuration.keys())) {
            if (!key.toString().endsWith(".target")) continue;
            props.put(key, this.m_configuration.get(key));
        }
        return props;
    }

    public void setServiceProperties(Dictionary serviceProperties) {
        throw new IllegalStateException("ComponentFactory service properties are immutable");
    }

    public Dictionary getServiceProperties() {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("component.name", this.getComponentMetadata().getName());
        ((Dictionary)props).put("component.factory", this.getComponentMetadata().getFactoryIdentifier());
        ((Dictionary)props).put("service.pid", this.getComponentMetadata().getName());
        ((Dictionary)props).put("service.description", "ManagedServiceFactory for Factory Component" + this.getComponentMetadata().getName());
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        return props;
    }

    AbstractComponentManager.State getSatisfiedState() {
        return AbstractComponentManager.Factory.getInstance();
    }

    AbstractComponentManager.State getActiveState() {
        return AbstractComponentManager.Factory.getInstance();
    }

    protected boolean collectDependencies() {
        Map old = this.getDependencyMap();
        if (old == null) {
            HashMap dependenciesMap = new HashMap();
            Iterator i = this.getDependencyManagers();
            while (i.hasNext()) {
                dependenciesMap.put(i.next(), Collections.EMPTY_MAP);
            }
            this.setDependencyMap(old, dependenciesMap);
        }
        return true;
    }

    void update(DependencyManager dependencyManager, ServiceReference ref) {
    }

    void invokeBindMethod(DependencyManager dependencyManager, ServiceReference reference) {
    }

    void invokeUnbindMethod(DependencyManager dependencyManager, ServiceReference oldRef) {
    }

    public ComponentInstance getComponentInstance() {
        return null;
    }

    public void configurationDeleted(String pid) {
        if (pid.equals(this.getComponentMetadata().getConfigurationPid())) {
            this.log(4, "Handling configuration removal", null);
            if (!this.m_isConfigured) {
                this.log(4, "ignoring configuration removal: not currently configured", null);
                return;
            }
            this.m_isConfigured = false;
            this.m_configuration = new Hashtable();
            this.log(4, "Current component factory state={0}", new Object[]{this.getState()}, null);
            if ((this.getState() & 0x100) == 0 && this.getComponentMetadata().isConfigurationRequired()) {
                this.log(4, "Deactivating component factory (required configuration has gone)", null);
                this.deactivateInternal(4, true);
            }
        } else {
            this.log(1, "Component Factory cannot be configured by factory configuration", null);
        }
    }

    public void configurationUpdated(String pid, Dictionary configuration) {
        if (pid.equals(this.getComponentMetadata().getConfigurationPid())) {
            this.log(3, "Configuration PID updated for Component Factory", null);
            if (this.getComponentMetadata().isConfigurationIgnored()) {
                return;
            }
            this.m_configuration = configuration;
            this.m_isConfigured = true;
            this.log(3, "Current ComponentFactory state={0}", new Object[]{this.getState()}, null);
            if (this.getState() == 64) {
                this.log(3, "Verifying if Active Component Factory is still satisfied", null);
                super.updateTargets(this.getProperties());
                if (!this.verifyDependencyManagers(this.m_configuration)) {
                    this.log(4, "Component Factory target filters not satisfied anymore: deactivating", null);
                    this.deactivateInternal(2, false);
                    return;
                }
            }
            if (this.getState() == 4 && this.getComponentMetadata().isConfigurationRequired()) {
                this.log(4, "Attempting to activate unsatisfied component", null);
                this.activateInternal();
            }
        } else {
            this.log(1, "Component Factory cannot be configured by factory configuration", null);
        }
    }

    public Component[] getComponents() {
        List cms = this.getComponentList();
        return cms.toArray(new Component[cms.size()]);
    }

    protected List getComponentList() {
        ArrayList<ComponentFactoryImpl> cms = new ArrayList<ComponentFactoryImpl>();
        cms.add(this);
        this.getComponentManagers(this.m_componentInstances, cms);
        return cms;
    }

    public void enableComponents(boolean async) {
        this.enable(async);
    }

    public void disableComponents(boolean async) {
        this.disable(async);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeComponents(int reason) {
        ArrayList cms = new ArrayList();
        this.getComponentManagers(this.m_componentInstances, cms);
        Iterator i = cms.iterator();
        while (i.hasNext()) {
            ((AbstractComponentManager)i.next()).dispose(reason);
        }
        Map map = this.m_componentInstances;
        synchronized (map) {
            this.m_componentInstances.clear();
        }
        this.dispose(reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposed(ImmediateComponentManager component) {
        Map map = this.m_componentInstances;
        synchronized (map) {
            this.m_componentInstances.remove(component);
        }
    }

    private ImmediateComponentManager createComponentManager() {
        return new ComponentFactoryNewInstance(this.getActivator(), this, this.getComponentMetadata(), this.getComponentMethods());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getComponentManagers(Map componentMap, List componentManagers) {
        if (componentMap != null) {
            Map map = componentMap;
            synchronized (map) {
                componentManagers.addAll(componentMap.values());
            }
        }
    }

    static class ComponentFactoryNewInstance
    extends ImmediateComponentManager {
        public ComponentFactoryNewInstance(BundleComponentActivator activator, ComponentHolder componentHolder, ComponentMetadata metadata, ComponentMethods componentMethods) {
            super(activator, componentHolder, metadata, componentMethods);
        }

        AbstractComponentManager.State getActiveState() {
            return AbstractComponentManager.FactoryInstance.getInstance();
        }
    }
}

