/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.helper;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.felix.scr.impl.Activator;
import org.apache.felix.scr.impl.helper.BaseMethod;
import org.apache.felix.scr.impl.helper.ReadOnlyDictionary;
import org.apache.felix.scr.impl.helper.SimpleLogger;
import org.apache.felix.scr.impl.helper.SuitableMethodNotAccessibleException;
import org.apache.felix.scr.impl.manager.RefPair;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;

public class BindMethod
extends BaseMethod {
    private static final Class OBJECT_CLASS = Object.class;
    private final String m_referenceClassName;
    private static final int SERVICE_REFERENCE = 1;
    private static final int SERVICE_OBJECT = 2;
    private static final int SERVICE_OBJECT_AND_MAP = 3;
    private int m_paramStyle;

    public BindMethod(String methodName, Class componentClass, String referenceClassName, boolean isDS11, boolean isDS12Felix) {
        super(methodName, componentClass, isDS11, isDS12Felix);
        this.m_referenceClassName = referenceClassName;
    }

    protected Method doFindMethod(Class targetClass, boolean acceptPrivate, boolean acceptPackage, SimpleLogger logger) throws SuitableMethodNotAccessibleException, InvocationTargetException {
        Method method;
        boolean suitableMethodNotAccessible = false;
        if (logger.isLogEnabled(4)) {
            logger.log(4, "doFindMethod: Looking for method " + targetClass.getName() + "." + this.getMethodName(), null);
        }
        try {
            method = this.getServiceReferenceMethod(targetClass, acceptPrivate, acceptPackage, logger);
            if (method != null) {
                if (logger.isLogEnabled(4)) {
                    logger.log(4, "doFindMethod: Found Method " + method, null);
                }
                this.m_paramStyle = 1;
                return method;
            }
        }
        catch (SuitableMethodNotAccessibleException ex) {
            suitableMethodNotAccessible = true;
        }
        Class parameterClass = this.getParameterClass(targetClass, logger);
        if (parameterClass != null) {
            if (logger.isLogEnabled(4)) {
                logger.log(4, "doFindMethod: No method taking ServiceReference found, checking method taking " + parameterClass.getName(), null);
            }
            try {
                method = this.getServiceObjectMethod(targetClass, parameterClass, acceptPrivate, acceptPackage, logger);
                if (method != null) {
                    this.m_paramStyle = 2;
                    return method;
                }
            }
            catch (SuitableMethodNotAccessibleException ex) {
                suitableMethodNotAccessible = true;
            }
            try {
                method = this.getServiceObjectAssignableMethod(targetClass, parameterClass, acceptPrivate, acceptPackage, logger);
                if (method != null) {
                    this.m_paramStyle = 2;
                    return method;
                }
            }
            catch (SuitableMethodNotAccessibleException ex) {
                suitableMethodNotAccessible = true;
            }
            if (this.isDS11()) {
                try {
                    method = this.getServiceObjectWithMapMethod(targetClass, parameterClass, acceptPrivate, acceptPackage, logger);
                    if (method != null) {
                        this.m_paramStyle = 3;
                        return method;
                    }
                }
                catch (SuitableMethodNotAccessibleException ex) {
                    suitableMethodNotAccessible = true;
                }
                try {
                    method = this.getServiceObjectAssignableWithMapMethod(targetClass, parameterClass, acceptPrivate, acceptPackage);
                    if (method != null) {
                        this.m_paramStyle = 3;
                        return method;
                    }
                }
                catch (SuitableMethodNotAccessibleException ex) {
                    suitableMethodNotAccessible = true;
                }
            }
        } else if (logger.isLogEnabled(2)) {
            logger.log(2, "doFindMethod: Cannot check for methods taking parameter class " + this.m_referenceClassName + ": " + targetClass.getName() + " does not see it", null);
        }
        if (suitableMethodNotAccessible) {
            logger.log(1, "doFindMethod: Suitable but non-accessible method found in class {0}", new Object[]{targetClass.getName()}, null);
            throw new SuitableMethodNotAccessibleException();
        }
        return null;
    }

    private Class getParameterClass(Class targetClass, SimpleLogger logger) {
        if (logger.isLogEnabled(4)) {
            logger.log(4, "getParameterClass: Looking for interface class {0} through loader of {1}", new Object[]{this.m_referenceClassName, targetClass.getName()}, null);
        }
        try {
            ClassLoader loader = targetClass.getClassLoader();
            if (loader == null) {
                loader = ClassLoader.getSystemClassLoader();
            }
            Class<?> referenceClass = loader.loadClass(this.m_referenceClassName);
            if (logger.isLogEnabled(4)) {
                logger.log(4, "getParameterClass: Found class {0}", new Object[]{referenceClass.getName()}, null);
            }
            return referenceClass;
        }
        catch (ClassNotFoundException cnfe) {
            PackageAdmin pa;
            if (logger.isLogEnabled(4)) {
                logger.log(4, "getParameterClass: Not found through component class, using PackageAdmin service", null);
            }
            if ((pa = (PackageAdmin)Activator.getPackageAdmin()) != null) {
                String referenceClassPackage = this.m_referenceClassName.substring(0, this.m_referenceClassName.lastIndexOf(46));
                ExportedPackage[] pkg = pa.getExportedPackages(referenceClassPackage);
                if (pkg != null) {
                    for (int i = 0; i < pkg.length; ++i) {
                        try {
                            if (logger.isLogEnabled(4)) {
                                logger.log(4, "getParameterClass: Checking Bundle {0}/{1}", new Object[]{pkg[i].getExportingBundle().getSymbolicName(), pkg[i].getExportingBundle().getBundleId()}, null);
                            }
                            Class referenceClass = pkg[i].getExportingBundle().loadClass(this.m_referenceClassName);
                            if (logger.isLogEnabled(4)) {
                                logger.log(4, "getParameterClass: Found class {0}", new Object[]{referenceClass.getName()}, null);
                            }
                            return referenceClass;
                        }
                        catch (ClassNotFoundException cnfe2) {
                            continue;
                        }
                    }
                } else if (logger.isLogEnabled(4)) {
                    logger.log(4, "getParameterClass: No bundles exporting package {0} found", new Object[]{referenceClassPackage}, null);
                }
            } else if (logger.isLogEnabled(4)) {
                logger.log(4, "getParameterClass: PackageAdmin service not available, cannot find class", null);
            }
            if (logger.isLogEnabled(4)) {
                logger.log(4, "getParameterClass: No class found, falling back to class Object", null);
            }
            return OBJECT_CLASS;
        }
    }

    private Method getServiceReferenceMethod(Class targetClass, boolean acceptPrivate, boolean acceptPackage, SimpleLogger logger) throws SuitableMethodNotAccessibleException, InvocationTargetException {
        return this.getMethod(targetClass, this.getMethodName(), new Class[]{SERVICE_REFERENCE_CLASS}, acceptPrivate, acceptPackage, logger);
    }

    private Method getServiceObjectMethod(Class targetClass, Class parameterClass, boolean acceptPrivate, boolean acceptPackage, SimpleLogger logger) throws SuitableMethodNotAccessibleException, InvocationTargetException {
        return this.getMethod(targetClass, this.getMethodName(), new Class[]{parameterClass}, acceptPrivate, acceptPackage, logger);
    }

    private Method getServiceObjectAssignableMethod(Class targetClass, Class parameterClass, boolean acceptPrivate, boolean acceptPackage, SimpleLogger logger) throws SuitableMethodNotAccessibleException {
        Method[] candidateBindMethods = targetClass.getDeclaredMethods();
        boolean suitableNotAccessible = false;
        if (logger.isLogEnabled(4)) {
            logger.log(4, "getServiceObjectAssignableMethod: Checking " + candidateBindMethods.length + " declared method in class " + targetClass.getName(), null);
        }
        for (int i = 0; i < candidateBindMethods.length; ++i) {
            Class<?> theParameter;
            Class<?>[] parameters;
            Method method = candidateBindMethods[i];
            if (logger.isLogEnabled(4)) {
                logger.log(4, "getServiceObjectAssignableMethod: Checking " + method, null);
            }
            if ((parameters = method.getParameterTypes()).length != 1 || !method.getName().equals(this.getMethodName())) continue;
            if (logger.isLogEnabled(4)) {
                logger.log(4, "getServiceObjectAssignableMethod: Considering " + method, null);
            }
            if ((theParameter = parameters[0]).isAssignableFrom(parameterClass)) {
                if (BindMethod.accept(method, acceptPrivate, acceptPackage, false)) {
                    return method;
                }
                suitableNotAccessible = true;
                continue;
            }
            if (!logger.isLogEnabled(4)) continue;
            logger.log(4, "getServiceObjectAssignableMethod: Parameter failure: Required " + theParameter + "; actual " + parameterClass.getName(), null);
        }
        if (suitableNotAccessible) {
            throw new SuitableMethodNotAccessibleException();
        }
        return null;
    }

    private Method getServiceObjectWithMapMethod(Class targetClass, Class parameterClass, boolean acceptPrivate, boolean acceptPackage, SimpleLogger logger) throws SuitableMethodNotAccessibleException, InvocationTargetException {
        return this.getMethod(targetClass, this.getMethodName(), new Class[]{parameterClass, MAP_CLASS}, acceptPrivate, acceptPackage, logger);
    }

    private Method getServiceObjectAssignableWithMapMethod(Class targetClass, Class parameterClass, boolean acceptPrivate, boolean acceptPackage) throws SuitableMethodNotAccessibleException {
        Method[] candidateBindMethods = targetClass.getDeclaredMethods();
        boolean suitableNotAccessible = false;
        for (int i = 0; i < candidateBindMethods.length; ++i) {
            Method method = candidateBindMethods[i];
            Class<?>[] parameters = method.getParameterTypes();
            if (parameters.length != 2 || !method.getName().equals(this.getMethodName()) || !parameters[0].isAssignableFrom(parameterClass) || parameters[1] != MAP_CLASS) continue;
            if (BindMethod.accept(method, acceptPrivate, acceptPackage, false)) {
                return method;
            }
            suitableNotAccessible = true;
        }
        if (suitableNotAccessible) {
            throw new SuitableMethodNotAccessibleException();
        }
        return null;
    }

    public boolean getServiceObject(RefPair refPair, BundleContext context, SimpleLogger logger) {
        if (refPair.getServiceObject() == null && this.methodExists(logger) && (this.m_paramStyle == 2 || this.m_paramStyle == 3)) {
            Object service = context.getService(refPair.getRef());
            if (service == null) {
                refPair.setFailed();
                logger.log(2, "Could not get service from ref {0}", new Object[]{refPair.getRef()}, null);
                return false;
            }
            if (!refPair.setServiceObject(service)) {
                context.ungetService(refPair.getRef());
            }
            return true;
        }
        return true;
    }

    protected Object[] getParameters(Method method, Object rawParameter) {
        RefPair refPair = (RefPair)rawParameter;
        if (this.m_paramStyle == 1) {
            return new Object[]{refPair.getRef()};
        }
        if (this.m_paramStyle == 2) {
            return new Object[]{refPair.getServiceObject()};
        }
        if (this.m_paramStyle == 3) {
            return new Object[]{refPair.getServiceObject(), new ReadOnlyDictionary(refPair.getRef())};
        }
        throw new IllegalStateException("Unexpected m_paramStyle of " + this.m_paramStyle);
    }

    protected String getMethodNamePrefix() {
        return "bind";
    }

    public static interface Service {
        public ServiceReference getReference();

        public Object getInstance();
    }
}

