/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.felix.scr.impl.BundleComponentActivator;
import org.apache.felix.scr.impl.config.ComponentContainer;
import org.apache.felix.scr.impl.helper.ActivatorParameter;
import org.apache.felix.scr.impl.helper.ComponentMethods;
import org.apache.felix.scr.impl.helper.MethodResult;
import org.apache.felix.scr.impl.helper.ModifiedMethod;
import org.apache.felix.scr.impl.helper.SimpleLogger;
import org.apache.felix.scr.impl.manager.AbstractComponentManager;
import org.apache.felix.scr.impl.manager.ComponentContextImpl;
import org.apache.felix.scr.impl.manager.DependencyManager;
import org.apache.felix.scr.impl.manager.EdgeInfo;
import org.apache.felix.scr.impl.manager.RefPair;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentInstance;
import org.osgi.util.promise.Deferred;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleComponentManager<S>
extends AbstractComponentManager<S>
implements ServiceFactory<S> {
    private final AtomicInteger m_useCount = new AtomicInteger();
    private volatile ComponentContextImpl<S> m_componentContext;
    private Map<String, Object> m_configurationProperties;
    private Map<String, Object> m_factoryProperties;
    private Map<String, Object> m_properties;
    private Dictionary<String, Object> m_serviceProperties;
    private final ThreadLocal<Boolean> m_circularReferences = new ThreadLocal();

    public SingleComponentManager(ComponentContainer<S> container, ComponentMethods componentMethods) {
        this(container, componentMethods, false);
    }

    public SingleComponentManager(ComponentContainer<S> container, ComponentMethods componentMethods, boolean factoryInstance) {
        super(container, componentMethods, factoryInstance);
    }

    @Override
    void clear() {
        this.m_container.disposed(this);
        super.clear();
    }

    private boolean createComponent(ComponentContextImpl<S> componentContext) {
        if (!this.isStateLocked()) {
            throw new IllegalStateException("need write lock (createComponent)");
        }
        if (this.m_componentContext == null) {
            S tmpComponent = this.createImplementationObject(null, new SetImplementationObject<S>(){

                @Override
                public void presetComponentContext(ComponentContextImpl<S> componentContext) {
                    SingleComponentManager.this.m_componentContext = componentContext;
                }

                @Override
                public void resetImplementationObject(S implementationObject) {
                    SingleComponentManager.this.m_componentContext = null;
                }
            }, componentContext);
            if (tmpComponent == null) {
                return false;
            }
            this.log(4, "Set implementation object for component {0}", new Object[]{this.getName()}, null);
            BundleComponentActivator activator = this.getActivator();
            if (activator != null) {
                activator.missingServicePresent(this.getServiceReference());
            }
        }
        return true;
    }

    @Override
    protected void deleteComponent(int reason) {
        if (!this.isStateLocked()) {
            throw new IllegalStateException("need write lock (deleteComponent)");
        }
        if (this.m_componentContext != null) {
            this.m_useCount.set(0);
            this.disposeImplementationObject(this.m_componentContext, reason);
            this.m_componentContext.cleanup();
            this.m_componentContext = null;
            this.log(4, "Unset and deconfigured implementation object for component {0} in deleteComponent for reason {1}", new Object[]{this.getName(), REASONS[reason]}, null);
            this.clearServiceProperties();
        }
    }

    void clearServiceProperties() {
        this.m_properties = null;
        this.m_serviceProperties = null;
    }

    public ComponentInstance getComponentInstance() {
        return this.m_componentContext == null ? null : this.m_componentContext.getComponentInstance();
    }

    private S getInstance() {
        return this.m_componentContext == null ? null : (S)this.m_componentContext.getImplementationObject(true);
    }

    protected S createImplementationObject(Bundle usingBundle, SetImplementationObject<S> setter, ComponentContextImpl<S> componentContext) {
        Object implementationObject;
        Bundle bundle = this.getBundle();
        if (bundle == null) {
            this.log(2, "Bundle shut down during instantiation of the implementation object", null);
            return null;
        }
        try {
            Class implementationObjectClass = bundle.loadClass(this.getComponentMetadata().getImplementationClassName());
            implementationObject = implementationObjectClass.newInstance();
        }
        catch (Throwable t) {
            this.log(1, "Error during instantiation of the implementation object", t);
            return null;
        }
        componentContext.setImplementationObject(implementationObject);
        setter.presetComponentContext(componentContext);
        DependencyManager failedDm = null;
        for (DependencyManager dependencyManager : this.getDependencyManagers()) {
            if (failedDm == null) {
                boolean bl = dependencyManager.open(componentContext, componentContext.getEdgeInfo(dependencyManager));
                if (bl) continue;
                this.log(1, "Cannot create component instance due to failure to bind reference {0}", new Object[]{dependencyManager.getName()}, null);
                failedDm = dependencyManager;
                continue;
            }
            componentContext.getEdgeInfo(dependencyManager).ignore();
        }
        if (failedDm != null) {
            boolean skip = true;
            for (DependencyManager dependencyManager : this.getReversedDependencyManagers()) {
                if (skip && failedDm == dependencyManager) {
                    skip = false;
                }
                if (!skip) {
                    dependencyManager.close(componentContext, componentContext.getEdgeInfo(dependencyManager));
                }
                dependencyManager.deactivate();
            }
            setter.resetImplementationObject(implementationObject);
            return null;
        }
        MethodResult result = this.getComponentMethods().getActivateMethod().invoke(implementationObject, new ActivatorParameter(componentContext, 1), (MethodResult)null, (SimpleLogger)this);
        if (result == null) {
            for (DependencyManager dependencyManager : this.getReversedDependencyManagers()) {
                dependencyManager.close(componentContext, componentContext.getEdgeInfo(dependencyManager));
            }
            setter.resetImplementationObject(implementationObject);
            return null;
        }
        componentContext.setImplementationAccessible(true);
        this.m_circularReferences.remove();
        this.setServiceProperties(result);
        return (S)implementationObject;
    }

    protected void disposeImplementationObject(ComponentContextImpl<S> componentContext, int reason) {
        componentContext.setImplementationAccessible(false);
        S implementationObject = componentContext.getImplementationObject(false);
        if (implementationObject != null) {
            MethodResult result = this.getComponentMethods().getDeactivateMethod().invoke((Object)implementationObject, new ActivatorParameter(componentContext, reason), (MethodResult)null, (SimpleLogger)this);
            if (result != null) {
                this.setServiceProperties(result);
            }
            for (DependencyManager<S, ?> md : this.getReversedDependencyManagers()) {
                md.close(componentContext, componentContext.getEdgeInfo(md));
            }
        }
    }

    @Override
    boolean hasInstance() {
        return this.m_componentContext != null;
    }

    @Override
    <T> void invokeBindMethod(DependencyManager<S, T> dependencyManager, RefPair<S, T> refPair, int trackingCount) {
        ComponentContextImpl<S> componentContext = this.m_componentContext;
        if (componentContext != null) {
            EdgeInfo info = componentContext.getEdgeInfo(dependencyManager);
            dependencyManager.invokeBindMethod(componentContext, refPair, trackingCount, info);
        }
    }

    @Override
    <T> boolean invokeUpdatedMethod(DependencyManager<S, T> dependencyManager, RefPair<S, T> refPair, int trackingCount) {
        ComponentContextImpl<S> componentContext = this.m_componentContext;
        if (componentContext != null) {
            EdgeInfo info = componentContext.getEdgeInfo(dependencyManager);
            return dependencyManager.invokeUpdatedMethod(componentContext, refPair, trackingCount, info);
        }
        return false;
    }

    @Override
    <T> void invokeUnbindMethod(DependencyManager<S, T> dependencyManager, RefPair<S, T> oldRefPair, int trackingCount) {
        ComponentContextImpl<S> componentContext = this.m_componentContext;
        if (componentContext != null) {
            EdgeInfo info = componentContext.getEdgeInfo(dependencyManager);
            dependencyManager.invokeUnbindMethod(componentContext, oldRefPair, trackingCount, info);
        }
    }

    protected void setFactoryProperties(Dictionary<String, ?> dictionary) {
        this.m_factoryProperties = SingleComponentManager.copyToMap(dictionary, true);
    }

    @Override
    void registerComponentId() {
        super.registerComponentId();
        this.m_properties = null;
    }

    @Override
    void unregisterComponentId() {
        super.unregisterComponentId();
        this.m_properties = null;
    }

    @Override
    public Map<String, Object> getProperties() {
        if (this.m_properties == null) {
            HashMap<String, Object> props = new HashMap<String, Object>();
            if (this.m_configurationProperties != null) {
                props.putAll(this.m_configurationProperties);
            }
            if (this.m_factoryProperties != null) {
                props.putAll(this.m_factoryProperties);
                if (this.getComponentMetadata().getDSVersion().isDS13() && this.m_factoryProperties.containsKey("service.pid")) {
                    ArrayList<String> servicePids = new ArrayList<String>();
                    Object configPropServicePids = this.m_configurationProperties.get("service.pid");
                    if (configPropServicePids instanceof List) {
                        servicePids.addAll((List)configPropServicePids);
                    } else {
                        servicePids.add(configPropServicePids.toString());
                    }
                    if (this.m_factoryProperties.get("service.pid") instanceof String) {
                        servicePids.add((String)this.m_factoryProperties.get("service.pid"));
                    }
                    if (servicePids.size() == 1) {
                        props.put("service.pid", servicePids.get(0));
                    } else {
                        props.put("service.pid", servicePids);
                    }
                }
            }
            props.put("component.name", this.getComponentMetadata().getName());
            props.put("component.id", this.getId());
            this.m_properties = props;
        }
        return this.m_properties;
    }

    @Override
    public void setServiceProperties(Dictionary<String, ?> serviceProperties) {
        if (serviceProperties == null || serviceProperties.isEmpty()) {
            this.m_serviceProperties = null;
        } else {
            this.m_serviceProperties = SingleComponentManager.copyToDictionary(serviceProperties, false);
            this.m_serviceProperties.put("component.name", this.getComponentMetadata().getName());
            this.m_serviceProperties.put("component.id", this.getId());
        }
        this.updateServiceRegistration();
    }

    @Override
    public Dictionary<String, Object> getServiceProperties() {
        if (this.m_serviceProperties != null) {
            return this.m_serviceProperties;
        }
        return super.getServiceProperties();
    }

    private void updateServiceRegistration() {
        ServiceRegistration sr = this.getServiceRegistration();
        if (sr != null) {
            try {
                Dictionary<String, Object> regProps = this.getServiceProperties();
                if (!this.servicePropertiesMatches(sr, regProps)) {
                    sr.setProperties(regProps);
                }
            }
            catch (IllegalStateException ise) {
            }
            catch (IllegalArgumentException iae) {
                this.log(1, "Unexpected configuration property problem when updating service registration", iae);
            }
            catch (Throwable t) {
                this.log(1, "Unexpected problem when updating service registration", t);
            }
        }
    }

    @Override
    public void reconfigure(Map<String, Object> configuration, boolean configurationDeleted) {
        this.m_configurationProperties = configuration;
        this.reconfigure(configurationDeleted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reconfigure(boolean configurationDeleted) {
        Deferred<Void> enableLatch = this.enableLatchWait();
        try {
            this.m_properties = null;
            if (this.m_disposed || !this.m_internalEnabled) {
                this.log(4, "Component can not be activated since it is in state {0}", new Object[]{this.getState()}, null);
                Object var10_3 = null;
                enableLatch.resolve(null);
                return;
            }
            this.obtainActivationWriteLock();
            if (this.isSatisfied() || this.getComponentMetadata().isConfigurationIgnored()) break block10;
            this.log(4, "Attempting to activate unsatisfied component", null);
            this.updateTargets(this.getProperties());
            this.releaseActivationWriteeLock();
            this.activateInternal();
            Object var8_7 = null;
            this.releaseActivationWriteeLock();
        }
        catch (Throwable throwable) {
            Object var10_6 = null;
            enableLatch.resolve(null);
            throw throwable;
        }
        Object var10_4 = null;
        enableLatch.resolve(null);
        {
            block10: {
                return;
            }
            try {
                if (!this.modify(configurationDeleted)) {
                    this.log(4, "Deactivating and Activating to reconfigure from configuration", null);
                    int reason = configurationDeleted ? 4 : 3;
                    this.releaseActivationWriteeLock();
                    boolean dispose = this.m_factoryInstance;
                    this.deactivateInternal(reason, dispose, dispose);
                    if (!dispose) {
                        this.obtainActivationWriteLock();
                        try {
                            this.updateTargets(this.getProperties());
                            Object var6_12 = null;
                        }
                        catch (Throwable throwable) {
                            Object var6_13 = null;
                            this.releaseActivationWriteeLock();
                            throw throwable;
                        }
                        this.releaseActivationWriteeLock();
                        this.activateInternal();
                    }
                }
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.releaseActivationWriteeLock();
                throw throwable;
            }
            this.releaseActivationWriteeLock();
            {
            }
        }
        Object var10_5 = null;
        enableLatch.resolve(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean modify(boolean configurationDeleted) {
        MethodResult result;
        block10: {
            block9: {
                boolean bl;
                if (configurationDeleted && !this.getComponentMetadata().isDeleteCallsModify()) {
                    return false;
                }
                if (this.getComponentMetadata().getModified() == null) {
                    this.log(4, "No modified method, cannot update dynamically", null);
                    return false;
                }
                Map<String, Object> props = this.getProperties();
                for (DependencyManager dm : this.getDependencyManagers()) {
                    if (dm.canUpdateDynamically(props)) continue;
                    this.log(4, "Cannot dynamically update the configuration due to dependency changes induced on dependency {0}", new Object[]{dm.getName()}, null);
                    return false;
                }
                this.obtainStateLock();
                try {
                    result = this.invokeModifiedMethod();
                    this.updateTargets(props);
                    if (result != null) break block9;
                    this.log(1, "Declared modify method ''{0}'' cannot be found, configuring by reactivation", new Object[]{this.getComponentMetadata().getModified()}, null);
                    bl = false;
                    Object var6_8 = null;
                }
                catch (Throwable throwable) {
                    Object var6_11 = null;
                    this.releaseStateLock();
                    throw throwable;
                }
                this.releaseStateLock();
                return bl;
            }
            if (this.verifyDependencyManagers()) break block10;
            this.log(1, "Updating the service references caused at least on reference to become unsatisfied, deactivating component", null);
            boolean bl = false;
            Object var6_9 = null;
            this.releaseStateLock();
            return bl;
        }
        if (result.hasResult()) {
            this.setServiceProperties(result);
        } else {
            this.updateServiceRegistration();
        }
        boolean bl = true;
        Object var6_10 = null;
        this.releaseStateLock();
        return bl;
    }

    protected MethodResult invokeModifiedMethod() {
        ModifiedMethod modifiedMethod = this.getComponentMethods().getModifiedMethod();
        if (this.getInstance() != null) {
            return modifiedMethod.invoke(this.getInstance(), new ActivatorParameter(this.m_componentContext, -1), MethodResult.VOID, (SimpleLogger)this);
        }
        return MethodResult.VOID;
    }

    private boolean servicePropertiesMatches(ServiceRegistration<S> reg, Dictionary<String, Object> props) {
        Hashtable<String, Object> regProps = new Hashtable<String, Object>();
        String[] keys = reg.getReference().getPropertyKeys();
        for (int i = 0; keys != null && i < keys.length; ++i) {
            if (keys[i].equals("objectClass") || keys[i].equals("service.id")) continue;
            ((Dictionary)regProps).put(keys[i], reg.getReference().getProperty(keys[i]));
        }
        return ((Object)regProps).equals(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S getService(Bundle bundle, ServiceRegistration<S> serviceRegistration) {
        S s;
        block7: {
            boolean decrement;
            block5: {
                S s2;
                block6: {
                    this.obtainStateLock();
                    try {
                        this.m_useCount.incrementAndGet();
                        Object var4_3 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        this.releaseStateLock();
                        throw throwable;
                    }
                    this.releaseStateLock();
                    decrement = true;
                    try {
                        boolean success = this.getServiceInternal();
                        ComponentContextImpl<S> componentContext = this.m_componentContext;
                        if (!success || componentContext == null) break block5;
                        decrement = false;
                        s2 = componentContext.getImplementationObject(true);
                        Object var8_11 = null;
                        if (!decrement) break block6;
                        this.ungetService(bundle, serviceRegistration, null);
                    }
                    catch (Throwable throwable) {
                        block8: {
                            Object var8_13 = null;
                            if (!decrement) break block8;
                            this.ungetService(bundle, serviceRegistration, null);
                        }
                        throw throwable;
                    }
                }
                return s2;
            }
            s = null;
            Object var8_12 = null;
            if (!decrement) break block7;
            this.ungetService(bundle, serviceRegistration, null);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean getServiceInternal() {
        if (this.m_circularReferences.get() != null) {
            this.log(1, "Circular reference detected, getService returning null", null);
            this.dumpThreads();
            return false;
        }
        this.m_circularReferences.set(Boolean.TRUE);
        try {
            boolean success = true;
            if (this.m_componentContext == null) {
                ComponentContextImpl componentContext = new ComponentContextImpl(this, this.getBundle());
                if (this.collectDependencies(componentContext)) {
                    this.log(4, "getService (single component manager) dependencies collected.", null);
                } else {
                    this.log(3, "Could not obtain all required dependencies, getService returning null", null);
                    success = false;
                }
                this.obtainStateLock();
                try {
                    if (this.m_componentContext == null) {
                        Object result = this.getService(componentContext);
                        if (result == null) {
                            success = false;
                        } else {
                            this.m_activated = true;
                        }
                    }
                    Object var5_5 = null;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    this.releaseStateLock();
                    throw throwable;
                }
                this.releaseStateLock();
                {
                }
            }
            boolean bl = success;
            Object var7_8 = null;
            this.m_circularReferences.remove();
            return bl;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.m_circularReferences.remove();
            throw throwable;
        }
    }

    private S getService(ComponentContextImpl<S> componentContext) {
        if (!this.isInternalEnabled()) {
            return null;
        }
        if (this.createComponent(componentContext)) {
            return this.getInstance();
        }
        this.log(1, "Failed creating the component instance; see log for reason", null);
        try {
            this.deleteComponent(0);
        }
        catch (Throwable t) {
            this.log(4, "Cannot delete incomplete component instance. Ignoring.", t);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ungetService(Bundle bundle, ServiceRegistration<S> serviceRegistration, S o) {
        this.obtainStateLock();
        try {
            if (this.m_useCount.decrementAndGet() == 0 && !this.isImmediate() && !this.keepInstances()) {
                this.ungetService();
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.releaseStateLock();
            throw throwable;
        }
        this.releaseStateLock();
    }

    private void ungetService() {
        this.deleteComponent(0);
    }

    private boolean keepInstances() {
        return this.getComponentMetadata().isDelayedKeepInstances();
    }

    @Override
    public void getComponentManagers(List<AbstractComponentManager<S>> cms) {
        cms.add(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface SetImplementationObject<S> {
        public void presetComponentContext(ComponentContextImpl<S> var1);

        public void resetImplementationObject(S var1);
    }
}

