/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.logger;

import java.text.MessageFormat;
import org.apache.felix.scr.impl.logger.InternalLogger;
import org.apache.felix.scr.impl.manager.ScrConfiguration;
import org.osgi.framework.Bundle;

public abstract class AbstractLogger {
    private final ScrConfiguration config;
    private volatile String prefix;

    AbstractLogger(ScrConfiguration config, String prefix) {
        this.config = config;
        this.prefix = prefix;
    }

    ScrConfiguration getConfiguration() {
        return this.config;
    }

    void setPrefix(String value) {
        this.prefix = value;
    }

    String getPrefix() {
        return this.prefix;
    }

    abstract InternalLogger getLogger();

    public boolean isLogEnabled(int level) {
        return this.config.getLogLevel() >= level && this.getLogger().isLogEnabled(level);
    }

    public boolean log(int level, String pattern, Throwable ex, Object ... arguments) {
        if (this.isLogEnabled(level)) {
            this.getLogger().log(level, this.format(pattern, arguments), ex);
            return true;
        }
        return false;
    }

    public boolean log(int level, String message, Throwable ex) {
        if (this.isLogEnabled(level)) {
            this.getLogger().log(level, this.prefix.concat(" ").concat(message), ex);
            return true;
        }
        return false;
    }

    static String getBundleIdentifier(Bundle bundle) {
        StringBuilder sb = new StringBuilder("bundle ");
        if (bundle.getSymbolicName() != null) {
            sb.append(bundle.getSymbolicName());
            sb.append(':');
            sb.append(bundle.getVersion());
            sb.append(" (");
            sb.append(bundle.getBundleId());
            sb.append(")");
        } else {
            sb.append(bundle.getBundleId());
        }
        return sb.toString();
    }

    private String format(String pattern, Object ... arguments) {
        String message;
        if (arguments == null || arguments.length == 0) {
            message = pattern;
        } else {
            for (int i = 0; i < arguments.length; ++i) {
                if (!(arguments[i] instanceof Bundle)) continue;
                arguments[i] = AbstractLogger.getBundleIdentifier((Bundle)arguments[i]);
            }
            message = MessageFormat.format(pattern, arguments);
        }
        return this.prefix.concat(message);
    }
}

