/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.shell.remote;

import java.io.IOException;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.apache.felix.shell.remote.Activator;
import org.apache.felix.shell.remote.AtomicInteger;
import org.apache.felix.shell.remote.Shell;
import org.osgi.framework.BundleContext;

class Listener {
    private int m_Port;
    private Thread m_ListenerThread;
    private boolean m_Stop = false;
    private ServerSocket m_ServerSocket;
    private AtomicInteger m_UseCounter;
    private int m_MaxConnections;
    private static final String INUSE_MESSAGE = "Connection refused.\r\nAll possible connections are currently being used.\r\n";

    Listener() {
    }

    public void activate(BundleContext bundleContext) {
        this.m_Port = this.getProperty(bundleContext, "osgi.shell.telnet.port", 6666);
        this.m_MaxConnections = this.getProperty(bundleContext, "osgi.shell.telnet.maxconn", 2);
        this.m_UseCounter = new AtomicInteger(0);
        this.m_ListenerThread = new Thread((Runnable)new Acceptor(), "telnetconsole.Listener");
        this.m_ListenerThread.start();
    }

    public void deactivate() {
        try {
            this.m_Stop = true;
            this.m_ServerSocket.close();
            this.m_ListenerThread.join();
        }
        catch (Exception ex) {
            Activator.getServices().error("Listener::deactivate()", ex);
        }
    }

    private int getProperty(BundleContext bundleContext, String propName, int defaultValue) {
        String propValue = bundleContext.getProperty(propName);
        if (propValue != null) {
            try {
                return Integer.parseInt(propValue);
            }
            catch (NumberFormatException ex) {
                Activator.getServices().error("Listener::activate()", ex);
            }
        }
        return defaultValue;
    }

    private class Acceptor
    implements Runnable {
        private Acceptor() {
        }

        public void run() {
            try {
                Listener.this.m_ServerSocket = new ServerSocket(Listener.this.m_Port, 1);
                do {
                    try {
                        Socket s = Listener.this.m_ServerSocket.accept();
                        if (Listener.this.m_UseCounter.get() >= Listener.this.m_MaxConnections) {
                            PrintStream out = new PrintStream(s.getOutputStream());
                            out.print(Listener.INUSE_MESSAGE);
                            out.flush();
                            out.close();
                            s.close();
                            continue;
                        }
                        Listener.this.m_UseCounter.increment();
                        Thread connectionThread = new Thread(new Shell(s, Listener.this.m_UseCounter));
                        connectionThread.start();
                    }
                    catch (SocketException ex) {
                        // empty catch block
                    }
                } while (!Listener.this.m_Stop);
            }
            catch (IOException e) {
                Activator.getServices().error("Listener.Acceptor::activate()", e);
            }
        }
    }
}

