/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.plugins.ds.internal;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.felix.webconsole.bundleinfo.BundleInfo;
import org.apache.felix.webconsole.bundleinfo.BundleInfoProvider;
import org.apache.felix.webconsole.bundleinfo.BundleInfoType;
import org.apache.felix.webconsole.i18n.LocalizationHelper;
import org.apache.felix.webconsole.plugins.ds.internal.ComponentConfigurationPrinter;
import org.apache.felix.webconsole.plugins.ds.internal.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentConfigurationDTO;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;

class InfoProvider
implements BundleInfoProvider {
    private final LocalizationHelper localization;
    private final ServiceComponentRuntime scrService;

    InfoProvider(Bundle bundle, Object scrService) {
        this.scrService = (ServiceComponentRuntime)scrService;
        this.localization = new LocalizationHelper(bundle);
    }

    public String getName(Locale locale) {
        return this.localization.getResourceBundle(locale).getString("info.name");
    }

    public BundleInfo[] getBundleInfo(Bundle bundle, String webConsoleRoot, Locale locale) {
        ArrayList<ComponentDescriptionDTO> descriptions = new ArrayList<ComponentDescriptionDTO>();
        ArrayList<ComponentConfigurationDTO> configurations = new ArrayList<ComponentConfigurationDTO>();
        Collection descs = this.scrService.getComponentDescriptionDTOs(new Bundle[]{bundle});
        for (ComponentDescriptionDTO d : descs) {
            for (ComponentConfigurationDTO cfg : this.scrService.getComponentConfigurationDTOs(d)) {
                configurations.add(cfg);
            }
            descriptions.add(d);
        }
        Collections.sort(configurations, Util.COMPONENT_COMPARATOR);
        if (configurations.size() == 0) {
            return NO_INFO;
        }
        BundleInfo[] ret = new BundleInfo[configurations.size()];
        int i = 0;
        for (ComponentConfigurationDTO cfg : configurations) {
            ret[i] = this.toInfo(cfg, webConsoleRoot, locale);
            ++i;
        }
        return ret;
    }

    private BundleInfo toInfo(ComponentConfigurationDTO cfg, String webConsoleRoot, Locale locale) {
        ResourceBundle bundle = this.localization.getResourceBundle(locale);
        String state = ComponentConfigurationPrinter.toStateString(cfg.state);
        String name = cfg.description.name;
        String descr = bundle.getString("info.descr");
        String key = bundle.getString("info.key");
        key = MessageFormat.format(key, String.valueOf(cfg.id), name != null ? name : "", state);
        return new BundleInfo(key, (Object)(webConsoleRoot + "/components/" + cfg.id), BundleInfoType.LINK, descr);
    }

    ServiceRegistration register(BundleContext context) {
        return context.registerService(BundleInfoProvider.class.getName(), (Object)this, null);
    }
}

