/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.plugins.ds.internal;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.felix.inventory.Format;
import org.apache.felix.inventory.InventoryPrinter;
import org.apache.felix.webconsole.WebConsoleUtil;
import org.apache.felix.webconsole.plugins.ds.internal.JSONWriter;
import org.apache.felix.webconsole.plugins.ds.internal.Util;
import org.apache.felix.webconsole.plugins.ds.internal.WebConsolePlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.dto.ServiceReferenceDTO;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentConfigurationDTO;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;
import org.osgi.service.component.runtime.dto.ReferenceDTO;
import org.osgi.service.component.runtime.dto.SatisfiedReferenceDTO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ComponentConfigurationPrinter
implements InventoryPrinter {
    private final ServiceComponentRuntime scrService;
    private final WebConsolePlugin plugin;

    ComponentConfigurationPrinter(Object scrService, WebConsolePlugin plugin) {
        this.scrService = (ServiceComponentRuntime)scrService;
        this.plugin = plugin;
    }

    public void print(PrintWriter pw, Format format, boolean isZip) {
        ArrayList<ComponentDescriptionDTO> disabled = new ArrayList<ComponentDescriptionDTO>();
        ArrayList<ComponentConfigurationDTO> configurations = new ArrayList<ComponentConfigurationDTO>();
        Collection descs = this.scrService.getComponentDescriptionDTOs(new Bundle[0]);
        for (ComponentDescriptionDTO d : descs) {
            if (!this.scrService.isComponentEnabled(d)) {
                disabled.add(d);
            }
            configurations.addAll(this.scrService.getComponentConfigurationDTOs(d));
        }
        Collections.sort(configurations, Util.COMPONENT_COMPARATOR);
        if (Format.JSON.equals(format)) {
            this.printComponentsJson(pw, disabled, configurations, isZip);
        } else {
            ComponentConfigurationPrinter.printComponentsText(pw, disabled, configurations);
        }
    }

    private final void printComponentsJson(PrintWriter pw, List<ComponentDescriptionDTO> disabled, List<ComponentConfigurationDTO> configurations, boolean details) {
        JSONWriter jw = new JSONWriter(pw);
        jw.object();
        jw.key("components");
        jw.array();
        for (ComponentDescriptionDTO cd : disabled) {
            this.plugin.disabledComponent(jw, cd);
        }
        for (ComponentConfigurationDTO cfg : configurations) {
            this.plugin.component(jw, cfg, details);
        }
        jw.endArray();
        jw.endObject();
    }

    private static final void printComponentsText(PrintWriter pw, List<ComponentDescriptionDTO> disabled, List<ComponentConfigurationDTO> configurations) {
        if (!disabled.isEmpty()) {
            pw.println("Disabled components:");
        }
        for (ComponentDescriptionDTO cd : disabled) {
            ComponentConfigurationPrinter.disabledComponent(pw, cd);
        }
        if (configurations.size() == 0) {
            pw.println("Status: No Component Configurations");
        } else {
            pw.println("Component Configurations:");
            TreeMap<Long, ComponentConfigurationDTO> componentMap = new TreeMap<Long, ComponentConfigurationDTO>();
            for (ComponentConfigurationDTO cfg : configurations) {
                componentMap.put(new Long(cfg.id), cfg);
            }
            for (ComponentConfigurationDTO cfg : componentMap.values()) {
                ComponentConfigurationPrinter.component(pw, cfg);
            }
        }
    }

    private static final void component(PrintWriter pw, ComponentConfigurationDTO cfg) {
        pw.print(cfg.id);
        pw.print("=[");
        pw.print(cfg.description.name);
        pw.println("]");
        pw.println("  Bundle" + cfg.description.bundle.symbolicName + " (" + cfg.description.bundle.id + ")");
        pw.println("  State=" + ComponentConfigurationPrinter.toStateString(cfg.state));
        pw.println("  DefaultState=" + (cfg.description.defaultEnabled ? "enabled" : "disabled"));
        pw.println("  Activation=" + (cfg.description.immediate ? "immediate" : "delayed"));
        ComponentConfigurationPrinter.listServices(pw, cfg);
        ComponentConfigurationPrinter.listReferences(pw, cfg);
        ComponentConfigurationPrinter.listProperties(pw, cfg);
        pw.println();
    }

    private static final void disabledComponent(PrintWriter pw, ComponentDescriptionDTO cfg) {
        pw.print(cfg.name);
        pw.println("  Bundle" + cfg.bundle.symbolicName + " (" + cfg.bundle.id + ")");
        pw.println("  DefaultState=" + (cfg.defaultEnabled ? "enabled" : "disabled"));
        pw.println("  Activation=" + (cfg.immediate ? "immediate" : "delayed"));
        pw.println();
    }

    private static void listServices(PrintWriter pw, ComponentConfigurationDTO cfg) {
        String[] services = cfg.description.serviceInterfaces;
        if (services == null) {
            return;
        }
        pw.println("  ServiceType=" + cfg.description.scope);
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < services.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(services[i]);
        }
        pw.println("  Services=" + buf);
    }

    private static SatisfiedReferenceDTO findReference(ComponentConfigurationDTO component, String name) {
        for (SatisfiedReferenceDTO dto : component.satisfiedReferences) {
            if (!dto.name.equals(name)) continue;
            return dto;
        }
        return null;
    }

    private static final void listReferences(PrintWriter pw, ComponentConfigurationDTO cfg) {
        for (ReferenceDTO dto : cfg.description.references) {
            SatisfiedReferenceDTO satisfiedRef = ComponentConfigurationPrinter.findReference(cfg, dto.name);
            pw.println("  Reference=" + dto.name + ", " + (satisfiedRef != null ? "Satisfied" : "Unsatisfied"));
            pw.println("    Service Name: " + dto.interfaceName);
            if (dto.target != null) {
                pw.println("  Target Filter: " + dto.target);
            }
            pw.println("    Cardinality: " + dto.cardinality);
            pw.println("    Policy: " + dto.policy);
            pw.println("    Policy Option: " + dto.policyOption);
            if (satisfiedRef != null) {
                for (ServiceReferenceDTO sref : satisfiedRef.boundServices) {
                    pw.print("    Bound Service: ID ");
                    pw.print(sref.properties.get("service.id"));
                    String name = (String)sref.properties.get("component.name");
                    if (name == null && (name = (String)sref.properties.get("service.pid")) == null) {
                        name = (String)sref.properties.get("service.description");
                    }
                    if (name != null) {
                        pw.print(" (");
                        pw.print(name);
                        pw.print(")");
                    }
                    pw.println();
                }
                continue;
            }
            pw.println("    No Services bound");
        }
    }

    private static final void listProperties(PrintWriter pw, ComponentConfigurationDTO cfg) {
        Map props = cfg.properties;
        if (props != null) {
            pw.println("  Properties=");
            TreeSet keys = new TreeSet(props.keySet());
            for (String key : keys) {
                Object value = props.get(key);
                if ((value = WebConsoleUtil.toString(value)).getClass().isArray()) {
                    value = Arrays.asList((Object[])value);
                }
                pw.println("    " + key + "=" + value);
            }
        }
    }

    static final String toStateString(int state) {
        switch (state) {
            case 8: {
                return "active";
            }
            case 4: {
                return "satisfied";
            }
            case 1: {
                return "unsatisfied (configuration)";
            }
            case 2: {
                return "unsatisfied (reference)";
            }
        }
        return String.valueOf(state);
    }
}

