/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.deppack;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.felix.webconsole.DefaultVariableResolver;
import org.apache.felix.webconsole.SimpleWebConsolePlugin;
import org.apache.felix.webconsole.WebConsoleUtil;
import org.apache.felix.webconsole.internal.OsgiManagerPlugin;
import org.json.JSONException;
import org.json.JSONWriter;
import org.osgi.service.deploymentadmin.DeploymentAdmin;
import org.osgi.service.deploymentadmin.DeploymentException;
import org.osgi.service.deploymentadmin.DeploymentPackage;

public class DepPackServlet
extends SimpleWebConsolePlugin
implements OsgiManagerPlugin {
    private static final String LABEL = "deppack";
    private static final String TITLE = "%deployment.pluginTitle";
    private static final String[] CSS = new String[]{"/res/ui/deployment.css"};
    private static final String ACTION_DEPLOY = "deploydp";
    private static final String ACTION_UNINSTALL = "uninstalldp";
    private static final String PARAMETER_PCK_FILE = "pckfile";
    private static final String DEPL_SERVICE = (class$org$osgi$service$deploymentadmin$DeploymentAdmin == null ? (class$org$osgi$service$deploymentadmin$DeploymentAdmin = DepPackServlet.class$("org.osgi.service.deploymentadmin.DeploymentAdmin")) : class$org$osgi$service$deploymentadmin$DeploymentAdmin).getName();
    private final String TEMPLATE = this.readTemplateFile("/templates/deployment.html");
    static /* synthetic */ Class class$org$osgi$service$deploymentadmin$DeploymentAdmin;

    public DepPackServlet() {
        super(LABEL, TITLE, CSS);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String action = WebConsoleUtil.getParameter(req, "action");
        if (ACTION_DEPLOY.equals(action)) {
            Map params = (Map)req.getAttribute("org.apache.felix.webconsole.fileupload");
            if (params != null) {
                FileItem pck = DepPackServlet.getFileItem(params, PARAMETER_PCK_FILE, false);
                DeploymentAdmin admin = (DeploymentAdmin)this.getService(DEPL_SERVICE);
                if (admin != null) {
                    try {
                        admin.installDeploymentPackage(pck.getInputStream());
                        String uri = req.getRequestURI();
                        resp.sendRedirect(uri);
                        return;
                    }
                    catch (DeploymentException e) {
                        throw new ServletException("Unable to deploy package.", (Throwable)e);
                    }
                }
            }
            throw new ServletException("Upload file or deployment admin missing.");
        }
        if (ACTION_UNINSTALL.equals(action)) {
            DeploymentAdmin admin;
            String pckId = req.getPathInfo().substring(req.getPathInfo().lastIndexOf(47) + 1);
            if (pckId != null && pckId.length() > 0 && (admin = (DeploymentAdmin)this.getService(DEPL_SERVICE)) != null) {
                try {
                    DeploymentPackage pck = admin.getDeploymentPackage(pckId);
                    if (pck != null) {
                        pck.uninstall();
                    }
                }
                catch (DeploymentException e) {
                    throw new ServletException("Unable to undeploy package.", (Throwable)e);
                }
            }
            PrintWriter pw = resp.getWriter();
            pw.println("{ \"reload\":true }");
            return;
        }
        throw new ServletException("Unknown action: " + action);
    }

    private static final FileItem getFileItem(Map params, String name, boolean isFormField) {
        FileItem[] items = (FileItem[])params.get(name);
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                if (items[i].isFormField() != isFormField) continue;
                return items[i];
            }
        }
        return null;
    }

    protected void renderContent(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        DeploymentAdmin admin = (DeploymentAdmin)this.getService(DEPL_SERVICE);
        StringWriter w = new StringWriter();
        PrintWriter w2 = new PrintWriter(w);
        JSONWriter jw = new JSONWriter((Writer)w2);
        try {
            jw.object();
            if (null == admin) {
                jw.key("error");
                jw.value(true);
            } else {
                DeploymentPackage[] packages = admin.listDeploymentPackages();
                jw.key("data");
                jw.array();
                for (int i = 0; i < packages.length; ++i) {
                    DepPackServlet.packageInfoJson(jw, packages[i]);
                }
                jw.endArray();
            }
            jw.endObject();
        }
        catch (JSONException je) {
            throw new IOException(je.toString());
        }
        DefaultVariableResolver vars = (DefaultVariableResolver)WebConsoleUtil.getVariableResolver((ServletRequest)request);
        vars.put("__data__", w.toString());
        response.getWriter().print(this.TEMPLATE);
    }

    private static final void packageInfoJson(JSONWriter jw, DeploymentPackage pack) throws JSONException {
        jw.object();
        jw.key("id");
        jw.value((Object)pack.getName());
        jw.key("name");
        jw.value((Object)pack.getName());
        jw.key("state");
        jw.value((Object)pack.getVersion());
        jw.key("actions");
        jw.array();
        jw.object();
        jw.key("enabled");
        jw.value(true);
        jw.key("name");
        jw.value((Object)"Uninstall");
        jw.key("link");
        jw.value((Object)ACTION_UNINSTALL);
        jw.endObject();
        jw.endArray();
        jw.key("props");
        jw.array();
        WebConsoleUtil.keyVal(jw, "Package Name", pack.getName());
        WebConsoleUtil.keyVal(jw, "Version", pack.getVersion());
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < pack.getBundleInfos().length; ++i) {
            buffer.append(pack.getBundleInfos()[i].getSymbolicName());
            buffer.append(" - ");
            buffer.append(pack.getBundleInfos()[i].getVersion());
            buffer.append("<br/>");
        }
        WebConsoleUtil.keyVal(jw, "Bundles", buffer.toString());
        jw.endArray();
        jw.endObject();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

