/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.core;

import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.felix.webconsole.internal.AbstractConfigurationPrinter;
import org.apache.felix.webconsole.internal.misc.ConfigurationRender;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleWiring;

public class CapabilitiesPrinter
extends AbstractConfigurationPrinter {
    private static final String TITLE = "Capabilities";
    static final List<String> EXCLUDED_NAMESPACES = Arrays.asList("osgi.wiring.package", "osgi.wiring.host");
    static final Predicate<String> EXCLUDED_NAMESPACES_PREDICATE = new ExcludedNamespacesPredicate();

    @Override
    public String getTitle() {
        return TITLE;
    }

    @Override
    public void printConfiguration(PrintWriter printWriter) {
        for (Bundle bundle : this.getBundleContext().getBundles()) {
            List filteredCapabilities;
            List capabilities;
            BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
            if (wiring == null || (capabilities = wiring.getCapabilities(null)) == null || (filteredCapabilities = capabilities.stream().filter(c -> EXCLUDED_NAMESPACES_PREDICATE.test(c.getNamespace())).collect(Collectors.toList())).isEmpty()) continue;
            ConfigurationRender.infoLine(printWriter, null, "Bundle", bundle.getSymbolicName() + " (" + bundle.getBundleId() + ")");
            for (BundleCapability capability : filteredCapabilities) {
                String requirerBundles;
                List wires;
                String directives;
                ConfigurationRender.infoLine(printWriter, "  ", "Capability namespace", capability.getNamespace());
                String attributes = CapabilitiesPrinter.dumpTypedAttributes(capability.getAttributes());
                if (!attributes.isEmpty()) {
                    ConfigurationRender.infoLine(printWriter, "    ", "Attributes", attributes);
                }
                if (!(directives = CapabilitiesPrinter.dumpDirectives(capability.getDirectives())).isEmpty()) {
                    ConfigurationRender.infoLine(printWriter, "    ", "Directives", directives);
                }
                if ((wires = wiring.getRequiredWires(capability.getNamespace())) == null || (requirerBundles = wires.stream().map(w -> w.getRequirer().getSymbolicName() + " (" + w.getRequirer().getBundle().getBundleId() + ") with directives: " + CapabilitiesPrinter.dumpDirectives(w.getRequirement().getDirectives())).collect(Collectors.joining(", "))).isEmpty()) continue;
                ConfigurationRender.infoLine(printWriter, "    ", "Required By", requirerBundles);
            }
        }
    }

    static String dumpTypedAttributes(Map<String, Object> typedAttributes) {
        StringBuilder attributes = new StringBuilder();
        boolean isFirst = true;
        for (Map.Entry<String, Object> entry : typedAttributes.entrySet()) {
            String value;
            if (entry.getValue().getClass().isArray()) {
                StringBuilder values = new StringBuilder("[");
                for (int i = 0; i < Array.getLength(entry.getValue()); ++i) {
                    if (i > 0) {
                        values.append(", ");
                    }
                    values.append(Array.get(entry.getValue(), i));
                }
                value = values.append("]").toString();
            } else {
                value = entry.getValue().toString();
            }
            if (isFirst) {
                isFirst = false;
            } else {
                attributes.append(", ");
            }
            attributes.append(entry.getKey()).append("=").append(value);
        }
        return attributes.toString();
    }

    static String dumpDirectives(Map<String, String> directives) {
        return directives.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(" ,"));
    }

    static final class ExcludedNamespacesPredicate
    implements Predicate<String> {
        ExcludedNamespacesPredicate() {
        }

        @Override
        public boolean test(String namespace) {
            return !EXCLUDED_NAMESPACES.contains(namespace);
        }
    }
}

