/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.servlet;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.felix.webconsole.internal.OsgiManagerPlugin;
import org.apache.felix.webconsole.internal.Util;
import org.apache.felix.webconsole.internal.i18n.ResourceBundleManager;
import org.apache.felix.webconsole.internal.legacy.LegacyServicesTracker;
import org.apache.felix.webconsole.internal.servlet.OsgiManager;
import org.apache.felix.webconsole.internal.servlet.Plugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class PluginHolder
implements ServiceTrackerCustomizer<Servlet, Plugin> {
    private static final String OLD_CONFIG_MANAGER_CLASS = "org.apache.felix.webconsole.internal.compendium.ConfigManager";
    private static final String NEW_CONFIG_MANAGER_CLASS = "org.apache.felix.webconsole.internal.configuration.ConfigManager";
    static final String[] PLUGIN_MAP = new String[]{"org.apache.felix.webconsole.internal.configuration.ConfigManager", "configMgr", "org.apache.felix.webconsole.internal.compendium.LogServlet", "logs", "org.apache.felix.webconsole.internal.core.BundlesServlet", "bundles", "org.apache.felix.webconsole.internal.core.ServicesServlet", "services", "org.apache.felix.webconsole.internal.misc.LicenseServlet", "licenses", "org.apache.felix.webconsole.internal.system.VMStatPlugin", "vmstat"};
    public static final String ATTR_FLAT_LABEL_MAP = PluginHolder.class.getName() + ".flatLabelMap";
    private final OsgiManager osgiManager;
    private final BundleContext bundleContext;
    private final Map<String, List<Plugin>> plugins = new HashMap<String, List<Plugin>>();
    private volatile ServletContext servletContext;
    private volatile String defaultPluginLabel;
    private final ServiceTracker<Servlet, Plugin> servletTracker;
    private volatile Closeable legacyTracker;
    private final Map<String, OsgiManagerPlugin> internalPlugins = new HashMap<String, OsgiManagerPlugin>();

    PluginHolder(OsgiManager osgiManager, BundleContext context) {
        this.osgiManager = osgiManager;
        this.bundleContext = context;
        Filter filter = null;
        try {
            filter = context.createFilter("(&(objectClass=" + Servlet.class.getName() + ")(felix.webconsole.label=*)(felix.webconsole.title=*))");
        }
        catch (InvalidSyntaxException e) {
            throw new InternalError("Failed creating filter: " + e.getMessage());
        }
        this.servletTracker = new ServiceTracker(context, filter, (ServiceTrackerCustomizer)this);
    }

    public void initInternalPlugins(Set<String> enabledPlugins, BundleContext context) {
        if (enabledPlugins != null && enabledPlugins.contains(OLD_CONFIG_MANAGER_CLASS)) {
            enabledPlugins.add(NEW_CONFIG_MANAGER_CLASS);
        }
        for (int i = 0; i < PLUGIN_MAP.length; i += 2) {
            OsgiManagerPlugin plugin;
            boolean enable;
            String pluginClassName = PLUGIN_MAP[i];
            boolean bl = enable = enabledPlugins == null || enabledPlugins.contains(pluginClassName);
            if (enable && !this.internalPlugins.containsKey(pluginClassName)) {
                plugin = this.osgiManager.createInternalPlugin(pluginClassName);
                if (plugin == null) continue;
                this.internalPlugins.put(pluginClassName, plugin);
                plugin.activate(context);
                continue;
            }
            if (enable || !this.internalPlugins.containsKey(pluginClassName)) continue;
            plugin = this.internalPlugins.remove(pluginClassName);
            plugin.deactivate();
        }
    }

    void open() {
        this.servletTracker.open();
        try {
            this.legacyTracker = new LegacyServicesTracker(this, this.getBundleContext());
            Util.LOGGER.info("Servlet 3 bridge enabled");
        }
        catch (Throwable t) {
            Util.LOGGER.info("Servlet 3 bridge not enabled");
        }
    }

    void close() {
        if (this.legacyTracker != null) {
            try {
                this.legacyTracker.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.legacyTracker = null;
        }
        this.servletTracker.close();
        for (OsgiManagerPlugin plugin : this.internalPlugins.values()) {
            plugin.deactivate();
        }
        this.internalPlugins.clear();
        this.plugins.clear();
        this.servletContext = null;
        this.defaultPluginLabel = null;
    }

    public OsgiManager getOsgiManager() {
        return this.osgiManager;
    }

    String getDefaultPluginLabel() {
        return this.defaultPluginLabel;
    }

    void setDefaultPluginLabel(String defaultPluginLabel) {
        this.defaultPluginLabel = defaultPluginLabel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Plugin getPlugin(String label) {
        Plugin consolePlugin = null;
        if (label != null && label.length() > 0) {
            Map<String, List<Plugin>> map = this.plugins;
            synchronized (map) {
                List<Plugin> list = this.plugins.get(label);
                consolePlugin = list != null && !list.isEmpty() ? list.get(0) : null;
            }
        } else {
            Plugin p;
            List<Plugin> plugins = this.getPlugins();
            Iterator<Plugin> iterator = plugins.iterator();
            while (iterator.hasNext() && (consolePlugin = (p = iterator.next())) == null) {
            }
        }
        return consolePlugin;
    }

    Map getLocalizedLabelMap(ResourceBundleManager resourceBundleManager, Locale locale, String defaultCategory) {
        HashMap map = new HashMap();
        HashMap<String, String> flatMap = new HashMap<String, String>();
        List<Plugin> plugins = this.getPlugins();
        for (Plugin plugin : plugins) {
            if (!plugin.isEnabled()) continue;
            Map categoryMap = null;
            String category = plugin.getCategory();
            if (category == null || category.trim().length() == 0) {
                category = defaultCategory;
            }
            categoryMap = this.findCategoryMap(map, category);
            String label = plugin.getLabel();
            String title = plugin.getTitle();
            if (title.startsWith("%")) {
                try {
                    ResourceBundle resourceBundle = resourceBundleManager.getResourceBundle(plugin.getBundle(), locale);
                    title = resourceBundle.getString(title.substring(1));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            categoryMap.put(label, title);
            flatMap.put(label, title);
        }
        map.put(ATTR_FLAT_LABEL_MAP, flatMap);
        return map;
    }

    private Map findCategoryMap(Map map, String categoryPath) {
        Map categoryMap = null;
        Map searchMap = map;
        String[] categories = categoryPath.split("/");
        for (int i = 0; i < categories.length; ++i) {
            String categoryKey = "category." + categories[i];
            if (searchMap.containsKey(categoryKey)) {
                categoryMap = (Map)searchMap.get(categoryKey);
            } else {
                categoryMap = new HashMap();
                searchMap.put((CallSite)((Object)categoryKey), categoryMap);
            }
            searchMap = categoryMap;
        }
        return categoryMap;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    void setServletContext(ServletContext context) {
        this.servletContext = context;
    }

    ServletContext getServletContext() {
        return this.servletContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Plugin> getPlugins() {
        ArrayList<Plugin> plugins;
        ArrayList<Plugin> arrayList = plugins = new ArrayList<Plugin>();
        synchronized (arrayList) {
            for (List<Plugin> c : this.plugins.values()) {
                if (c.isEmpty()) continue;
                plugins.add(c.get(0));
            }
        }
        return plugins;
    }

    public Plugin addingService(ServiceReference<Servlet> reference) {
        Plugin plugin = null;
        String label = Util.getStringProperty(reference, "felix.webconsole.label");
        if (label != null) {
            plugin = new Plugin(this, reference, label);
            this.addPlugin(plugin);
        }
        return plugin;
    }

    public void modifiedService(ServiceReference<Servlet> reference, Plugin plugin) {
        this.removedService(reference, plugin);
        this.addingService((ServiceReference)reference);
    }

    public void removedService(ServiceReference<Servlet> reference, Plugin plugin) {
        this.removePlugin(plugin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlugin(Plugin plugin) {
        Map<String, List<Plugin>> map = this.plugins;
        synchronized (map) {
            List list = this.plugins.computeIfAbsent(plugin.getLabel(), k -> new ArrayList());
            Plugin oldPlugin = list.isEmpty() ? null : (Plugin)list.get(0);
            list.add(plugin);
            Collections.sort(list);
            Collections.reverse(list);
            Plugin first = (Plugin)list.get(0);
            if (first == plugin) {
                if (!first.init()) {
                    list.remove(plugin);
                } else if (oldPlugin != null) {
                    Util.LOGGER.warn("Overwriting existing plugin {} having label {} with new plugin {} due to higher ranking ", new Object[]{oldPlugin.getId(), plugin.getLabel(), plugin.getId()});
                    oldPlugin.dispose();
                }
            }
            if (first == oldPlugin) {
                Util.LOGGER.warn("Ignoring new plugin {} having existing label {} due to lower ranking than old plugin {}", new Object[]{plugin.getId(), plugin.getLabel(), oldPlugin.getId()});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlugin(Plugin plugin) {
        Map<String, List<Plugin>> map = this.plugins;
        synchronized (map) {
            List<Plugin> list = this.plugins.get(plugin.getLabel());
            if (list != null) {
                boolean isFirst = !list.isEmpty() && list.get(0) == plugin;
                list.remove(plugin);
                if (list.isEmpty()) {
                    this.plugins.remove(plugin.getLabel());
                } else if (isFirst) {
                    while (!list.isEmpty() && !list.get(0).init()) {
                        list.remove(0);
                    }
                }
            }
            plugin.dispose();
        }
    }
}

