/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.monitor;

import java.io.UnsupportedEncodingException;
import java.util.Date;

public final class StatusVariable {
    public static final int TYPE_INTEGER = 0;
    public static final int TYPE_FLOAT = 1;
    public static final int TYPE_STRING = 2;
    public static final int TYPE_BOOLEAN = 3;
    public static final int CM_CC = 0;
    public static final int CM_DER = 1;
    public static final int CM_GAUGE = 2;
    public static final int CM_SI = 3;
    static final String SYMBOLIC_NAME_CHARACTERS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_.";
    static final int MAX_ID_LENGTH = 32;
    private String id;
    private Date timeStamp;
    private int cm;
    private int type;
    private int intData;
    private float floatData;
    private String stringData;
    private boolean booleanData;

    public StatusVariable(String id, int cm, int data) {
        this.setCommon(id, cm);
        this.type = 0;
        this.intData = data;
    }

    public StatusVariable(String id, int cm, float data) {
        this.setCommon(id, cm);
        this.type = 1;
        this.floatData = data;
    }

    public StatusVariable(String id, int cm, boolean data) {
        this.setCommon(id, cm);
        this.type = 3;
        this.booleanData = data;
    }

    public StatusVariable(String id, int cm, String data) {
        this.setCommon(id, cm);
        this.type = 2;
        this.stringData = data;
    }

    public String getID() {
        return this.id;
    }

    public int getType() {
        return this.type;
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public String getString() throws IllegalStateException {
        if (this.type != 2) {
            throw new IllegalStateException("This StatusVariable does not contain a String value.");
        }
        return this.stringData;
    }

    public int getInteger() throws IllegalStateException {
        if (this.type != 0) {
            throw new IllegalStateException("This StatusVariable does not contain an integer value.");
        }
        return this.intData;
    }

    public float getFloat() throws IllegalStateException {
        if (this.type != 1) {
            throw new IllegalStateException("This StatusVariable does not contain a float value.");
        }
        return this.floatData;
    }

    public boolean getBoolean() throws IllegalStateException {
        if (this.type != 3) {
            throw new IllegalStateException("This StatusVariable does not contain a boolean value.");
        }
        return this.booleanData;
    }

    public int getCollectionMethod() {
        return this.cm;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StatusVariable)) {
            return false;
        }
        StatusVariable other = (StatusVariable)obj;
        if (!this.equals(this.id, other.id) || this.cm != other.cm || this.type != other.type) {
            return false;
        }
        switch (this.type) {
            case 0: {
                return this.intData == other.intData;
            }
            case 1: {
                return this.floatData == other.floatData;
            }
            case 2: {
                return this.equals(this.stringData, other.stringData);
            }
            case 3: {
                return this.booleanData == other.booleanData;
            }
        }
        return false;
    }

    public int hashCode() {
        int hash = this.hashCode(this.id) ^ this.cm;
        switch (this.type) {
            case 0: {
                return hash ^ this.intData;
            }
            case 1: {
                return hash ^ this.hashCode(new Float(this.floatData));
            }
            case 3: {
                return hash ^ this.hashCode(new Boolean(this.booleanData));
            }
            case 2: {
                return hash ^ this.hashCode(this.stringData);
            }
        }
        return 0;
    }

    public String toString() {
        String cmName = null;
        switch (this.cm) {
            case 0: {
                cmName = "CC";
                break;
            }
            case 1: {
                cmName = "DER";
                break;
            }
            case 2: {
                cmName = "GAUGE";
                break;
            }
            case 3: {
                cmName = "SI";
            }
        }
        String beg = "StatusVariable(" + this.id + ", " + cmName + ", " + this.timeStamp + ", ";
        switch (this.type) {
            case 0: {
                return beg + "INTEGER, " + this.intData + ")";
            }
            case 1: {
                return beg + "FLOAT, " + this.floatData + ")";
            }
            case 2: {
                return beg + "STRING, " + this.stringData + ")";
            }
            case 3: {
                return beg + "BOOLEAN, " + this.booleanData + ")";
            }
        }
        return null;
    }

    private void setCommon(String id, int cm) throws IllegalArgumentException, NullPointerException {
        StatusVariable.checkId(id, "StatusVariable ID");
        if (cm != 0 && cm != 1 && cm != 2 && cm != 3) {
            throw new IllegalArgumentException("Unknown data collection method constant '" + cm + "'.");
        }
        this.id = id;
        this.cm = cm;
        this.timeStamp = new Date();
    }

    private boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    private int hashCode(Object o) {
        return o == null ? 0 : o.hashCode();
    }

    private static void checkId(String id, String idName) throws IllegalArgumentException, NullPointerException {
        byte[] nameBytes;
        if (id == null) {
            throw new NullPointerException(idName + " is null.");
        }
        if (id.length() == 0) {
            throw new IllegalArgumentException(idName + " is empty.");
        }
        try {
            nameBytes = id.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e.getMessage());
        }
        if (nameBytes.length > 32) {
            throw new IllegalArgumentException(idName + " is too long " + "(over " + 32 + " bytes in UTF-8 encoding).");
        }
        if (id.equals(".") || id.equals("..")) {
            throw new IllegalArgumentException(idName + " is invalid.");
        }
        if (!StatusVariable.containsValidChars(id)) {
            throw new IllegalArgumentException(idName + " contains invalid characters.");
        }
    }

    private static boolean containsValidChars(String name) {
        char[] chars = name.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (SYMBOLIC_NAME_CHARACTERS.indexOf(chars[i]) != -1) continue;
            return false;
        }
        return true;
    }
}

