/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.maven.osgicheck.impl.mddocgen;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.felix.maven.osgicheck.impl.mddocgen.ClassName;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;

abstract class AbstractMarkdownMojo
extends AbstractMojo {
    @Parameter(defaultValue="${user.name}", required=true, readonly=true)
    private String currentUser;
    @Parameter(defaultValue="${project.description}", required=true, readonly=true)
    private String projectDescription;
    @Parameter(defaultValue="Copyright &copy; ${project.inceptionYear} - %tY [${project.organization.name}](${project.organization.url}). All Rights Reserved.%n", required=true, readonly=true)
    private String projectCopyrights;
    @Parameter
    private Set<String> excludes;
    private Map<String, List<ClassName>> index;

    AbstractMarkdownMojo() {
    }

    protected abstract String getReadmeTitle();

    protected abstract String getIncludes();

    protected abstract File getSourceDir();

    protected abstract File getTargetDir();

    protected abstract void handle(Collection<File> var1);

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.getSourceDir().exists()) {
            throw new MojoFailureException(this.getSourceDir() + " does not exist, please check MOJO configuration.");
        }
        if (!this.getTargetDir().exists()) {
            this.getTargetDir().mkdirs();
        }
        List found = null;
        try {
            found = FileUtils.getFiles((File)this.getSourceDir(), (String)this.getIncludes(), null);
        }
        catch (IOException e) {
            throw new MojoExecutionException("An error occurred while scanning directory '" + this.getSourceDir() + "', please check if it exists and the current user '" + this.currentUser + "' has enough permissions for reading");
        }
        if (found == null || found.isEmpty()) {
            this.getLog().warn((CharSequence)("No " + this.getIncludes() + " file found in " + this.getSourceDir()));
            return;
        }
        this.index = new TreeMap<String, List<ClassName>>();
        this.handle(found);
        this.writeIndex();
    }

    protected final boolean isExcluded(String name) {
        if (this.excludes.contains(name)) {
            this.getLog().debug((CharSequence)(name + " is in the exclude list, it won't be processed"));
            return true;
        }
        return false;
    }

    protected final void doIndex(String key, ClassName value) {
        List<ClassName> values = this.index.get(key);
        if (values == null) {
            values = new ArrayList<ClassName>();
            this.index.put(key, values);
        }
        values.add(value);
    }

    private void writeIndex() throws MojoExecutionException {
        PrintWriter writer = null;
        try {
            writer = AbstractMarkdownMojo.newPrintWriter(new File(this.getTargetDir(), "README.md"));
            writer.println(this.getReadmeTitle());
            writer.println("=======================");
            writer.println();
            writer.println(this.projectDescription);
            writer.println();
            writer.printf(this.projectCopyrights, new Date());
            writer.println();
            writer.println("# Table of contents");
            writer.println();
            for (String string : this.index.keySet()) {
                writer.printf(" * [%1$2s](#%1$2s)%n", string);
            }
            writer.println();
            for (Map.Entry entry : this.index.entrySet()) {
                writer.printf("# %1$2s <a id=\"%1$2s\"></a>%n", entry.getKey());
                writer.println();
                for (ClassName className : (List)entry.getValue()) {
                    writer.printf(" * [%s](./%s/%s.md)%n", className.getQualifiedName(), className.getPackagePath(), className.getSimpleName());
                }
                writer.println();
            }
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("An error occurred while rendering index in README.md", (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close((Writer)writer);
    }

    protected static PrintWriter newPrintWriter(File target) throws IOException {
        return new PrintWriter(new BufferedWriter(new FileWriter(target)));
    }
}

