/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.conf.configfilter;

import org.apache.flume.conf.ComponentConfiguration;
import org.apache.flume.conf.ConfigurationException;

public class ConfigFilterConfiguration
extends ComponentConfiguration {
    protected ConfigFilterConfiguration(String componentName) {
        super(componentName);
    }

    public static enum ConfigFilterConfigurationType {
        OTHER(null),
        ENV("org.apache.flume.conf.configfilter.EnvironmentVariableConfigFilterConfiguration"),
        HADOOP("org.apache.flume.conf.configfilter.HadoopCredentialStoreConfigFilterConfiguration"),
        EXTERNAL("org.apache.flume.conf.configfilter.ExternalProcessConfigFilterConfiguration");

        private final String configurationName;

        private ConfigFilterConfigurationType(String type) {
            this.configurationName = type;
        }

        public String getConfigFilterConfigurationType() {
            return this.configurationName;
        }

        public ConfigFilterConfiguration getConfiguration(String name) throws ConfigurationException {
            if (this == OTHER) {
                return new ConfigFilterConfiguration(name);
            }
            ConfigFilterConfiguration instance = null;
            try {
                if (this.configurationName == null) {
                    return new ConfigFilterConfiguration(name);
                }
                Class<?> clazz = Class.forName(this.configurationName);
                instance = (ConfigFilterConfiguration)clazz.getConstructor(String.class).newInstance(name);
            }
            catch (ClassNotFoundException e) {
                instance = new ConfigFilterConfiguration(name);
                instance.setNotFoundConfigClass();
            }
            catch (Exception e) {
                throw new ConfigurationException("Couldn't create configuration", e);
            }
            return instance;
        }
    }
}

