/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.node;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import org.apache.commons.io.IOUtils;
import org.apache.flume.CounterGroup;
import org.apache.flume.conf.ConfigurationException;
import org.apache.flume.node.ConfigurationSource;
import org.apache.flume.node.net.AuthorizationProvider;
import org.apache.flume.node.net.UrlConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConfigurationSource
implements ConfigurationSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpConfigurationSource.class);
    private static final int NOT_MODIFIED = 304;
    private static final int NOT_AUTHORIZED = 401;
    private static final int NOT_FOUND = 404;
    private static final int OK = 200;
    private static final int BUF_SIZE = 1024;
    private final URI uri;
    private final CounterGroup counterGroup;
    private final AuthorizationProvider authorizationProvider;
    private final boolean verifyHost;
    private long lastModified = 0L;
    private byte[] data = null;

    public HttpConfigurationSource(URI uri, AuthorizationProvider authorizationProvider, boolean verifyHost) {
        this.authorizationProvider = authorizationProvider;
        this.uri = uri;
        this.verifyHost = verifyHost;
        this.counterGroup = new CounterGroup();
        this.readInputStream();
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.data);
    }

    @Override
    public String getUri() {
        return this.uri.toString();
    }

    @Override
    public String getExtension() {
        int length = this.uri.getPath().indexOf(".");
        if (length <= 1) {
            return "properties";
        }
        return this.uri.getPath().substring(length + 1);
    }

    @Override
    public boolean isModified() {
        LOGGER.debug("Checking {} for changes", (Object)this.uri);
        this.counterGroup.incrementAndGet("uri.checks");
        try {
            LOGGER.info("Reloading configuration from:{}", (Object)this.uri);
            if (this.readInputStream()) {
                this.counterGroup.incrementAndGet("uri.loads");
                return true;
            }
        }
        catch (ConfigurationException ex) {
            LOGGER.error("Unable to access configuration due to {}: ", (Object)ex.getMessage());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean readInputStream() {
        try {
            int code;
            HttpURLConnection connection;
            block41: {
                connection = UrlConnectionFactory.createConnection(this.uri.toURL(), this.authorizationProvider, this.lastModified, this.verifyHost);
                connection.connect();
                code = connection.getResponseCode();
                switch (code) {
                    case 304: {
                        LOGGER.debug("Configuration Not Modified");
                        boolean bl = false;
                        return bl;
                    }
                    case 200: {
                        Throwable throwable = null;
                        try (InputStream is = connection.getInputStream();){
                            this.lastModified = connection.getLastModified();
                            LOGGER.debug("Content was modified for {}. lastModified: {}", (Object)this.uri.toString(), (Object)this.lastModified);
                            this.data = IOUtils.toByteArray((InputStream)is);
                            boolean bl = true;
                            return bl;
                        }
                        catch (Throwable throwable2) {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (IOException e) {
                                try (InputStream es = connection.getErrorStream();){
                                    LOGGER.info("Error accessing configuration at {}: {}", (Object)this.uri, (Object)this.readStream(es));
                                    throw new ConfigurationException("Unable to access " + this.uri.toString(), (Throwable)e);
                                }
                                catch (IOException ioe) {
                                    LOGGER.error("Error accessing configuration at {}: {}", (Object)this.uri, (Object)e.getMessage());
                                }
                                throw new ConfigurationException("Unable to access " + this.uri.toString(), (Throwable)e);
                            }
                        }
                    }
                    case 404: {
                        throw new ConfigurationException("Unable to locate " + this.uri.toString());
                    }
                    case 401: {
                        throw new ConfigurationException("Authorization failed");
                    }
                }
                if (code >= 0) break block41;
                LOGGER.info("Invalid response code returned");
                return false;
            }
            LOGGER.info("Unexpected response code returned {}", (Object)code);
            return false;
            finally {
                connection.disconnect();
            }
        }
        catch (IOException e) {
            LOGGER.warn("Error accessing {}: {}", (Object)this.uri.toString(), (Object)e.getMessage());
            throw new ConfigurationException("Unable to access " + this.uri.toString(), (Throwable)e);
        }
    }

    private byte[] readStream(InputStream is) throws IOException {
        int length;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = is.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toByteArray();
    }

    public String toString() {
        return "{ uri:" + this.uri + "}";
    }
}

