/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class OrderSelector<T> {
    private static final int EXP_BACKOFF_COUNTER_LIMIT = 16;
    private static final long CONSIDER_SEQUENTIAL_RANGE = 2000L;
    private static final long MAX_TIMEOUT = 30000L;
    private final Map<T, FailureState> stateMap = new LinkedHashMap<T, FailureState>();
    private long maxTimeout = 30000L;
    private final boolean shouldBackOff;

    protected OrderSelector(boolean shouldBackOff) {
        this.shouldBackOff = shouldBackOff;
    }

    public void setObjects(List<T> objects) {
        for (T sink : objects) {
            FailureState state = new FailureState();
            this.stateMap.put(sink, state);
        }
    }

    public List<T> getObjects() {
        return new ArrayList<T>(this.stateMap.keySet());
    }

    public abstract Iterator<T> createIterator();

    public void informFailure(T failedObject) {
        if (!this.shouldBackOff) {
            return;
        }
        FailureState state = this.stateMap.get(failedObject);
        long now = System.currentTimeMillis();
        long delta = now - state.lastFail;
        long lastBackoffLength = Math.min(this.maxTimeout, (long)(1000 * (1 << state.sequentialFails)));
        long allowableDiff = lastBackoffLength + 2000L;
        if (allowableDiff > delta) {
            if (state.sequentialFails < 16) {
                ++state.sequentialFails;
            }
        } else {
            state.sequentialFails = 1;
        }
        state.lastFail = now;
        state.restoreTime = now + Math.min(this.maxTimeout, (long)(1000 * (1 << state.sequentialFails)));
    }

    protected List<Integer> getIndexList() {
        long now = System.currentTimeMillis();
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        int i = 0;
        for (T obj : this.stateMap.keySet()) {
            if (!this.isShouldBackOff() || this.stateMap.get(obj).restoreTime < now) {
                indexList.add(i);
            }
            ++i;
        }
        return indexList;
    }

    public boolean isShouldBackOff() {
        return this.shouldBackOff;
    }

    public void setMaxTimeOut(long timeout) {
        this.maxTimeout = timeout;
    }

    public long getMaxTimeOut() {
        return this.maxTimeout;
    }

    private static class FailureState {
        long lastFail = 0L;
        long restoreTime = 0L;
        int sequentialFails = 0;

        private FailureState() {
        }
    }
}

