/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.shaded.curator5.org.apache.curator.framework.recipes.nodes;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.fluss.shaded.curator5.org.apache.curator.framework.CuratorFramework;
import org.apache.fluss.shaded.curator5.org.apache.curator.framework.WatcherRemoveCuratorFramework;
import org.apache.fluss.shaded.curator5.org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.fluss.shaded.curator5.org.apache.curator.framework.api.BackgroundCallback;
import org.apache.fluss.shaded.curator5.org.apache.curator.framework.api.BackgroundPathable;
import org.apache.fluss.shaded.curator5.org.apache.curator.framework.api.ChildrenDeletable;
import org.apache.fluss.shaded.curator5.org.apache.curator.framework.api.CreateBuilder;
import org.apache.fluss.shaded.curator5.org.apache.curator.framework.api.CreateBuilderMain;
import org.apache.fluss.shaded.curator5.org.apache.curator.framework.api.CreateModable;
import org.apache.fluss.shaded.curator5.org.apache.curator.framework.api.CuratorEvent;
import org.apache.fluss.shaded.curator5.org.apache.curator.framework.api.CuratorWatcher;
import org.apache.fluss.shaded.curator5.org.apache.curator.framework.api.ErrorListenerPathAndBytesable;
import org.apache.fluss.shaded.curator5.org.apache.curator.framework.api.ErrorListenerPathable;
import org.apache.fluss.shaded.curator5.org.apache.curator.framework.listen.Listenable;
import org.apache.fluss.shaded.curator5.org.apache.curator.framework.listen.StandardListenerManager;
import org.apache.fluss.shaded.curator5.org.apache.curator.framework.recipes.nodes.PersistentNodeListener;
import org.apache.fluss.shaded.curator5.org.apache.curator.framework.state.ConnectionState;
import org.apache.fluss.shaded.curator5.org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.fluss.shaded.curator5.org.apache.curator.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.fluss.shaded.curator5.org.apache.curator.shaded.com.google.common.base.Preconditions;
import org.apache.fluss.shaded.curator5.org.apache.curator.utils.PathUtils;
import org.apache.fluss.shaded.curator5.org.apache.curator.utils.ThreadUtils;
import org.apache.fluss.shaded.curator5.org.apache.curator.utils.ZKPaths;
import org.apache.fluss.shaded.zookeeper3.org.apache.zookeeper.CreateMode;
import org.apache.fluss.shaded.zookeeper3.org.apache.zookeeper.KeeperException;
import org.apache.fluss.shaded.zookeeper3.org.apache.zookeeper.WatchedEvent;
import org.apache.fluss.shaded.zookeeper3.org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentNode
implements Closeable {
    private final AtomicReference<CountDownLatch> initialCreateLatch = new AtomicReference<CountDownLatch>(new CountDownLatch(1));
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final WatcherRemoveCuratorFramework client;
    private final AtomicReference<String> nodePath = new AtomicReference<Object>(null);
    private final String basePath;
    private final CreateMode mode;
    private final long ttl;
    private final AtomicReference<byte[]> data = new AtomicReference();
    private final AtomicReference<State> state = new AtomicReference<State>(State.LATENT);
    private volatile boolean authFailure;
    private volatile boolean parentCreationFailure;
    private final BackgroundCallback backgroundCallback;
    private final boolean useProtection;
    private final boolean useParentCreation;
    private final AtomicReference<CreateModable<ACLBackgroundPathAndBytesable<String>>> createMethod = new AtomicReference<Object>(null);
    private final StandardListenerManager<PersistentNodeListener> listeners = StandardListenerManager.standard();
    private final CuratorWatcher watcher = new CuratorWatcher(){

        @Override
        public void process(WatchedEvent event) throws Exception {
            if (PersistentNode.this.isActive()) {
                if (event.getType() == Watcher.Event.EventType.NodeDeleted) {
                    PersistentNode.this.createNode();
                } else if (event.getType() == Watcher.Event.EventType.NodeDataChanged) {
                    PersistentNode.this.watchNode();
                }
            }
        }
    };
    private final BackgroundCallback checkExistsCallback = new BackgroundCallback(){

        @Override
        public void processResult(CuratorFramework dummy, CuratorEvent event) throws Exception {
            if (PersistentNode.this.isActive()) {
                if (event.getResultCode() == KeeperException.Code.NONODE.intValue()) {
                    PersistentNode.this.createNode();
                } else {
                    boolean isEphemeral;
                    boolean bl = isEphemeral = event.getStat().getEphemeralOwner() != 0L;
                    if (isEphemeral != PersistentNode.this.mode.isEphemeral()) {
                        PersistentNode.this.log.warn("Existing node ephemeral state doesn't match requested state. Maybe the node was created outside of PersistentNode? " + PersistentNode.this.basePath);
                    }
                }
            } else {
                PersistentNode.this.client.removeWatchers();
            }
        }
    };
    private final BackgroundCallback setDataCallback = new BackgroundCallback(){

        @Override
        public void processResult(CuratorFramework dummy, CuratorEvent event) throws Exception {
            if (event.getResultCode() == KeeperException.Code.OK.intValue()) {
                PersistentNode.this.initialisationComplete();
            } else if (event.getResultCode() == KeeperException.Code.NOAUTH.intValue()) {
                PersistentNode.this.log.warn("Client does not have authorisation to write node at path {}", (Object)event.getPath());
                PersistentNode.this.authFailure = true;
            }
        }
    };
    private final ConnectionStateListener connectionStateListener = new ConnectionStateListener(){

        @Override
        public void stateChanged(CuratorFramework dummy, ConnectionState newState) {
            if (newState == ConnectionState.RECONNECTED && PersistentNode.this.isActive()) {
                PersistentNode.this.createNode();
            }
        }
    };
    @VisibleForTesting
    volatile CountDownLatch debugCreateNodeLatch = null;
    @VisibleForTesting
    final AtomicLong debugWaitMsForBackgroundBeforeClose = new AtomicLong(0L);

    public PersistentNode(CuratorFramework givenClient, CreateMode mode, boolean useProtection, String basePath, byte[] initData) {
        this(givenClient, mode, useProtection, basePath, initData, -1L, true);
    }

    public PersistentNode(CuratorFramework givenClient, CreateMode mode, boolean useProtection, String basePath, byte[] initData, boolean useParentCreation) {
        this(givenClient, mode, useProtection, basePath, initData, -1L, useParentCreation);
    }

    public PersistentNode(CuratorFramework givenClient, CreateMode mode, boolean useProtection, String basePath, byte[] initData, long ttl, boolean useParentCreation) {
        this.useProtection = useProtection;
        this.useParentCreation = useParentCreation;
        this.client = Preconditions.checkNotNull(givenClient, "client cannot be null").newWatcherRemoveCuratorFramework();
        this.basePath = PathUtils.validatePath(basePath);
        this.mode = Preconditions.checkNotNull(mode, "mode cannot be null");
        this.ttl = ttl;
        byte[] data = Preconditions.checkNotNull(initData, "data cannot be null");
        this.backgroundCallback = new BackgroundCallback(){

            @Override
            public void processResult(CuratorFramework dummy, CuratorEvent event) throws Exception {
                if (PersistentNode.this.isActive()) {
                    PersistentNode.this.processBackgroundCallback(event);
                } else {
                    PersistentNode.this.processBackgroundCallbackClosedState(event);
                }
            }
        };
        this.data.set(Arrays.copyOf(data, data.length));
    }

    private void processBackgroundCallbackClosedState(CuratorEvent event) {
        String path = null;
        if (event.getResultCode() == KeeperException.Code.NODEEXISTS.intValue()) {
            path = event.getPath();
        } else if (event.getResultCode() == KeeperException.Code.OK.intValue()) {
            path = event.getName();
        }
        if (path != null) {
            try {
                ((ErrorListenerPathable)((ChildrenDeletable)this.client.delete().guaranteed()).inBackground()).forPath(path);
            }
            catch (Exception e) {
                this.log.error("Could not delete node after close", (Throwable)e);
            }
        }
    }

    private void processBackgroundCallback(CuratorEvent event) throws Exception {
        String path = null;
        boolean nodeExists = false;
        if (event.getResultCode() == KeeperException.Code.NODEEXISTS.intValue()) {
            path = event.getPath();
            nodeExists = true;
        } else if (event.getResultCode() == KeeperException.Code.OK.intValue()) {
            path = event.getName();
        } else {
            if (event.getResultCode() == KeeperException.Code.NOAUTH.intValue()) {
                this.log.warn("Client does not have authorisation to create node at path {}", (Object)event.getPath());
                this.authFailure = true;
                return;
            }
            if (event.getResultCode() == KeeperException.Code.NONODE.intValue()) {
                this.log.warn("Client cannot create parent hierarchy for path {} with useParentCreation set to {}", (Object)event.getPath(), (Object)this.useParentCreation);
                this.parentCreationFailure = true;
                return;
            }
        }
        if (path != null) {
            this.authFailure = false;
            this.nodePath.set(path);
            this.watchNode();
            if (nodeExists) {
                ((ErrorListenerPathAndBytesable)this.client.setData().inBackground(this.setDataCallback)).forPath(this.getActualPath(), this.getData());
            } else {
                this.initialisationComplete();
                this.notifyListeners();
            }
        } else {
            this.createNode();
        }
    }

    private void initialisationComplete() {
        CountDownLatch localLatch = this.initialCreateLatch.getAndSet(null);
        if (localLatch != null) {
            localLatch.countDown();
        }
    }

    public void start() {
        Preconditions.checkState(this.state.compareAndSet(State.LATENT, State.STARTED), "Already started");
        this.client.getConnectionStateListenable().addListener(this.connectionStateListener);
        this.createNode();
    }

    public boolean waitForInitialCreate(long timeout, TimeUnit unit) throws InterruptedException {
        Preconditions.checkState(this.state.get() == State.STARTED, "Not started");
        CountDownLatch localLatch = this.initialCreateLatch.get();
        return localLatch == null || localLatch.await(timeout, unit);
    }

    @Override
    public void close() throws IOException {
        if (this.debugWaitMsForBackgroundBeforeClose.get() > 0L) {
            try {
                Thread.sleep(this.debugWaitMsForBackgroundBeforeClose.get());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (!this.state.compareAndSet(State.STARTED, State.CLOSED)) {
            return;
        }
        this.client.getConnectionStateListenable().removeListener(this.connectionStateListener);
        try {
            this.deleteNode();
        }
        catch (Exception e) {
            ThreadUtils.checkInterrupted(e);
            throw new IOException(e);
        }
        this.client.removeWatchers();
    }

    public Listenable<PersistentNodeListener> getListenable() {
        return this.listeners;
    }

    public String getActualPath() {
        return this.nodePath.get();
    }

    public void setData(byte[] data) throws Exception {
        data = Preconditions.checkNotNull(data, "data cannot be null");
        Preconditions.checkState(this.nodePath.get() != null, "initial create has not been processed. Call waitForInitialCreate() to ensure.");
        Preconditions.checkState(!this.parentCreationFailure, "Failed to create parent nodes.");
        this.data.set(Arrays.copyOf(data, data.length));
        if (this.isActive()) {
            ((ErrorListenerPathAndBytesable)this.client.setData().inBackground(this.setDataCallback)).forPath(this.getActualPath(), this.getData());
        }
    }

    public byte[] getData() {
        return this.data.get();
    }

    protected void deleteNode() throws Exception {
        String localNodePath = this.nodePath.getAndSet(null);
        if (localNodePath != null) {
            try {
                ((ChildrenDeletable)this.client.delete().guaranteed()).forPath(localNodePath);
            }
            catch (KeeperException.NoNodeException noNodeException) {
                // empty catch block
            }
        }
    }

    private void createNode() {
        if (!this.isActive()) {
            return;
        }
        if (this.debugCreateNodeLatch != null) {
            try {
                this.debugCreateNodeLatch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
        try {
            String existingPath = this.nodePath.get();
            String createPath = existingPath != null && !this.useProtection ? existingPath : (existingPath != null && this.mode.isSequential() ? this.basePath + ZKPaths.extractSequentialSuffix(existingPath) : this.basePath);
            CreateModable<ACLBackgroundPathAndBytesable<String>> localCreateMethod = this.createMethod.get();
            if (localCreateMethod == null) {
                CreateBuilder createBuilder;
                CreateBuilderMain createBuilderMain = createBuilder = this.mode.isTTL() ? this.client.create().withTtl(this.ttl) : this.client.create();
                Object tempCreateMethod = this.useParentCreation ? (this.useProtection ? createBuilder.creatingParentContainersIfNeeded().withProtection() : createBuilder.creatingParentContainersIfNeeded()) : (this.useProtection ? createBuilder.withProtection() : createBuilder);
                this.createMethod.compareAndSet(null, (CreateModable<ACLBackgroundPathAndBytesable<String>>)tempCreateMethod);
                localCreateMethod = this.createMethod.get();
            }
            ((ErrorListenerPathAndBytesable)localCreateMethod.withMode(this.getCreateMode(existingPath != null)).inBackground(this.backgroundCallback)).forPath(createPath, this.data.get());
        }
        catch (Exception e) {
            ThreadUtils.checkInterrupted(e);
            throw new RuntimeException("Creating node. BasePath: " + this.basePath, e);
        }
    }

    private CreateMode getCreateMode(boolean pathIsSet) {
        if (pathIsSet) {
            switch (this.mode) {
                default: {
                    break;
                }
                case EPHEMERAL_SEQUENTIAL: {
                    return CreateMode.EPHEMERAL;
                }
                case PERSISTENT_SEQUENTIAL: {
                    return CreateMode.PERSISTENT;
                }
                case PERSISTENT_SEQUENTIAL_WITH_TTL: {
                    return CreateMode.PERSISTENT_WITH_TTL;
                }
            }
        }
        return this.mode;
    }

    private void watchNode() throws Exception {
        if (!this.isActive()) {
            return;
        }
        String localNodePath = this.nodePath.get();
        if (localNodePath != null) {
            ((ErrorListenerPathable)((BackgroundPathable)this.client.checkExists().usingWatcher(this.watcher)).inBackground(this.checkExistsCallback)).forPath(localNodePath);
        }
    }

    private void notifyListeners() {
        String path = this.getActualPath();
        this.listeners.forEach(listener -> {
            try {
                listener.nodeCreated(path);
            }
            catch (Exception e) {
                ThreadUtils.checkInterrupted(e);
                this.log.error("From PersistentNode listener", (Throwable)e);
            }
        });
    }

    private boolean isActive() {
        return this.state.get() == State.STARTED;
    }

    @VisibleForTesting
    boolean isAuthFailure() {
        return this.authFailure;
    }

    @VisibleForTesting
    boolean isParentCreationFailure() {
        return this.parentCreationFailure;
    }

    private static enum State {
        LATENT,
        STARTED,
        CLOSED;

    }
}

