/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.shaded.curator5.org.apache.curator.framework.recipes.queue;

import java.util.concurrent.ThreadFactory;
import org.apache.fluss.shaded.curator5.org.apache.curator.framework.recipes.queue.QueueBuilder;
import org.apache.fluss.shaded.curator5.org.apache.curator.shaded.com.google.common.base.Preconditions;

public class QueueSharderPolicies {
    private int newQueueThreshold = 10000;
    private int thresholdCheckMs = 30000;
    private int maxQueues = 10;
    private ThreadFactory threadFactory = QueueBuilder.defaultThreadFactory;
    private static final int DEFAULT_QUEUE_THRESHOLD = 10000;
    private static final int DEFAULT_THRESHOLD_CHECK_MS = 30000;
    private static final int DEFAULT_MAX_QUEUES = 10;

    public static Builder builder() {
        return new Builder();
    }

    int getNewQueueThreshold() {
        return this.newQueueThreshold;
    }

    int getThresholdCheckMs() {
        return this.thresholdCheckMs;
    }

    int getMaxQueues() {
        return this.maxQueues;
    }

    ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    private QueueSharderPolicies() {
    }

    public static class Builder {
        private QueueSharderPolicies policies = new QueueSharderPolicies();

        public Builder newQueueThreshold(int newQueueThreshold) {
            Preconditions.checkArgument(newQueueThreshold > 0, "newQueueThreshold must be a positive number");
            this.policies.newQueueThreshold = newQueueThreshold;
            return this;
        }

        public Builder thresholdCheckMs(int thresholdCheckMs) {
            Preconditions.checkArgument(thresholdCheckMs > 0, "thresholdCheckMs must be a positive number");
            this.policies.thresholdCheckMs = thresholdCheckMs;
            return this;
        }

        public Builder maxQueues(int maxQueues) {
            Preconditions.checkArgument(maxQueues > 0, "thresholdCheckMs must be a positive number");
            this.policies.maxQueues = maxQueues;
            return this;
        }

        public Builder threadFactory(ThreadFactory threadFactory) {
            this.policies.threadFactory = Preconditions.checkNotNull(threadFactory, "threadFactory cannot be null");
            return this;
        }

        public QueueSharderPolicies build() {
            try {
                QueueSharderPolicies queueSharderPolicies = this.policies;
                return queueSharderPolicies;
            }
            finally {
                this.policies = new QueueSharderPolicies();
            }
        }

        private Builder() {
        }
    }
}

