/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.shaded.zookeeper3.org.apache.zookeeper;

import java.util.List;
import java.util.Objects;
import org.apache.fluss.shaded.zookeeper3.org.apache.zookeeper.CreateMode;
import org.apache.fluss.shaded.zookeeper3.org.apache.zookeeper.data.ACL;
import org.apache.fluss.shaded.zookeeper3.org.apache.zookeeper.server.EphemeralType;

public class CreateOptions {
    private final CreateMode createMode;
    private final List<ACL> acl;
    private final long ttl;

    public CreateMode getCreateMode() {
        return this.createMode;
    }

    public List<ACL> getAcl() {
        return this.acl;
    }

    public long getTtl() {
        return this.ttl;
    }

    public static Builder newBuilder(List<ACL> acl, CreateMode createMode) {
        return new Builder(createMode, acl);
    }

    private CreateOptions(CreateMode createMode, List<ACL> acl, long ttl) {
        this.createMode = createMode;
        this.acl = acl;
        this.ttl = ttl;
        EphemeralType.validateTTL(createMode, ttl);
    }

    public static class Builder {
        private final CreateMode createMode;
        private final List<ACL> acl;
        private long ttl = -1L;

        private Builder(CreateMode createMode, List<ACL> acl) {
            this.createMode = Objects.requireNonNull(createMode, "create mode is mandatory for create options");
            this.acl = Objects.requireNonNull(acl, "acl is mandatory for create options");
        }

        public Builder withTtl(long ttl) {
            this.ttl = ttl;
            return this;
        }

        public CreateOptions build() {
            return new CreateOptions(this.createMode, this.acl, this.ttl);
        }
    }
}

