/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.shaded.zookeeper3.org.apache.zookeeper.metrics.impl;

import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import org.apache.fluss.shaded.zookeeper3.org.apache.zookeeper.metrics.Counter;
import org.apache.fluss.shaded.zookeeper3.org.apache.zookeeper.metrics.CounterSet;
import org.apache.fluss.shaded.zookeeper3.org.apache.zookeeper.metrics.Gauge;
import org.apache.fluss.shaded.zookeeper3.org.apache.zookeeper.metrics.GaugeSet;
import org.apache.fluss.shaded.zookeeper3.org.apache.zookeeper.metrics.MetricsContext;
import org.apache.fluss.shaded.zookeeper3.org.apache.zookeeper.metrics.MetricsProvider;
import org.apache.fluss.shaded.zookeeper3.org.apache.zookeeper.metrics.MetricsProviderLifeCycleException;
import org.apache.fluss.shaded.zookeeper3.org.apache.zookeeper.metrics.Summary;
import org.apache.fluss.shaded.zookeeper3.org.apache.zookeeper.metrics.SummarySet;
import org.apache.fluss.shaded.zookeeper3.org.apache.zookeeper.server.metric.AvgMinMaxCounter;
import org.apache.fluss.shaded.zookeeper3.org.apache.zookeeper.server.metric.AvgMinMaxCounterSet;
import org.apache.fluss.shaded.zookeeper3.org.apache.zookeeper.server.metric.AvgMinMaxPercentileCounter;
import org.apache.fluss.shaded.zookeeper3.org.apache.zookeeper.server.metric.AvgMinMaxPercentileCounterSet;
import org.apache.fluss.shaded.zookeeper3.org.apache.zookeeper.server.metric.SimpleCounter;
import org.apache.fluss.shaded.zookeeper3.org.apache.zookeeper.server.metric.SimpleCounterSet;

public class DefaultMetricsProvider
implements MetricsProvider {
    private final DefaultMetricsContext rootMetricsContext = new DefaultMetricsContext();

    @Override
    public void configure(Properties configuration) throws MetricsProviderLifeCycleException {
    }

    @Override
    public void start() throws MetricsProviderLifeCycleException {
    }

    @Override
    public MetricsContext getRootContext() {
        return this.rootMetricsContext;
    }

    @Override
    public void stop() {
        this.rootMetricsContext.gauges.clear();
        this.rootMetricsContext.gaugeSets.clear();
    }

    @Override
    public void dump(BiConsumer<String, Object> sink) {
        this.rootMetricsContext.dump(sink);
    }

    @Override
    public void resetAllValues() {
        this.rootMetricsContext.reset();
    }

    private static final class DefaultMetricsContext
    implements MetricsContext {
        private final ConcurrentMap<String, Gauge> gauges = new ConcurrentHashMap<String, Gauge>();
        private final ConcurrentMap<String, GaugeSet> gaugeSets = new ConcurrentHashMap<String, GaugeSet>();
        private final ConcurrentMap<String, SimpleCounter> counters = new ConcurrentHashMap<String, SimpleCounter>();
        private final ConcurrentMap<String, SimpleCounterSet> counterSets = new ConcurrentHashMap<String, SimpleCounterSet>();
        private final ConcurrentMap<String, AvgMinMaxCounter> basicSummaries = new ConcurrentHashMap<String, AvgMinMaxCounter>();
        private final ConcurrentMap<String, AvgMinMaxPercentileCounter> summaries = new ConcurrentHashMap<String, AvgMinMaxPercentileCounter>();
        private final ConcurrentMap<String, AvgMinMaxCounterSet> basicSummarySets = new ConcurrentHashMap<String, AvgMinMaxCounterSet>();
        private final ConcurrentMap<String, AvgMinMaxPercentileCounterSet> summarySets = new ConcurrentHashMap<String, AvgMinMaxPercentileCounterSet>();

        private DefaultMetricsContext() {
        }

        @Override
        public MetricsContext getContext(String name) {
            return this;
        }

        @Override
        public Counter getCounter(String name) {
            return this.counters.computeIfAbsent(name, n -> new SimpleCounter((String)n));
        }

        @Override
        public CounterSet getCounterSet(String name) {
            Objects.requireNonNull(name, "Cannot register a CounterSet with null name");
            return this.counterSets.computeIfAbsent(name, SimpleCounterSet::new);
        }

        @Override
        public void registerGauge(String name, Gauge gauge) {
            Objects.requireNonNull(gauge, "Cannot register a null Gauge for " + name);
            this.gauges.put(name, gauge);
        }

        @Override
        public void unregisterGauge(String name) {
            this.gauges.remove(name);
        }

        @Override
        public void registerGaugeSet(String name, GaugeSet gaugeSet) {
            Objects.requireNonNull(name, "Cannot register a GaugeSet with null name");
            Objects.requireNonNull(gaugeSet, "Cannot register a null GaugeSet for " + name);
            this.gaugeSets.put(name, gaugeSet);
        }

        @Override
        public void unregisterGaugeSet(String name) {
            Objects.requireNonNull(name, "Cannot unregister GaugeSet with null name");
            this.gaugeSets.remove(name);
        }

        @Override
        public Summary getSummary(String name, MetricsContext.DetailLevel detailLevel) {
            if (detailLevel == MetricsContext.DetailLevel.BASIC) {
                return this.basicSummaries.computeIfAbsent(name, n -> {
                    if (this.summaries.containsKey(n)) {
                        throw new IllegalArgumentException("Already registered a non basic summary as " + n);
                    }
                    return new AvgMinMaxCounter(name);
                });
            }
            return this.summaries.computeIfAbsent(name, n -> {
                if (this.basicSummaries.containsKey(n)) {
                    throw new IllegalArgumentException("Already registered a basic summary as " + n);
                }
                return new AvgMinMaxPercentileCounter(name);
            });
        }

        @Override
        public SummarySet getSummarySet(String name, MetricsContext.DetailLevel detailLevel) {
            if (detailLevel == MetricsContext.DetailLevel.BASIC) {
                return this.basicSummarySets.computeIfAbsent(name, n -> {
                    if (this.summarySets.containsKey(n)) {
                        throw new IllegalArgumentException("Already registered a non basic summary set as " + n);
                    }
                    return new AvgMinMaxCounterSet(name);
                });
            }
            return this.summarySets.computeIfAbsent(name, n -> {
                if (this.basicSummarySets.containsKey(n)) {
                    throw new IllegalArgumentException("Already registered a basic summary set as " + n);
                }
                return new AvgMinMaxPercentileCounterSet(name);
            });
        }

        void dump(BiConsumer<String, Object> sink) {
            this.gauges.forEach((name, metric) -> {
                Number value = metric.get();
                if (value != null) {
                    sink.accept((String)name, value);
                }
            });
            this.gaugeSets.forEach((name, gaugeSet) -> gaugeSet.values().forEach((key, value) -> {
                if (key != null) {
                    sink.accept(key + "_" + name, value != null ? (Number)((Number)value) : (Number)0);
                }
            }));
            this.counters.values().forEach(metric -> metric.values().forEach(sink));
            this.counterSets.values().forEach(metric -> metric.values().forEach(sink));
            this.basicSummaries.values().forEach(metric -> metric.values().forEach(sink));
            this.summaries.values().forEach(metric -> metric.values().forEach(sink));
            this.basicSummarySets.values().forEach(metric -> metric.values().forEach(sink));
            this.summarySets.values().forEach(metric -> metric.values().forEach(sink));
        }

        void reset() {
            this.counters.values().forEach(metric -> metric.reset());
            this.counterSets.values().forEach(metric -> metric.reset());
            this.basicSummaries.values().forEach(metric -> metric.reset());
            this.summaries.values().forEach(metric -> metric.reset());
            this.basicSummarySets.values().forEach(metric -> metric.reset());
            this.summarySets.values().forEach(metric -> metric.reset());
        }
    }
}

