/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.shaded.zookeeper3.org.apache.zookeeper.server.auth;

import java.nio.charset.StandardCharsets;
import org.apache.fluss.shaded.zookeeper3.org.apache.zookeeper.KeeperException;
import org.apache.fluss.shaded.zookeeper3.org.apache.zookeeper.data.Id;
import org.apache.fluss.shaded.zookeeper3.org.apache.zookeeper.data.Stat;
import org.apache.fluss.shaded.zookeeper3.org.apache.zookeeper.server.ZKDatabase;
import org.apache.fluss.shaded.zookeeper3.org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.fluss.shaded.zookeeper3.org.apache.zookeeper.server.auth.ServerAuthenticationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyAuthenticationProvider
extends ServerAuthenticationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(KeyAuthenticationProvider.class);

    @Override
    public String getScheme() {
        return "key";
    }

    private byte[] getKey(ZooKeeperServer zks) {
        ZKDatabase db = zks.getZKDatabase();
        if (db != null) {
            try {
                Stat stat = new Stat();
                return db.getData("/key", stat, null);
            }
            catch (KeeperException.NoNodeException e) {
                LOG.error("getData failed", (Throwable)e);
            }
        }
        return null;
    }

    private boolean validate(byte[] key, byte[] auth) {
        try {
            String keyStr = new String(key, StandardCharsets.UTF_8);
            String authStr = new String(auth, StandardCharsets.UTF_8);
            int keyVal = Integer.parseInt(keyStr);
            int authVal = Integer.parseInt(authStr);
            if (keyVal != 0 && authVal % keyVal != 0) {
                return false;
            }
        }
        catch (NumberFormatException nfe) {
            LOG.error("bad formatting", (Throwable)nfe);
            return false;
        }
        return true;
    }

    @Override
    public KeeperException.Code handleAuthentication(ServerAuthenticationProvider.ServerObjs serverObjs, byte[] authData) {
        byte[] key = this.getKey(serverObjs.getZks());
        String authStr = new String(authData, StandardCharsets.UTF_8);
        String keyStr = "";
        if (key != null && !this.validate(key, authData)) {
            keyStr = new String(key, StandardCharsets.UTF_8);
            LOG.debug("KeyAuthenticationProvider handleAuthentication ({}, {}) -> FAIL.\n", (Object)keyStr, (Object)authStr);
            return KeeperException.Code.AUTHFAILED;
        }
        LOG.debug("KeyAuthenticationProvider handleAuthentication -> OK.\n");
        serverObjs.getCnxn().addAuthInfo(new Id(this.getScheme(), keyStr));
        return KeeperException.Code.OK;
    }

    @Override
    public boolean matches(ServerAuthenticationProvider.ServerObjs serverObjs, ServerAuthenticationProvider.MatchValues matchValues) {
        return matchValues.getId().equals(matchValues.getAclExpr());
    }

    @Override
    public boolean isAuthenticated() {
        return true;
    }

    @Override
    public boolean isValid(String id) {
        return true;
    }
}

