/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.shaded.zookeeper3.org.apache.zookeeper.server.quorum;

import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.fluss.shaded.zookeeper3.org.apache.zookeeper.server.ZooKeeperCriticalThread;
import org.apache.fluss.shaded.zookeeper3.org.apache.zookeeper.server.quorum.Learner;
import org.apache.fluss.shaded.zookeeper3.org.apache.zookeeper.server.quorum.QuorumPacket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LearnerSender
extends ZooKeeperCriticalThread {
    private static final Logger LOG = LoggerFactory.getLogger(LearnerSender.class);
    private final LinkedBlockingQueue<QuorumPacket> queuedPackets = new LinkedBlockingQueue();
    private final QuorumPacket proposalOfDeath = new QuorumPacket();
    Learner learner;

    public LearnerSender(Learner learner) {
        super("LearnerSender:" + learner.zk.getServerId(), learner.zk.getZooKeeperServerListener());
        this.learner = learner;
    }

    @Override
    public void run() {
        try {
            while (true) {
                QuorumPacket p;
                if ((p = this.queuedPackets.poll()) == null) {
                    this.learner.bufferedOutput.flush();
                    p = this.queuedPackets.take();
                }
                if (p != this.proposalOfDeath) {
                    this.learner.messageTracker.trackSent(p.getType());
                    this.learner.leaderOs.writeRecord(p, "packet");
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            this.handleException(this.getName(), e);
        }
        catch (InterruptedException e) {
            this.handleException(this.getName(), e);
        }
        LOG.info("LearnerSender exited");
    }

    public void queuePacket(QuorumPacket pp) throws IOException {
        if (pp == null) {
            this.learner.bufferedOutput.flush();
        } else {
            this.queuedPackets.add(pp);
        }
    }

    public void shutdown() {
        LOG.info("Shutting down LearnerSender");
        this.queuedPackets.clear();
        this.queuedPackets.add(this.proposalOfDeath);
    }
}

