/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.shaded.zookeeper3.org.apache.zookeeper.server.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class BitMap<T> {
    private final Map<T, Integer> value2Bit = new HashMap<T, Integer>();
    private final Map<Integer, T> bit2Value = new HashMap<Integer, T>();
    private final BitSet freedBitSet = new BitSet();
    private Integer nextBit = 0;
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"}, justification="SpotBugs false positive")
    public Integer add(T value) {
        Integer bit = this.getBit(value);
        if (bit != null) {
            return bit;
        }
        this.rwLock.writeLock().lock();
        try {
            Integer n;
            bit = this.value2Bit.get(value);
            if (bit != null) {
                Integer n2 = bit;
                return n2;
            }
            bit = this.freedBitSet.nextSetBit(0);
            if (bit > -1) {
                this.freedBitSet.clear(bit);
            } else {
                n = this.nextBit;
                Integer n3 = this.nextBit = Integer.valueOf(this.nextBit + 1);
                bit = n;
            }
            this.value2Bit.put(value, bit);
            this.bit2Value.put(bit, value);
            n = bit;
            return n;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public T get(int bit) {
        this.rwLock.readLock().lock();
        try {
            T t = this.bit2Value.get(bit);
            return t;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public Integer getBit(T value) {
        this.rwLock.readLock().lock();
        try {
            Integer n = this.value2Bit.get(value);
            return n;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int remove(T value) {
        this.rwLock.writeLock().lock();
        try {
            Integer bit = this.value2Bit.get(value);
            if (bit == null) {
                int n = -1;
                return n;
            }
            this.value2Bit.remove(value);
            this.bit2Value.remove(bit);
            this.freedBitSet.set(bit);
            int n = bit;
            return n;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T remove(int bit) {
        this.rwLock.writeLock().lock();
        try {
            T value = this.bit2Value.get(bit);
            if (value == null) {
                T t = null;
                return t;
            }
            this.value2Bit.remove(value);
            this.bit2Value.remove(bit);
            this.freedBitSet.set(bit);
            T t = value;
            return t;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public int size() {
        this.rwLock.readLock().lock();
        try {
            int n = this.value2Bit.size();
            return n;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }
}

