/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security;

import java.io.Serializable;
import org.apache.fulcrum.security.acl.AccessControlList;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.EntityExistsException;
import org.apache.fulcrum.security.util.PasswordMismatchException;
import org.apache.fulcrum.security.util.UnknownEntityException;
import org.apache.fulcrum.security.util.UserSet;

public interface UserManager
extends Serializable {
    public static final String ROLE = UserManager.class.getName();

    public <T extends User> T getUserInstance() throws DataBackendException;

    public <T extends User> T getUserInstance(String var1) throws DataBackendException;

    public boolean checkExists(User var1) throws DataBackendException;

    public boolean checkExists(String var1) throws DataBackendException;

    public <T extends User> T getUser(String var1) throws UnknownEntityException, DataBackendException;

    public <T extends User> T getUserById(Object var1) throws UnknownEntityException, DataBackendException;

    public <T extends User> T getUser(String var1, String var2) throws PasswordMismatchException, UnknownEntityException, DataBackendException;

    public UserSet getAllUsers() throws DataBackendException;

    public void saveUser(User var1) throws UnknownEntityException, DataBackendException;

    public void authenticate(User var1, String var2) throws PasswordMismatchException, UnknownEntityException, DataBackendException;

    public <T extends User> T addUser(T var1, String var2) throws EntityExistsException, DataBackendException;

    public void removeUser(User var1) throws UnknownEntityException, DataBackendException;

    public void changePassword(User var1, String var2, String var3) throws PasswordMismatchException, UnknownEntityException, DataBackendException;

    public void forcePassword(User var1, String var2) throws UnknownEntityException, DataBackendException;

    public <T extends AccessControlList> T getACL(User var1) throws UnknownEntityException;
}

