/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.format.row.binary;

import java.math.BigDecimal;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.fury.format.row.ArrayData;
import org.apache.fury.format.row.binary.BinaryMap;
import org.apache.fury.format.row.binary.BinaryRow;
import org.apache.fury.format.row.binary.UnsafeTrait;
import org.apache.fury.format.type.DataTypes;
import org.apache.fury.memory.BitUtils;
import org.apache.fury.memory.MemoryBuffer;
import org.apache.fury.memory.MemoryUtils;
import org.apache.fury.memory.Platform;
import org.apache.fury.util.Preconditions;

public class BinaryArray
extends UnsafeTrait
implements ArrayData {
    private final Field field;
    private final int elementSize;
    private MemoryBuffer buffer;
    private int numElements;
    private int elementOffset;
    private int baseOffset;
    private int sizeInBytes;

    public BinaryArray(Field field) {
        this.field = field;
        int width = DataTypes.getTypeWidth(((Field)field.getChildren().get(0)).getType());
        this.elementSize = width < 0 ? 8 : width;
        this.initializeExtData(1);
    }

    public void pointTo(MemoryBuffer buffer, int offset, int sizeInBytes) {
        int numElements = (int)buffer.getInt64(offset);
        assert (numElements >= 0) : "numElements (" + numElements + ") should >= 0";
        this.numElements = numElements;
        this.buffer = buffer;
        this.baseOffset = offset;
        this.sizeInBytes = sizeInBytes;
        this.elementOffset = offset + BinaryArray.calculateHeaderInBytes(this.numElements);
    }

    public Field getField() {
        return this.field;
    }

    @Override
    public int numElements() {
        return this.numElements;
    }

    @Override
    public MemoryBuffer getBuffer() {
        return this.buffer;
    }

    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    @Override
    public int getBaseOffset() {
        return this.baseOffset;
    }

    @Override
    public void assertIndexIsValid(int ordinal) {
        assert (ordinal >= 0) : "ordinal (" + ordinal + ") should >= 0";
        assert (ordinal < this.numElements) : "ordinal (" + ordinal + ") should < " + this.numElements;
    }

    @Override
    int getOffset(int ordinal) {
        return this.elementOffset + ordinal * this.elementSize;
    }

    @Override
    public void setNotNullAt(int ordinal) {
        this.assertIndexIsValid(ordinal);
        BitUtils.unset((MemoryBuffer)this.buffer, (int)(this.baseOffset + 8), (int)ordinal);
    }

    @Override
    public void setNullAt(int ordinal) {
        BitUtils.set((MemoryBuffer)this.buffer, (int)(this.baseOffset + 8), (int)ordinal);
    }

    @Override
    public boolean isNullAt(int ordinal) {
        return BitUtils.isSet((MemoryBuffer)this.buffer, (int)(this.baseOffset + 8), (int)ordinal);
    }

    @Override
    public BigDecimal getDecimal(int ordinal) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BinaryRow getStruct(int ordinal) {
        return this.getStruct(ordinal, (Field)this.field.getChildren().get(0), 0);
    }

    @Override
    public BinaryArray getArray(int ordinal) {
        return this.getArray(ordinal, (Field)this.field.getChildren().get(0));
    }

    @Override
    public BinaryMap getMap(int ordinal) {
        return this.getMap(ordinal, (Field)this.field.getChildren().get(0));
    }

    @Override
    public void setDecimal(int ordinal, BigDecimal value) {
        throw new UnsupportedOperationException();
    }

    public boolean[] toBooleanArray() {
        boolean[] values = new boolean[this.numElements];
        this.buffer.copyToUnsafe((long)this.elementOffset, (Object)values, (long)Platform.BOOLEAN_ARRAY_OFFSET, this.numElements);
        return values;
    }

    public byte[] toByteArray() {
        byte[] values = new byte[this.numElements];
        this.buffer.copyToUnsafe((long)this.elementOffset, (Object)values, (long)Platform.BYTE_ARRAY_OFFSET, this.numElements);
        return values;
    }

    public short[] toShortArray() {
        short[] values = new short[this.numElements];
        this.buffer.copyToUnsafe((long)this.elementOffset, (Object)values, (long)Platform.SHORT_ARRAY_OFFSET, this.numElements * 2);
        return values;
    }

    public int[] toIntArray() {
        int[] values = new int[this.numElements];
        this.buffer.copyToUnsafe((long)this.elementOffset, (Object)values, (long)Platform.INT_ARRAY_OFFSET, this.numElements * 4);
        return values;
    }

    public long[] toLongArray() {
        long[] values = new long[this.numElements];
        this.buffer.copyToUnsafe((long)this.elementOffset, (Object)values, (long)Platform.LONG_ARRAY_OFFSET, this.numElements * 8);
        return values;
    }

    public float[] toFloatArray() {
        float[] values = new float[this.numElements];
        this.buffer.copyToUnsafe((long)this.elementOffset, (Object)values, (long)Platform.FLOAT_ARRAY_OFFSET, this.numElements * 4);
        return values;
    }

    public double[] toDoubleArray() {
        double[] values = new double[this.numElements];
        this.buffer.copyToUnsafe((long)this.elementOffset, (Object)values, (long)Platform.DOUBLE_ARRAY_OFFSET, this.numElements * 8);
        return values;
    }

    @Override
    public ArrayData copy() {
        MemoryBuffer copyBuf = MemoryUtils.buffer((int)this.sizeInBytes);
        this.buffer.copyTo(this.baseOffset, copyBuf, 0, this.sizeInBytes);
        BinaryArray arrayCopy = new BinaryArray(this.field);
        arrayCopy.pointTo(copyBuf, 0, this.sizeInBytes);
        return arrayCopy;
    }

    public String toString() {
        Field valueField = (Field)this.field.getChildren().get(0);
        StringBuilder builder = new StringBuilder("[");
        for (int i = 0; i < this.numElements; ++i) {
            if (i != 0) {
                builder.append(',');
            }
            builder.append(this.get(i, valueField));
        }
        builder.append(']');
        return builder.toString();
    }

    private static BinaryArray fromPrimitiveArray(Object arr, int offset, int length, Field field) {
        long valueRegionInBytes;
        BinaryArray result = new BinaryArray(field);
        long headerInBytes = BinaryArray.calculateHeaderInBytes(length);
        long totalSize = headerInBytes + (valueRegionInBytes = (long)(result.elementSize * length));
        if (totalSize > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Cannot convert this array to binary format as it's too big.");
        }
        byte[] data = new byte[(int)totalSize];
        Platform.putLong((Object)data, (long)Platform.BYTE_ARRAY_OFFSET, (long)length);
        Platform.copyMemory((Object)arr, (long)offset, (Object)data, (long)((long)Platform.BYTE_ARRAY_OFFSET + headerInBytes), (long)valueRegionInBytes);
        MemoryBuffer memoryBuffer = MemoryUtils.wrap((byte[])data);
        result.pointTo(memoryBuffer, 0, (int)totalSize);
        return result;
    }

    public static BinaryArray fromPrimitiveArray(byte[] arr) {
        return BinaryArray.fromPrimitiveArray(arr, Platform.BYTE_ARRAY_OFFSET, arr.length, DataTypes.PRIMITIVE_BYTE_ARRAY_FIELD);
    }

    public static BinaryArray fromPrimitiveArray(boolean[] arr) {
        return BinaryArray.fromPrimitiveArray(arr, Platform.BOOLEAN_ARRAY_OFFSET, arr.length, DataTypes.PRIMITIVE_BOOLEAN_ARRAY_FIELD);
    }

    public static BinaryArray fromPrimitiveArray(short[] arr) {
        return BinaryArray.fromPrimitiveArray(arr, Platform.SHORT_ARRAY_OFFSET, arr.length, DataTypes.PRIMITIVE_SHORT_ARRAY_FIELD);
    }

    public static BinaryArray fromPrimitiveArray(int[] arr) {
        return BinaryArray.fromPrimitiveArray(arr, Platform.INT_ARRAY_OFFSET, arr.length, DataTypes.PRIMITIVE_INT_ARRAY_FIELD);
    }

    public static BinaryArray fromPrimitiveArray(long[] arr) {
        return BinaryArray.fromPrimitiveArray(arr, Platform.LONG_ARRAY_OFFSET, arr.length, DataTypes.PRIMITIVE_LONG_ARRAY_FIELD);
    }

    public static BinaryArray fromPrimitiveArray(float[] arr) {
        return BinaryArray.fromPrimitiveArray(arr, Platform.FLOAT_ARRAY_OFFSET, arr.length, DataTypes.PRIMITIVE_FLOAT_ARRAY_FIELD);
    }

    public static BinaryArray fromPrimitiveArray(double[] arr) {
        return BinaryArray.fromPrimitiveArray(arr, Platform.DOUBLE_ARRAY_OFFSET, arr.length, DataTypes.PRIMITIVE_DOUBLE_ARRAY_FIELD);
    }

    public static int calculateHeaderInBytes(int numElements) {
        return 8 + BitUtils.calculateBitmapWidthInBytes((int)numElements);
    }

    public static int[] getDimensions(BinaryArray array, int numDimensions) {
        Preconditions.checkArgument((numDimensions >= 1 ? 1 : 0) != 0);
        if (array == null) {
            return null;
        }
        int depth = 0;
        int[] dimensions = new int[numDimensions];
        int[] startFromLefts = new int[numDimensions];
        BinaryArray[] arrs = new BinaryArray[numDimensions];
        BinaryArray arr = array;
        while (depth < numDimensions) {
            int numElements;
            arrs[depth] = arr;
            dimensions[depth] = numElements = arr.numElements();
            if (depth == numDimensions - 1) break;
            boolean allNull = true;
            if (startFromLefts[depth] == numElements) {
                startFromLefts[depth] = 0;
                --depth;
                continue;
            }
            for (int i = startFromLefts[depth]; i < numElements; ++i) {
                if (arr.isNullAt(i)) continue;
                arr = arr.getArray(i);
                allNull = false;
                break;
            }
            if (allNull) {
                int n = --depth;
                startFromLefts[n] = startFromLefts[n] + 1;
                arr = arrs[depth];
            } else {
                ++depth;
            }
            if (depth > 0) continue;
            return null;
        }
        return dimensions;
    }
}

