/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.format.type;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.arrow.vector.ipc.ReadChannel;
import org.apache.arrow.vector.ipc.WriteChannel;
import org.apache.arrow.vector.ipc.message.MessageSerializer;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.fury.exception.FuryException;
import org.apache.fury.format.type.DefaultTypeVisitor;
import org.apache.fury.io.MemoryBufferOutputStream;
import org.apache.fury.memory.MemoryBuffer;
import org.apache.fury.type.Type;
import org.apache.fury.util.Preconditions;

public class DataTypes {
    public static Field PRIMITIVE_BOOLEAN_ARRAY_FIELD = DataTypes.primitiveArrayField((ArrowType)ArrowType.Bool.INSTANCE);
    public static Field PRIMITIVE_BYTE_ARRAY_FIELD = DataTypes.primitiveArrayField((ArrowType)DataTypes.intType(8));
    public static Field PRIMITIVE_SHORT_ARRAY_FIELD = DataTypes.primitiveArrayField((ArrowType)DataTypes.intType(16));
    public static Field PRIMITIVE_INT_ARRAY_FIELD = DataTypes.primitiveArrayField((ArrowType)DataTypes.intType(32));
    public static Field PRIMITIVE_LONG_ARRAY_FIELD = DataTypes.primitiveArrayField((ArrowType)DataTypes.intType(64));
    public static Field PRIMITIVE_FLOAT_ARRAY_FIELD = DataTypes.primitiveArrayField((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE));
    public static Field PRIMITIVE_DOUBLE_ARRAY_FIELD = DataTypes.primitiveArrayField((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE));
    public static final String ARRAY_ITEM_NAME = "item";
    private static final ArrowType.ArrowTypeVisitor<Integer> typeWidthVisitor = new DefaultTypeVisitor<Integer>(){

        @Override
        public Integer visit(ArrowType.Struct type) {
            return -1;
        }

        @Override
        public Integer visit(ArrowType.List type) {
            return -1;
        }

        @Override
        public Integer visit(ArrowType.Map type) {
            return -1;
        }

        @Override
        public Integer visit(ArrowType.Bool type) {
            return 1;
        }

        @Override
        public Integer visit(ArrowType.Int type) {
            return type.getBitWidth() / 8;
        }

        @Override
        public Integer visit(ArrowType.FloatingPoint type) {
            switch (type.getPrecision()) {
                case SINGLE: {
                    return 4;
                }
                case DOUBLE: {
                    return 8;
                }
            }
            return (Integer)this.unsupported((ArrowType)type);
        }

        @Override
        public Integer visit(ArrowType.Date type) {
            return 4;
        }

        @Override
        public Integer visit(ArrowType.Timestamp type) {
            return 8;
        }

        @Override
        public Integer visit(ArrowType.Binary type) {
            return -1;
        }

        @Override
        public Integer visit(ArrowType.Decimal type) {
            return -1;
        }

        @Override
        public Integer visit(ArrowType.Utf8 type) {
            return -1;
        }
    };
    private static final ArrowType.ArrowTypeVisitor<Type> typeIdVisitor = new DefaultTypeVisitor<Type>(){

        @Override
        public Type visit(ArrowType.Bool type) {
            return Type.BOOL;
        }

        @Override
        public Type visit(ArrowType.Int type) {
            if (type.getIsSigned()) {
                int byteWidth = type.getBitWidth() / 8;
                switch (byteWidth) {
                    case 1: {
                        return Type.INT8;
                    }
                    case 2: {
                        return Type.INT16;
                    }
                    case 4: {
                        return Type.INT32;
                    }
                    case 8: {
                        return Type.INT64;
                    }
                }
                return (Type)this.unsupported((ArrowType)type);
            }
            return (Type)this.unsupported((ArrowType)type);
        }

        @Override
        public Type visit(ArrowType.FloatingPoint type) {
            switch (type.getPrecision()) {
                case SINGLE: {
                    return Type.FLOAT;
                }
                case DOUBLE: {
                    return Type.DOUBLE;
                }
            }
            return (Type)this.unsupported((ArrowType)type);
        }

        @Override
        public Type visit(ArrowType.Date type) {
            switch (type.getUnit()) {
                case DAY: {
                    return Type.DATE32;
                }
                case MILLISECOND: {
                    return Type.DATE64;
                }
            }
            return (Type)this.unsupported((ArrowType)type);
        }

        @Override
        public Type visit(ArrowType.Timestamp type) {
            return Type.TIMESTAMP;
        }

        @Override
        public Type visit(ArrowType.Binary type) {
            return Type.BINARY;
        }

        @Override
        public Type visit(ArrowType.Decimal type) {
            return Type.DECIMAL;
        }

        @Override
        public Type visit(ArrowType.Utf8 type) {
            return Type.STRING;
        }

        @Override
        public Type visit(ArrowType.Struct type) {
            return Type.STRUCT;
        }

        @Override
        public Type visit(ArrowType.List type) {
            return Type.LIST;
        }

        @Override
        public Type visit(ArrowType.Map type) {
            return Type.MAP;
        }
    };

    public static int getTypeWidth(ArrowType type) {
        return (Integer)type.accept(typeWidthVisitor);
    }

    public static Type getTypeId(ArrowType type) {
        return (Type)type.accept(typeIdVisitor);
    }

    public static short getTypeIdValue(ArrowType type) {
        return ((Type)type.accept(typeIdVisitor)).getId();
    }

    public static ArrowType.Bool bool() {
        return ArrowType.Bool.INSTANCE;
    }

    public static ArrowType.Int intType(int bitWidth) {
        return new ArrowType.Int(bitWidth, true);
    }

    public static ArrowType.Int int8() {
        return DataTypes.intType(8);
    }

    public static ArrowType.Int int16() {
        return DataTypes.intType(16);
    }

    public static ArrowType.Int int32() {
        return DataTypes.intType(32);
    }

    public static ArrowType.Int int64() {
        return DataTypes.intType(64);
    }

    public static ArrowType.FloatingPoint float32() {
        return new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE);
    }

    public static ArrowType.FloatingPoint float64() {
        return new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE);
    }

    public static ArrowType.Date date32() {
        return new ArrowType.Date(DateUnit.DAY);
    }

    public static ArrowType.Date date64() {
        return new ArrowType.Date(DateUnit.MILLISECOND);
    }

    public static ArrowType.Timestamp timestamp() {
        return new ArrowType.Timestamp(TimeUnit.MICROSECOND, null);
    }

    public static ArrowType.Binary binary() {
        return ArrowType.Binary.INSTANCE;
    }

    public static ArrowType.Utf8 utf8() {
        return ArrowType.Utf8.INSTANCE;
    }

    public static ArrowType.Decimal decimal() {
        return DataTypes.decimal(38, 18);
    }

    public static ArrowType.Decimal decimal(int precision, int scale) {
        return new ArrowType.Decimal(precision, scale);
    }

    public static ArrowType.Decimal bigintDecimal() {
        return DataTypes.decimal(38, 0);
    }

    public static Field field(String name, FieldType fieldType) {
        return DataTypes.field(name, fieldType, Collections.emptyList());
    }

    public static Field field(String name, boolean nullable, ArrowType type, Field ... children) {
        return DataTypes.field(name, new FieldType(nullable, type, null), children);
    }

    public static Field field(String name, FieldType fieldType, Field ... children) {
        return DataTypes.field(name, fieldType, Arrays.asList(children));
    }

    public static Field field(String name, boolean nullable, ArrowType type, List<Field> children) {
        return DataTypes.field(name, new FieldType(nullable, type, null), children);
    }

    public static Field field(String name, ArrowType type, Field ... children) {
        return DataTypes.field(name, true, type, children);
    }

    public static Field field(String name, FieldType fieldType, List<Field> children) {
        return new Field(name, fieldType, children);
    }

    public static Field notNullField(String name, ArrowType type, Field ... children) {
        return DataTypes.field(name, false, type, children);
    }

    public static FieldType notNullFieldType(ArrowType type) {
        return new FieldType(false, type, null);
    }

    public static Field primitiveArrayField(ArrowType type) {
        return DataTypes.primitiveArrayField("", type);
    }

    public static Field primitiveArrayField(String name, ArrowType type) {
        return DataTypes.field(name, FieldType.nullable((ArrowType)ArrowType.List.INSTANCE), Collections.singletonList(DataTypes.field(ARRAY_ITEM_NAME, false, type, new Field[0])));
    }

    public static Field arrayField(ArrowType type) {
        return DataTypes.arrayField("", type);
    }

    public static Field arrayField(String name, ArrowType type) {
        return DataTypes.field(name, FieldType.nullable((ArrowType)ArrowType.List.INSTANCE), Collections.singletonList(DataTypes.field(ARRAY_ITEM_NAME, true, type, new Field[0])));
    }

    public static Field arrayField(FieldType valueType) {
        return DataTypes.arrayField("", valueType);
    }

    public static Field arrayField(String name, FieldType valueType) {
        return DataTypes.field(name, FieldType.nullable((ArrowType)ArrowType.List.INSTANCE), Collections.singletonList(DataTypes.field(ARRAY_ITEM_NAME, valueType)));
    }

    public static Field arrayField(Field valueField) {
        return DataTypes.arrayField("", valueField);
    }

    public static Field arrayField(String name, Field valueField) {
        return DataTypes.field(name, FieldType.nullable((ArrowType)ArrowType.List.INSTANCE), Collections.singletonList(valueField));
    }

    public static Field arrayElementField(Field field) {
        return (Field)field.getChildren().get(0);
    }

    public static Field mapField(ArrowType keyType, ArrowType itemType) {
        return DataTypes.mapField("", keyType, itemType);
    }

    public static Field mapField(String name, ArrowType keyType, ArrowType itemType) {
        return DataTypes.mapField(name, DataTypes.field("key", false, keyType, new Field[0]), DataTypes.field("value", true, itemType, new Field[0]));
    }

    public static Field mapField(String name, Field keyField, Field itemField) {
        Preconditions.checkArgument((!keyField.isNullable() ? 1 : 0) != 0, (String)"Map's keys must be non-nullable");
        Field valueField = DataTypes.structField(false, keyField, itemField);
        return DataTypes.field(name, true, (ArrowType)new ArrowType.Map(false), valueField);
    }

    public static Field keyFieldForMap(Field mapField) {
        return (Field)((Field)mapField.getChildren().get(0)).getChildren().get(0);
    }

    public static Field itemFieldForMap(Field mapField) {
        return (Field)((Field)mapField.getChildren().get(0)).getChildren().get(1);
    }

    public static Field keyArrayFieldForMap(Field mapField) {
        return DataTypes.arrayField("keys", DataTypes.keyFieldForMap(mapField));
    }

    public static Field itemArrayFieldForMap(Field mapField) {
        return DataTypes.arrayField("items", DataTypes.itemFieldForMap(mapField));
    }

    public static Schema schemaFromStructField(Field structField) {
        return new Schema((Iterable)structField.getChildren(), structField.getMetadata());
    }

    public static Schema createSchema(Field field) {
        return new Schema((Iterable)field.getChildren(), field.getMetadata());
    }

    public static Field structField(boolean nullable, Field ... fields) {
        return DataTypes.structField("", nullable, fields);
    }

    public static Field structField(String name, boolean nullable, Field ... fields) {
        return DataTypes.field(name, nullable, (ArrowType)ArrowType.Struct.INSTANCE, fields);
    }

    public static Field structField(String name, boolean nullable, List<Field> fields) {
        return DataTypes.field(name, nullable, (ArrowType)ArrowType.Struct.INSTANCE, fields);
    }

    public static Field fieldOfSchema(Schema schema, int index) {
        return (Field)schema.getFields().get(index);
    }

    public static void serializeSchema(Schema schema, MemoryBuffer buffer) {
        try (MemoryBufferOutputStream outputStream = new MemoryBufferOutputStream(buffer);
             WriteChannel writeChannel = new WriteChannel(Channels.newChannel((OutputStream)outputStream));){
            MessageSerializer.serialize((WriteChannel)writeChannel, (Schema)schema);
        }
        catch (IOException e) {
            throw new FuryException(String.format("Write schema %s failed", schema), (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    public static byte[] serializeSchema(Schema schema) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Schema deserializeSchema(byte[] bytes) {
        try (ReadChannel readChannel = new ReadChannel(Channels.newChannel(new ByteArrayInputStream(bytes)));){
            Schema schema = MessageSerializer.deserializeSchema((ReadChannel)readChannel);
            return schema;
        }
        catch (IOException e) {
            throw new FuryException("Deserialize schema failed", (Throwable)e);
        }
    }

    public static long computeSchemaHash(Schema schema) {
        long hash = 17L;
        for (Field field : schema.getFields()) {
            hash = DataTypes.computeHash(hash, field);
        }
        return hash;
    }

    private static long computeHash(long hash, Field field) {
        Type typeID = DataTypes.getTypeId(field.getType());
        while (true) {
            try {
                hash = Math.addExact(Math.multiplyExact(hash, 31L), (long)typeID.getId());
            }
            catch (ArithmeticException e) {
                hash >>= 2;
                continue;
            }
            break;
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        switch (typeID) {
            case LIST: {
                fields.add(DataTypes.arrayElementField(field));
                break;
            }
            case MAP: {
                fields.add(DataTypes.keyFieldForMap(field));
                fields.add(DataTypes.itemFieldForMap(field));
                break;
            }
            case STRUCT: {
                fields.addAll(field.getChildren());
                break;
            }
            default: {
                Preconditions.checkArgument((field.getChildren().size() == 0 ? 1 : 0) != 0, (String)"field type should not be nested, but got type id %s field %s.", (Object)typeID, (Object[])new Object[]{field});
            }
        }
        for (Field child : fields) {
            hash = DataTypes.computeHash(hash, child);
        }
        return hash;
    }
}

