/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.format.type;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.fury.collection.Tuple2;
import org.apache.fury.format.type.DataTypes;
import org.apache.fury.reflect.TypeRef;
import org.apache.fury.type.Descriptor;
import org.apache.fury.type.TypeUtils;
import org.apache.fury.util.Preconditions;
import org.apache.fury.util.StringUtils;

public class TypeInference {
    public static Schema inferSchema(Type type) {
        return TypeInference.inferSchema(TypeRef.of((Type)type));
    }

    public static Schema inferSchema(Class<?> clz) {
        return TypeInference.inferSchema(TypeRef.of(clz));
    }

    public static Schema inferSchema(TypeRef<?> typeRef) {
        return TypeInference.inferSchema(typeRef, true);
    }

    public static Schema inferSchema(TypeRef<?> typeRef, boolean forStruct) {
        Field field = TypeInference.inferField(typeRef);
        if (forStruct) {
            Preconditions.checkArgument((field.getType().getTypeID() == ArrowType.ArrowTypeID.Struct ? 1 : 0) != 0);
            return new Schema((Iterable)field.getChildren());
        }
        return new Schema(Arrays.asList(field));
    }

    public static Optional<ArrowType> getDataType(Class<?> cls) {
        return TypeInference.getDataType(TypeRef.of(cls));
    }

    public static Optional<ArrowType> getDataType(TypeRef<?> typeRef) {
        try {
            return Optional.of(TypeInference.inferDataType(typeRef));
        }
        catch (UnsupportedOperationException e) {
            return Optional.empty();
        }
    }

    public static ArrowType inferDataType(TypeRef<?> typeRef) {
        return TypeInference.inferField(typeRef).getType();
    }

    public static Field arrayInferField(Type arrayType, Type type) {
        return TypeInference.arrayInferField(TypeRef.of((Type)arrayType), TypeRef.of((Type)type));
    }

    public static Field arrayInferField(Class<?> arrayClz, Class<?> clz) {
        return TypeInference.arrayInferField(TypeRef.of(arrayClz), TypeRef.of(clz));
    }

    public static Field arrayInferField(TypeRef<?> arrayTypeRef, TypeRef<?> typeRef) {
        Field field = TypeInference.inferField(arrayTypeRef, typeRef);
        Preconditions.checkArgument((field.getType().getTypeID() == ArrowType.ArrowTypeID.List ? 1 : 0) != 0);
        return field;
    }

    private static Field inferField(TypeRef<?> typeRef) {
        return TypeInference.inferField(null, typeRef);
    }

    private static Field inferField(TypeRef<?> arrayTypeRef, TypeRef<?> typeRef) {
        LinkedHashSet seenTypeSet = new LinkedHashSet();
        String name = "";
        if (arrayTypeRef != null) {
            Field f = TypeInference.inferField("item", typeRef, seenTypeSet);
            return DataTypes.arrayField(name, f);
        }
        return TypeInference.inferField("", typeRef, seenTypeSet);
    }

    private static Field inferField(String name, TypeRef<?> typeRef, LinkedHashSet<Class<?>> seenTypeSet) {
        Class rawType = TypeUtils.getRawType(typeRef);
        if (rawType == Boolean.TYPE) {
            return DataTypes.field(name, DataTypes.notNullFieldType((ArrowType)ArrowType.Bool.INSTANCE));
        }
        if (rawType == Byte.TYPE) {
            return DataTypes.field(name, DataTypes.notNullFieldType((ArrowType)new ArrowType.Int(8, true)));
        }
        if (rawType == Short.TYPE) {
            return DataTypes.field(name, DataTypes.notNullFieldType((ArrowType)new ArrowType.Int(16, true)));
        }
        if (rawType == Integer.TYPE) {
            return DataTypes.field(name, DataTypes.notNullFieldType((ArrowType)new ArrowType.Int(32, true)));
        }
        if (rawType == Long.TYPE) {
            return DataTypes.field(name, DataTypes.notNullFieldType((ArrowType)new ArrowType.Int(64, true)));
        }
        if (rawType == Float.TYPE) {
            return DataTypes.field(name, DataTypes.notNullFieldType((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE)));
        }
        if (rawType == Double.TYPE) {
            return DataTypes.field(name, DataTypes.notNullFieldType((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE)));
        }
        if (rawType == Boolean.class) {
            return DataTypes.field(name, FieldType.nullable((ArrowType)ArrowType.Bool.INSTANCE));
        }
        if (rawType == Byte.class) {
            return DataTypes.field(name, FieldType.nullable((ArrowType)new ArrowType.Int(8, true)));
        }
        if (rawType == Short.class) {
            return DataTypes.field(name, FieldType.nullable((ArrowType)new ArrowType.Int(16, true)));
        }
        if (rawType == Integer.class) {
            return DataTypes.field(name, FieldType.nullable((ArrowType)new ArrowType.Int(32, true)));
        }
        if (rawType == Long.class) {
            return DataTypes.field(name, FieldType.nullable((ArrowType)new ArrowType.Int(64, true)));
        }
        if (rawType == Float.class) {
            return DataTypes.field(name, FieldType.nullable((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE)));
        }
        if (rawType == Double.class) {
            return DataTypes.field(name, FieldType.nullable((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE)));
        }
        if (rawType == BigDecimal.class) {
            return DataTypes.field(name, FieldType.nullable((ArrowType)new ArrowType.Decimal(38, 18)));
        }
        if (rawType == BigInteger.class) {
            return DataTypes.field(name, FieldType.nullable((ArrowType)new ArrowType.Decimal(38, 0)));
        }
        if (rawType == LocalDate.class) {
            return DataTypes.field(name, FieldType.nullable((ArrowType)new ArrowType.Date(DateUnit.DAY)));
        }
        if (rawType == Date.class) {
            return DataTypes.field(name, FieldType.nullable((ArrowType)new ArrowType.Date(DateUnit.DAY)));
        }
        if (rawType == Timestamp.class) {
            return DataTypes.field(name, FieldType.nullable((ArrowType)new ArrowType.Timestamp(TimeUnit.MICROSECOND, null)));
        }
        if (rawType == Instant.class) {
            return DataTypes.field(name, FieldType.nullable((ArrowType)new ArrowType.Timestamp(TimeUnit.MICROSECOND, null)));
        }
        if (rawType == String.class) {
            return DataTypes.field(name, FieldType.nullable((ArrowType)ArrowType.Utf8.INSTANCE));
        }
        if (rawType.isEnum()) {
            return DataTypes.field(name, FieldType.nullable((ArrowType)ArrowType.Utf8.INSTANCE));
        }
        if (rawType.isArray()) {
            Field f = TypeInference.inferField("item", Objects.requireNonNull(typeRef.getComponentType()), seenTypeSet);
            return DataTypes.arrayField(name, f);
        }
        if (TypeUtils.ITERABLE_TYPE.isSupertypeOf(typeRef)) {
            Field f = TypeInference.inferField("item", TypeUtils.getElementType(typeRef), seenTypeSet);
            return DataTypes.arrayField(name, f);
        }
        if (TypeUtils.MAP_TYPE.isSupertypeOf(typeRef)) {
            Tuple2 kvType = TypeUtils.getMapKeyValueType(typeRef);
            Field keyField = TypeInference.inferField("key", (TypeRef)kvType.f0, seenTypeSet);
            FieldType keyFieldType = new FieldType(false, keyField.getType(), keyField.getDictionary(), keyField.getMetadata());
            keyField = DataTypes.field(keyField.getName(), keyFieldType, keyField.getChildren());
            Field valueField = TypeInference.inferField("value", (TypeRef)kvType.f1, seenTypeSet);
            return DataTypes.mapField(name, keyField, valueField);
        }
        if (TypeUtils.isBean((Class)rawType)) {
            if (seenTypeSet.contains(rawType)) {
                String msg = String.format("circular references in bean class is not allowed, but got %s in %s", rawType, seenTypeSet);
                throw new UnsupportedOperationException(msg);
            }
            List<Field> fields = Descriptor.getDescriptors((Class)rawType).stream().map(descriptor -> {
                LinkedHashSet newSeenTypeSet = new LinkedHashSet(seenTypeSet);
                newSeenTypeSet.add(rawType);
                String n = StringUtils.lowerCamelToLowerUnderscore((String)descriptor.getName());
                return TypeInference.inferField(n, descriptor.getTypeRef(), newSeenTypeSet);
            }).collect(Collectors.toList());
            return DataTypes.structField(name, true, fields);
        }
        throw new UnsupportedOperationException(String.format("Unsupported type %s for field %s, seen type set is %s", typeRef, name, seenTypeSet));
    }

    public static String inferTypeName(TypeRef<?> token) {
        StringBuilder sb = new StringBuilder();
        if (TypeUtils.ITERABLE_TYPE.isSupertypeOf(token)) {
            sb.append("Array_");
            sb.append(TypeInference.inferTypeName(TypeUtils.getElementType(token)));
        } else if (TypeUtils.MAP_TYPE.isSupertypeOf(token)) {
            sb.append("Map_");
            Tuple2 mapKeyValueType = TypeUtils.getMapKeyValueType(token);
            sb.append(TypeInference.inferTypeName((TypeRef)mapKeyValueType.f0));
            sb.append("_").append(TypeInference.inferTypeName((TypeRef)mapKeyValueType.f1));
        } else {
            sb.append(token.getRawType().getSimpleName());
        }
        return sb.toString();
    }
}

