/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.format.vectorized;

import java.util.Arrays;
import java.util.stream.IntStream;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeStampMicroTZVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.fury.format.row.Row;
import org.apache.fury.format.type.DefaultTypeVisitor;
import org.apache.fury.format.vectorized.ArrowArrayWriter;
import org.apache.fury.format.vectorized.BinaryWriter;
import org.apache.fury.format.vectorized.BooleanWriter;
import org.apache.fury.format.vectorized.ByteWriter;
import org.apache.fury.format.vectorized.DateWriter;
import org.apache.fury.format.vectorized.DecimalWriter;
import org.apache.fury.format.vectorized.DoubleWriter;
import org.apache.fury.format.vectorized.FloatWriter;
import org.apache.fury.format.vectorized.IntWriter;
import org.apache.fury.format.vectorized.ListWriter;
import org.apache.fury.format.vectorized.LongWriter;
import org.apache.fury.format.vectorized.MapWriter;
import org.apache.fury.format.vectorized.ShortWriter;
import org.apache.fury.format.vectorized.StringWriter;
import org.apache.fury.format.vectorized.StructWriter;
import org.apache.fury.format.vectorized.TimestampWriter;

public class ArrowWriter {
    private int rowCount = 0;
    private final VectorSchemaRoot root;
    private final VectorUnloader unloader;
    private final ArrowArrayWriter[] fieldWriters;

    public ArrowWriter(VectorSchemaRoot root) {
        this.root = root;
        this.unloader = new VectorUnloader(root);
        this.fieldWriters = (ArrowArrayWriter[])root.getFieldVectors().stream().map(valueVector -> {
            valueVector.allocateNew();
            return ArrowWriter.createFieldWriter((ValueVector)valueVector);
        }).toArray(ArrowArrayWriter[]::new);
    }

    public void write(Row row) {
        for (int i = 0; i < this.fieldWriters.length; ++i) {
            this.fieldWriters[i].write(row, i);
        }
        ++this.rowCount;
    }

    public VectorSchemaRoot finish() {
        Arrays.stream(this.fieldWriters).forEach(ArrowArrayWriter::finish);
        this.root.setRowCount(this.rowCount);
        return this.root;
    }

    public ArrowRecordBatch finishAsRecordBatch() {
        Arrays.stream(this.fieldWriters).forEach(ArrowArrayWriter::finish);
        this.root.setRowCount(this.rowCount);
        return this.unloader.getRecordBatch();
    }

    public void reset() {
        Arrays.stream(this.fieldWriters).forEach(ArrowArrayWriter::reset);
        this.root.setRowCount(0);
        this.rowCount = 0;
    }

    private static ArrowArrayWriter createFieldWriter(final ValueVector vector) {
        DefaultTypeVisitor<ArrowArrayWriter> typeVisitor = new DefaultTypeVisitor<ArrowArrayWriter>(){

            @Override
            public ArrowArrayWriter visit(ArrowType.Bool type) {
                return new BooleanWriter((BitVector)vector);
            }

            @Override
            public ArrowArrayWriter visit(ArrowType.Int type) {
                if (type.getIsSigned()) {
                    int byteWidth = type.getBitWidth() / 8;
                    switch (byteWidth) {
                        case 1: {
                            return new ByteWriter((TinyIntVector)vector);
                        }
                        case 2: {
                            return new ShortWriter((SmallIntVector)vector);
                        }
                        case 4: {
                            return new IntWriter((IntVector)vector);
                        }
                        case 8: {
                            return new LongWriter((BigIntVector)vector);
                        }
                    }
                    return (ArrowArrayWriter)this.unsupported((ArrowType)type);
                }
                return (ArrowArrayWriter)this.unsupported((ArrowType)type);
            }

            @Override
            public ArrowArrayWriter visit(ArrowType.FloatingPoint type) {
                switch (type.getPrecision()) {
                    case SINGLE: {
                        return new FloatWriter((Float4Vector)vector);
                    }
                    case DOUBLE: {
                        return new DoubleWriter((Float8Vector)vector);
                    }
                }
                return (ArrowArrayWriter)this.unsupported((ArrowType)type);
            }

            @Override
            public ArrowArrayWriter visit(ArrowType.Date type) {
                if (type.getUnit() == DateUnit.DAY) {
                    return new DateWriter((DateDayVector)vector);
                }
                return (ArrowArrayWriter)this.unsupported((ArrowType)type);
            }

            @Override
            public ArrowArrayWriter visit(ArrowType.Timestamp type) {
                return new TimestampWriter((TimeStampMicroTZVector)vector);
            }

            @Override
            public ArrowArrayWriter visit(ArrowType.Binary type) {
                return new BinaryWriter((VarBinaryVector)vector);
            }

            @Override
            public ArrowArrayWriter visit(ArrowType.Decimal type) {
                return new DecimalWriter((DecimalVector)vector);
            }

            @Override
            public ArrowArrayWriter visit(ArrowType.Utf8 type) {
                return new StringWriter((VarCharVector)vector);
            }

            @Override
            public ArrowArrayWriter visit(ArrowType.Struct type) {
                StructVector structVector = (StructVector)vector;
                ArrowArrayWriter[] childWriters = (ArrowArrayWriter[])IntStream.range(0, structVector.size()).mapToObj(i -> ArrowWriter.createFieldWriter(structVector.getChildByOrdinal(i))).toArray(ArrowArrayWriter[]::new);
                return new StructWriter(structVector, childWriters);
            }

            @Override
            public ArrowArrayWriter visit(ArrowType.List type) {
                ListVector listVector = (ListVector)vector;
                return new ListWriter(listVector, ArrowWriter.createFieldWriter((ValueVector)listVector.getDataVector()));
            }

            @Override
            public ArrowArrayWriter visit(ArrowType.Map type) {
                MapVector mapVector = (MapVector)vector;
                StructVector structVector = (StructVector)mapVector.getDataVector();
                ArrowArrayWriter keyWriter = ArrowWriter.createFieldWriter((ValueVector)structVector.getChild("key"));
                ArrowArrayWriter valueWriter = ArrowWriter.createFieldWriter((ValueVector)structVector.getChild("value"));
                return new MapWriter(mapVector, keyWriter, valueWriter);
            }
        };
        return (ArrowArrayWriter)vector.getField().getType().accept((ArrowType.ArrowTypeVisitor)typeVisitor);
    }
}

