/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.format.vectorized;

import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.fury.format.row.ArrayData;
import org.apache.fury.format.row.Getters;
import org.apache.fury.format.vectorized.ArrowArrayWriter;

class ListWriter
extends ArrowArrayWriter {
    private final ListVector valueVector;
    private final ArrowArrayWriter childWriter;

    ListWriter(ListVector valueVector, ArrowArrayWriter childWriter) {
        this.valueVector = valueVector;
        this.childWriter = childWriter;
    }

    @Override
    void appendValue(Getters getters, int fieldIndex) {
        ArrayData array = getters.getArray(fieldIndex);
        this.valueVector.startNewValue(this.rowCount);
        for (int i = 0; i < array.numElements(); ++i) {
            this.childWriter.write(array, i);
        }
        this.valueVector.endValue(this.rowCount, array.numElements());
    }

    @Override
    void appendNull() {
    }

    @Override
    void finish() {
        this.childWriter.finish();
        super.finish();
    }

    @Override
    void reset() {
        this.childWriter.reset();
        super.reset();
    }

    @Override
    ValueVector valueVector() {
        return this.valueVector;
    }
}

