/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.format.vectorized;

import java.util.Arrays;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.fury.format.row.Getters;
import org.apache.fury.format.row.Row;
import org.apache.fury.format.vectorized.ArrowArrayWriter;

class StructWriter
extends ArrowArrayWriter {
    private final StructVector valueVector;
    private final ArrowArrayWriter[] childWriters;

    StructWriter(StructVector valueVector, ArrowArrayWriter[] childWriters) {
        this.valueVector = valueVector;
        this.childWriters = childWriters;
    }

    @Override
    void appendValue(Getters getters, int fieldIndex) {
        Row row = getters.getStruct(fieldIndex);
        for (int i = 0; i < this.childWriters.length; ++i) {
            this.childWriters[i].write(row, i);
        }
        this.valueVector.setIndexDefined(this.rowCount);
    }

    @Override
    void appendNull() {
        for (ArrowArrayWriter childWriter : this.childWriters) {
            childWriter.appendNull();
            ++childWriter.rowCount;
        }
        this.valueVector.setNull(this.rowCount);
    }

    @Override
    void finish() {
        Arrays.stream(this.childWriters).forEach(ArrowArrayWriter::finish);
        super.finish();
    }

    @Override
    void reset() {
        Arrays.stream(this.childWriters).forEach(ArrowArrayWriter::reset);
        super.reset();
    }

    @Override
    ValueVector valueVector() {
        return this.valueVector;
    }
}

