/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.format.encoder;

import org.apache.fury.annotation.Internal;
import org.apache.fury.codegen.ClosureVisitable;
import org.apache.fury.codegen.Code;
import org.apache.fury.codegen.CodeGenerator;
import org.apache.fury.codegen.CodegenContext;
import org.apache.fury.codegen.Expression;
import org.apache.fury.format.row.binary.BinaryArray;
import org.apache.fury.format.row.binary.BinaryUtils;
import org.apache.fury.reflect.TypeRef;
import org.apache.fury.type.TypeUtils;
import org.apache.fury.util.Preconditions;
import org.apache.fury.util.StringUtils;
import org.apache.fury.util.function.SerializableBiFunction;
import org.apache.fury.util.function.SerializableFunction;

@Internal
public class ArrayDataForEach
extends Expression.AbstractExpression {
    private final Expression inputArrayData;
    private final String accessMethod;
    private final TypeRef<?> elemType;
    @ClosureVisitable
    private final SerializableBiFunction<Expression, Expression, Expression> notNullAction;
    @ClosureVisitable
    private final SerializableFunction<Expression, Expression> nullAction;

    public ArrayDataForEach(Expression inputArrayData, TypeRef<?> elemType, SerializableBiFunction<Expression, Expression, Expression> notNullAction) {
        this(inputArrayData, elemType, notNullAction, null);
    }

    public ArrayDataForEach(Expression inputArrayData, TypeRef<?> elemType, SerializableBiFunction<Expression, Expression, Expression> notNullAction, SerializableFunction<Expression, Expression> nullAction) {
        super(inputArrayData);
        Preconditions.checkArgument((TypeUtils.getRawType((TypeRef)inputArrayData.type()) == BinaryArray.class ? 1 : 0) != 0);
        this.inputArrayData = inputArrayData;
        this.accessMethod = BinaryUtils.getElemAccessMethodName(elemType);
        this.elemType = BinaryUtils.getElemReturnType(elemType);
        this.notNullAction = notNullAction;
        this.nullAction = nullAction;
    }

    public TypeRef<?> type() {
        return TypeUtils.PRIMITIVE_VOID_TYPE;
    }

    public Code.ExprCode doGenCode(CodegenContext ctx) {
        StringBuilder codeBuilder = new StringBuilder();
        Code.ExprCode targetExprCode = this.inputArrayData.genCode(ctx);
        if (StringUtils.isNotBlank((CharSequence)targetExprCode.code())) {
            codeBuilder.append(targetExprCode.code()).append("\n");
        }
        String[] freshNames = ctx.newNames(new String[]{"i", "elemValue", "len"});
        String i = freshNames[0];
        String elemValue = freshNames[1];
        String len = freshNames[2];
        Expression.Reference elemValueRef = new Expression.Reference(elemValue, this.elemType);
        Code.ExprCode notNullElemExprCode = ((Expression)this.notNullAction.apply((Object)new Expression.Reference(i), (Object)elemValueRef)).genCode(ctx);
        if (this.nullAction == null) {
            String code = StringUtils.format((String)"int ${len} = ${arr}.numElements();\nint ${i} = 0;\nwhile (${i} < ${len}) {\n    if (!${arr}.isNullAt(${i})) {\n        ${elemType} ${elemValue} = ${arr}.${method}(${i});\n        ${notNullElemExprCode}\n    }\n    ${i}++;\n}", (Object[])new Object[]{"arr", targetExprCode.value(), "len", len, "i", i, "elemType", ctx.type(this.elemType), "elemValue", elemValue, "method", this.accessMethod, "notNullElemExprCode", CodeGenerator.alignIndent((String)notNullElemExprCode.code(), (int)8)});
            codeBuilder.append(code);
        } else {
            Code.ExprCode nullExprCode = ((Expression)this.nullAction.apply((Object)new Expression.Reference(i))).genCode(ctx);
            String code = StringUtils.format((String)"int ${len} = ${arr}.numElements();\nint ${i} = 0;\nwhile (${i} < ${len}) {\n    if (!${arr}.isNullAt(${i})) {\n        ${elemType} ${elemValue} = ${arr}.${method}(${i});\n        ${notNullElemExprCode}\n    } else {\n        ${nullElemExprCode}\n    }\n    ${i}++;\n}", (Object[])new Object[]{"arr", targetExprCode.value(), "len", len, "i", i, "elemType", ctx.type(this.elemType), "elemValue", elemValue, "method", this.accessMethod, "notNullElemExprCode", CodeGenerator.alignIndent((String)notNullElemExprCode.code(), (int)8), "nullElemExprCode", CodeGenerator.alignIndent((String)nullExprCode.code(), (int)8)});
            codeBuilder.append(code);
        }
        return new Code.ExprCode(codeBuilder.toString(), null, null);
    }
}

