/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.format.row.binary;

import org.apache.fury.format.row.binary.BinaryArray;
import org.apache.fury.format.row.binary.BinaryMap;
import org.apache.fury.format.row.binary.BinaryRow;
import org.apache.fury.memory.MemoryBuffer;
import org.apache.fury.reflect.TypeRef;
import org.apache.fury.type.TypeUtils;

public class BinaryUtils {
    public static String getElemAccessMethodName(TypeRef type) {
        if (TypeUtils.PRIMITIVE_BYTE_TYPE.equals((Object)type) || TypeUtils.BYTE_TYPE.equals((Object)type)) {
            return "getByte";
        }
        if (TypeUtils.PRIMITIVE_BOOLEAN_TYPE.equals((Object)type) || TypeUtils.BOOLEAN_TYPE.equals((Object)type)) {
            return "getBoolean";
        }
        if (TypeUtils.PRIMITIVE_SHORT_TYPE.equals((Object)type) || TypeUtils.SHORT_TYPE.equals((Object)type)) {
            return "getInt16";
        }
        if (TypeUtils.PRIMITIVE_INT_TYPE.equals((Object)type) || TypeUtils.INT_TYPE.equals((Object)type)) {
            return "getInt32";
        }
        if (TypeUtils.PRIMITIVE_LONG_TYPE.equals((Object)type) || TypeUtils.LONG_TYPE.equals((Object)type)) {
            return "getInt64";
        }
        if (TypeUtils.PRIMITIVE_FLOAT_TYPE.equals((Object)type) || TypeUtils.FLOAT_TYPE.equals((Object)type)) {
            return "getFloat32";
        }
        if (TypeUtils.PRIMITIVE_DOUBLE_TYPE.equals((Object)type) || TypeUtils.DOUBLE_TYPE.equals((Object)type)) {
            return "getFloat64";
        }
        if (TypeUtils.BIG_DECIMAL_TYPE.equals((Object)type)) {
            return "getDecimal";
        }
        if (TypeUtils.DATE_TYPE.equals((Object)type)) {
            return "getDate";
        }
        if (TypeUtils.TIMESTAMP_TYPE.equals((Object)type)) {
            return "getTimestamp";
        }
        if (TypeUtils.STRING_TYPE.equals((Object)type)) {
            return "getString";
        }
        if (type.isArray() || TypeUtils.ITERABLE_TYPE.isSupertypeOf(type)) {
            return "getArray";
        }
        if (TypeUtils.MAP_TYPE.isSupertypeOf(type)) {
            return "getMap";
        }
        if (TypeUtils.isBean((TypeRef)type)) {
            return "getStruct";
        }
        return "getBuffer";
    }

    public static TypeRef<?> getElemReturnType(TypeRef<?> type) {
        if (TypeUtils.PRIMITIVE_BYTE_TYPE.equals(type) || TypeUtils.BYTE_TYPE.equals(type)) {
            return TypeUtils.PRIMITIVE_BYTE_TYPE;
        }
        if (TypeUtils.PRIMITIVE_BOOLEAN_TYPE.equals(type) || TypeUtils.BOOLEAN_TYPE.equals(type)) {
            return TypeUtils.PRIMITIVE_BOOLEAN_TYPE;
        }
        if (TypeUtils.PRIMITIVE_SHORT_TYPE.equals(type) || TypeUtils.SHORT_TYPE.equals(type)) {
            return TypeUtils.PRIMITIVE_SHORT_TYPE;
        }
        if (TypeUtils.PRIMITIVE_INT_TYPE.equals(type) || TypeUtils.INT_TYPE.equals(type)) {
            return TypeUtils.PRIMITIVE_INT_TYPE;
        }
        if (TypeUtils.PRIMITIVE_LONG_TYPE.equals(type) || TypeUtils.LONG_TYPE.equals(type)) {
            return TypeUtils.PRIMITIVE_LONG_TYPE;
        }
        if (TypeUtils.PRIMITIVE_FLOAT_TYPE.equals(type) || TypeUtils.FLOAT_TYPE.equals(type)) {
            return TypeUtils.PRIMITIVE_FLOAT_TYPE;
        }
        if (TypeUtils.PRIMITIVE_DOUBLE_TYPE.equals(type) || TypeUtils.DOUBLE_TYPE.equals(type)) {
            return TypeUtils.PRIMITIVE_DOUBLE_TYPE;
        }
        if (TypeUtils.BIG_DECIMAL_TYPE.equals(type)) {
            return TypeUtils.BIG_DECIMAL_TYPE;
        }
        if (TypeUtils.DATE_TYPE.equals(type)) {
            return TypeUtils.INT_TYPE;
        }
        if (TypeUtils.TIMESTAMP_TYPE.equals(type)) {
            return TypeUtils.LONG_TYPE;
        }
        if (TypeUtils.STRING_TYPE.equals(type)) {
            return TypeUtils.STRING_TYPE;
        }
        if (type.isArray() || TypeUtils.ITERABLE_TYPE.isSupertypeOf(type)) {
            return TypeRef.of(BinaryArray.class);
        }
        if (TypeUtils.MAP_TYPE.isSupertypeOf(type)) {
            return TypeRef.of(BinaryMap.class);
        }
        if (TypeUtils.isBean(type)) {
            return TypeRef.of(BinaryRow.class);
        }
        return TypeRef.of(MemoryBuffer.class);
    }
}

