/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.format.row.binary;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.DecimalUtility;
import org.apache.fury.format.row.Getters;
import org.apache.fury.format.row.Setters;
import org.apache.fury.format.row.binary.BinaryArray;
import org.apache.fury.format.row.binary.BinaryMap;
import org.apache.fury.format.row.binary.BinaryRow;
import org.apache.fury.format.type.DataTypes;
import org.apache.fury.format.vectorized.ArrowUtils;
import org.apache.fury.memory.MemoryBuffer;

abstract class UnsafeTrait
implements Getters,
Setters {
    private Object[] extData;

    UnsafeTrait() {
    }

    abstract MemoryBuffer getBuffer();

    @Override
    public MemoryBuffer getBuffer(int ordinal) {
        if (this.isNullAt(ordinal)) {
            return null;
        }
        long offsetAndSize = this.getInt64(ordinal);
        int relativeOffset = (int)(offsetAndSize >> 32);
        int size = (int)offsetAndSize;
        return this.getBuffer().slice(this.getBaseOffset() + relativeOffset, size);
    }

    abstract int getBaseOffset();

    abstract void assertIndexIsValid(int var1);

    abstract int getOffset(int var1);

    void initializeExtData(int numSlots) {
        this.extData = new Object[numSlots];
    }

    @Override
    public boolean getBoolean(int ordinal) {
        this.assertIndexIsValid(ordinal);
        return this.getBuffer().getBoolean(this.getOffset(ordinal));
    }

    @Override
    public byte getByte(int ordinal) {
        this.assertIndexIsValid(ordinal);
        return this.getBuffer().getByte(this.getOffset(ordinal));
    }

    @Override
    public short getInt16(int ordinal) {
        this.assertIndexIsValid(ordinal);
        return this.getBuffer().getInt16(this.getOffset(ordinal));
    }

    @Override
    public int getInt32(int ordinal) {
        this.assertIndexIsValid(ordinal);
        return this.getBuffer().getInt32(this.getOffset(ordinal));
    }

    @Override
    public long getInt64(int ordinal) {
        this.assertIndexIsValid(ordinal);
        return this.getBuffer().getInt64(this.getOffset(ordinal));
    }

    @Override
    public float getFloat32(int ordinal) {
        this.assertIndexIsValid(ordinal);
        return this.getBuffer().getFloat32(this.getOffset(ordinal));
    }

    @Override
    public double getFloat64(int ordinal) {
        this.assertIndexIsValid(ordinal);
        return this.getBuffer().getFloat64(this.getOffset(ordinal));
    }

    @Override
    public int getDate(int ordinal) {
        this.assertIndexIsValid(ordinal);
        return this.getBuffer().getInt32(this.getOffset(ordinal));
    }

    @Override
    public long getTimestamp(int ordinal) {
        this.assertIndexIsValid(ordinal);
        return this.getBuffer().getInt64(this.getOffset(ordinal));
    }

    @Override
    public String getString(int ordinal) {
        byte[] bytes = this.getBinary(ordinal);
        if (bytes != null) {
            return new String(bytes, StandardCharsets.UTF_8);
        }
        return null;
    }

    @Override
    public byte[] getBinary(int ordinal) {
        if (this.isNullAt(ordinal)) {
            return null;
        }
        long offsetAndSize = this.getInt64(ordinal);
        int relativeOffset = (int)(offsetAndSize >> 32);
        int size = (int)offsetAndSize;
        byte[] bytes = new byte[size];
        this.getBuffer().get(this.getBaseOffset() + relativeOffset, bytes, 0, size);
        return bytes;
    }

    BigDecimal getDecimal(int ordinal, ArrowType.Decimal decimalType) {
        if (this.isNullAt(ordinal)) {
            return null;
        }
        MemoryBuffer buffer = this.getBuffer(ordinal);
        ArrowBuf arrowBuf = ArrowUtils.decimalArrowBuf();
        buffer.copyToUnsafe(0L, null, arrowBuf.memoryAddress(), 32);
        BigDecimal decimal = DecimalUtility.getBigDecimalFromArrowBuf((ArrowBuf)arrowBuf, (int)0, (int)decimalType.getScale(), (int)32);
        return decimal;
    }

    BinaryRow getStruct(int ordinal, Field field, int extDataSlot) {
        if (this.isNullAt(ordinal)) {
            return null;
        }
        long offsetAndSize = this.getInt64(ordinal);
        int relativeOffset = (int)(offsetAndSize >> 32);
        int size = (int)offsetAndSize;
        if (this.extData[extDataSlot] == null) {
            this.extData[extDataSlot] = DataTypes.createSchema(field);
        }
        BinaryRow row = new BinaryRow((Schema)this.extData[extDataSlot]);
        row.pointTo(this.getBuffer(), this.getBaseOffset() + relativeOffset, size);
        return row;
    }

    BinaryArray getArray(int ordinal, Field field) {
        if (this.isNullAt(ordinal)) {
            return null;
        }
        long offsetAndSize = this.getInt64(ordinal);
        int relativeOffset = (int)(offsetAndSize >> 32);
        int size = (int)offsetAndSize;
        BinaryArray array = new BinaryArray(field);
        array.pointTo(this.getBuffer(), this.getBaseOffset() + relativeOffset, size);
        return array;
    }

    BinaryMap getMap(int ordinal, Field field) {
        if (this.isNullAt(ordinal)) {
            return null;
        }
        long offsetAndSize = this.getInt64(ordinal);
        int relativeOffset = (int)(offsetAndSize >> 32);
        int size = (int)offsetAndSize;
        BinaryMap map = new BinaryMap(field);
        map.pointTo(this.getBuffer(), this.getBaseOffset() + relativeOffset, size);
        return map;
    }

    @Override
    public void setBoolean(int ordinal, boolean value) {
        this.assertIndexIsValid(ordinal);
        this.setNotNullAt(ordinal);
        this.getBuffer().putBoolean(this.getOffset(ordinal), value);
    }

    @Override
    public void setByte(int ordinal, byte value) {
        this.assertIndexIsValid(ordinal);
        this.setNotNullAt(ordinal);
        this.getBuffer().putByte(this.getOffset(ordinal), value);
    }

    protected abstract void setNotNullAt(int var1);

    @Override
    public void setInt16(int ordinal, short value) {
        this.assertIndexIsValid(ordinal);
        this.setNotNullAt(ordinal);
        this.getBuffer().putInt16(this.getOffset(ordinal), value);
    }

    @Override
    public void setInt32(int ordinal, int value) {
        this.assertIndexIsValid(ordinal);
        this.setNotNullAt(ordinal);
        this.getBuffer().putInt32(this.getOffset(ordinal), value);
    }

    @Override
    public void setInt64(int ordinal, long value) {
        this.assertIndexIsValid(ordinal);
        this.setNotNullAt(ordinal);
        this.getBuffer().putInt64(this.getOffset(ordinal), value);
    }

    @Override
    public void setFloat32(int ordinal, float value) {
        this.assertIndexIsValid(ordinal);
        this.setNotNullAt(ordinal);
        this.getBuffer().putFloat32(this.getOffset(ordinal), value);
    }

    @Override
    public void setFloat64(int ordinal, double value) {
        this.assertIndexIsValid(ordinal);
        this.setNotNullAt(ordinal);
        this.getBuffer().putFloat64(this.getOffset(ordinal), value);
    }

    @Override
    public void setDate(int ordinal, int value) {
        this.assertIndexIsValid(ordinal);
        this.setNotNullAt(ordinal);
        this.getBuffer().putInt32(this.getOffset(ordinal), value);
    }

    @Override
    public void setTimestamp(int ordinal, long value) {
        this.assertIndexIsValid(ordinal);
        this.setNotNullAt(ordinal);
        this.getBuffer().putInt64(this.getOffset(ordinal), value);
    }
}

