/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.format.vectorized;

import java.nio.ByteBuffer;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.fury.format.row.Getters;
import org.apache.fury.format.vectorized.ArrowArrayWriter;

class StringWriter
extends ArrowArrayWriter {
    private final VarCharVector valueVector;

    StringWriter(VarCharVector valueVector) {
        this.valueVector = valueVector;
    }

    @Override
    void appendValue(Getters getters, int fieldIndex) {
        ByteBuffer buffer = getters.getBuffer(fieldIndex).sliceAsByteBuffer();
        this.valueVector.setSafe(this.rowCount, buffer, buffer.position(), buffer.remaining());
    }

    @Override
    void appendNull() {
        this.valueVector.setNull(this.rowCount);
    }

    @Override
    ValueVector valueVector() {
        return this.valueVector;
    }
}

