/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.format.encoder;

import java.io.Serializable;
import java.util.Map;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.fury.Fury;
import org.apache.fury.codegen.CodeGenerator;
import org.apache.fury.codegen.CodegenContext;
import org.apache.fury.codegen.Expression;
import org.apache.fury.codegen.ExpressionUtils;
import org.apache.fury.format.encoder.BaseBinaryEncoderBuilder;
import org.apache.fury.format.encoder.GeneratedMapEncoder;
import org.apache.fury.format.row.binary.BinaryArray;
import org.apache.fury.format.row.binary.BinaryMap;
import org.apache.fury.format.row.binary.writer.BinaryArrayWriter;
import org.apache.fury.format.type.TypeInference;
import org.apache.fury.logging.Logger;
import org.apache.fury.logging.LoggerFactory;
import org.apache.fury.reflect.TypeRef;
import org.apache.fury.type.TypeUtils;
import org.apache.fury.util.StringUtils;
import org.apache.fury.util.function.SerializableTriFunction;

public class MapEncoderBuilder
extends BaseBinaryEncoderBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(MapEncoderBuilder.class);
    private static final String FIELD_NAME = "field";
    private static final String KEY_FIELD_NAME = "keyField";
    private static final String VALUE_FIELD_NAME = "valueField";
    private static final String ROOT_MAP_NAME = "map";
    private static final String ROOT_KEY_NAME = "key";
    private static final String ROOT_VAL_NAME = "value";
    private static final String ROOT_KEY_WRITER_NAME = "keyArrayWriter";
    private static final String ROOT_VALUE_WRITER_NAME = "valueArrayWriter";
    private static final TypeRef<Field> ARROW_FIELD_TYPE = TypeRef.of(Field.class);
    private final TypeRef<?> mapToken;

    public MapEncoderBuilder(Class<?> mapCls, Class<?> keyClass) {
        this(TypeRef.of(mapCls), TypeRef.of(keyClass));
    }

    public MapEncoderBuilder(TypeRef<?> clsType, TypeRef<?> beanType) {
        super(new CodegenContext(), beanType);
        this.mapToken = clsType;
        this.ctx.reserveName(ROOT_KEY_WRITER_NAME);
        this.ctx.reserveName(ROOT_VALUE_WRITER_NAME);
        this.ctx.reserveName(ROOT_MAP_NAME);
        Expression.Literal clsExpr = new Expression.Literal((Object)TypeUtils.getRawType(this.mapToken), TypeUtils.CLASS_TYPE);
        this.ctx.addField(true, Class.class.getName(), "mapClass", (Expression)clsExpr);
    }

    public String genCode() {
        this.ctx.setPackage(CodeGenerator.getPackage((Class)this.beanClass));
        String className = this.codecClassName(this.beanClass, TypeInference.inferTypeName(this.mapToken));
        this.ctx.setClassName(className);
        this.ctx.implementsInterfaces(new String[]{this.ctx.type(GeneratedMapEncoder.class)});
        String constructorCode = StringUtils.format((String)"${keyField} = (${fieldType})${references}[0];\n${keyArrayWriter} = (${arrayWriterType})${references}[2];\n${valueField} = (${fieldType})${references}[1];\n${valueArrayWriter} = (${arrayWriterType})${references}[3];\n${fury} = (${furyType})${references}[4];\n${field} = (${fieldType})${references}[5];\n", (Object[])new Object[]{"references", "references", KEY_FIELD_NAME, KEY_FIELD_NAME, "fieldType", this.ctx.type(Field.class), ROOT_KEY_WRITER_NAME, ROOT_KEY_WRITER_NAME, "arrayWriterType", this.ctx.type(BinaryArrayWriter.class), VALUE_FIELD_NAME, VALUE_FIELD_NAME, "fieldType", this.ctx.type(Field.class), ROOT_VALUE_WRITER_NAME, ROOT_VALUE_WRITER_NAME, "arrayWriterType", this.ctx.type(BinaryArrayWriter.class), "fury", "fury", "furyType", this.ctx.type(Fury.class), FIELD_NAME, FIELD_NAME, "fieldType", this.ctx.type(Field.class)});
        this.ctx.addField(this.ctx.type(Field.class), KEY_FIELD_NAME);
        this.ctx.addField(this.ctx.type(Field.class), VALUE_FIELD_NAME);
        this.ctx.addField(this.ctx.type(BinaryArrayWriter.class), ROOT_KEY_WRITER_NAME);
        this.ctx.addField(this.ctx.type(BinaryArrayWriter.class), ROOT_VALUE_WRITER_NAME);
        this.ctx.addField(this.ctx.type(Fury.class), "fury");
        this.ctx.addField(this.ctx.type(Field.class), FIELD_NAME);
        Expression encodeExpr = this.buildEncodeExpression();
        String encodeCode = encodeExpr.genCode(this.ctx).code();
        this.ctx.overrideMethod("toMap", encodeCode, BinaryMap.class, new Object[]{Object.class, "obj"});
        Expression decodeExpr = this.buildDecodeExpression();
        String decodeCode = decodeExpr.genCode(this.ctx).code();
        this.ctx.overrideMethod("fromMap", decodeCode, Object.class, new Object[]{BinaryArray.class, ROOT_KEY_NAME, BinaryArray.class, ROOT_VAL_NAME});
        this.ctx.addConstructor(constructorCode, new Object[]{Object[].class, "references"});
        long startTime = System.nanoTime();
        String code = this.ctx.genCode();
        long durationMs = (System.nanoTime() - startTime) / 1000000L;
        LOG.info("Generate map codec for class {} take {} us", (Object)this.beanClass, (Object)durationMs);
        return code;
    }

    public Expression buildEncodeExpression() {
        Expression.ListExpression expressions = new Expression.ListExpression(new Expression[0]);
        Expression.Reference inputObject = new Expression.Reference("obj", TypeUtils.MAP_TYPE, false);
        Expression.Cast map = new Expression.Cast((Expression)inputObject, this.mapToken, this.ctx.newName(TypeUtils.getRawType(this.mapToken)), false, false);
        Expression.Reference keyArrayWriter = new Expression.Reference(ROOT_KEY_WRITER_NAME, arrayWriterTypeToken, false);
        Expression.Reference valArrayWriter = new Expression.Reference(ROOT_VALUE_WRITER_NAME, arrayWriterTypeToken, false);
        Expression.Reference fieldExpr = new Expression.Reference(FIELD_NAME, ARROW_FIELD_TYPE, false);
        Expression.Reference keyFieldExpr = new Expression.Reference(KEY_FIELD_NAME, ARROW_FIELD_TYPE, false);
        Expression.Reference valFieldExpr = new Expression.Reference(VALUE_FIELD_NAME, ARROW_FIELD_TYPE, false);
        Expression listExpression = this.directlySerializeMap((Expression)map, (Expression)keyArrayWriter, (Expression)valArrayWriter, (Expression)keyFieldExpr, (Expression)valFieldExpr);
        Expression.Invoke keyArray = new Expression.Invoke((Expression)keyArrayWriter, "toArray", TypeRef.of(BinaryArray.class));
        Expression.Invoke valArray = new Expression.Invoke((Expression)valArrayWriter, "toArray", TypeRef.of(BinaryArray.class));
        expressions.add((Expression)map);
        expressions.add(listExpression);
        expressions.add((Expression)keyArray);
        expressions.add((Expression)valArray);
        expressions.add((Expression)new Expression.Return((Expression)new Expression.NewInstance(TypeRef.of(BinaryMap.class), new Expression[]{keyArray, valArray, fieldExpr})));
        return expressions;
    }

    public Expression buildDecodeExpression() {
        Expression.ListExpression expressions = new Expression.ListExpression(new Expression[0]);
        Expression map = this.newMap(this.mapToken);
        Expression.Reference keyArrayRef = new Expression.Reference(ROOT_KEY_NAME, binaryArrayTypeToken, false);
        Expression.Reference valArrayRef = new Expression.Reference(ROOT_VAL_NAME, binaryArrayTypeToken, false);
        Expression listExpression = this.directlyDeserializeMap(map, (Expression)keyArrayRef, (Expression)valArrayRef);
        expressions.add(listExpression);
        expressions.add((Expression)new Expression.Return(map));
        return expressions;
    }

    private Expression directlySerializeMap(Expression map, Expression keyArrayWriter, Expression valArrayWriter, Expression keyFieldExpr, Expression valFieldExpr) {
        TypeRef supertype = this.mapToken.getSupertype(Map.class);
        TypeRef keySetType = supertype.resolveType(TypeUtils.KEY_SET_RETURN_TYPE);
        TypeRef valuesType = supertype.resolveType(TypeUtils.VALUES_RETURN_TYPE);
        Expression.Invoke keySet = new Expression.Invoke(map, "keySet", keySetType);
        Expression keySerializationExpr = this.serializeForArray((Expression)keySet, keyArrayWriter, keySetType, keyFieldExpr, true);
        Expression.Invoke values = new Expression.Invoke(map, "values", valuesType);
        Expression valueSerializationExpr = this.serializeForArray((Expression)values, valArrayWriter, valuesType, valFieldExpr, true);
        return new Expression.ListExpression(new Expression[]{keySerializationExpr, valueSerializationExpr});
    }

    private Expression directlyDeserializeMap(Expression map, Expression keyArrayRef, Expression valArrayRef) {
        TypeRef supertype = this.mapToken.getSupertype(Map.class);
        TypeRef keySetType = supertype.resolveType(TypeUtils.KEY_SET_RETURN_TYPE);
        TypeRef keysType = TypeUtils.getCollectionType((TypeRef)keySetType);
        TypeRef valuesType = supertype.resolveType(TypeUtils.VALUES_RETURN_TYPE);
        Expression keyJavaArray = TypeUtils.ITERABLE_TYPE.isSupertypeOf(keysType) ? this.deserializeForCollection(keyArrayRef, keysType) : this.deserializeForArray(keyArrayRef, keysType);
        Expression valueJavaArray = TypeUtils.ITERABLE_TYPE.isSupertypeOf(valuesType) ? this.deserializeForCollection(valArrayRef, valuesType) : this.deserializeForArray(valArrayRef, valuesType);
        Expression.ZipForEach put = new Expression.ZipForEach(keyJavaArray, valueJavaArray, (SerializableTriFunction & Serializable)(i, key, value) -> new Expression.If(ExpressionUtils.notNull((Expression)key), (Expression)new Expression.Invoke(map, "put", new Expression[]{key, value})));
        return new Expression.ListExpression(new Expression[]{map, put});
    }
}

