/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.format.encoder;

import java.lang.reflect.Modifier;
import java.util.SortedMap;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.fury.Fury;
import org.apache.fury.codegen.CodeGenerator;
import org.apache.fury.codegen.CodegenContext;
import org.apache.fury.codegen.Expression;
import org.apache.fury.codegen.ExpressionUtils;
import org.apache.fury.format.encoder.BaseBinaryEncoderBuilder;
import org.apache.fury.format.encoder.GeneratedRowEncoder;
import org.apache.fury.format.row.ArrayData;
import org.apache.fury.format.row.MapData;
import org.apache.fury.format.row.Row;
import org.apache.fury.format.row.binary.BinaryArray;
import org.apache.fury.format.row.binary.BinaryMap;
import org.apache.fury.format.row.binary.BinaryRow;
import org.apache.fury.format.row.binary.BinaryUtils;
import org.apache.fury.format.row.binary.writer.BinaryRowWriter;
import org.apache.fury.format.type.DataTypes;
import org.apache.fury.format.type.TypeInference;
import org.apache.fury.logging.Logger;
import org.apache.fury.logging.LoggerFactory;
import org.apache.fury.reflect.TypeRef;
import org.apache.fury.type.Descriptor;
import org.apache.fury.type.TypeUtils;
import org.apache.fury.util.GraalvmSupport;
import org.apache.fury.util.Preconditions;
import org.apache.fury.util.StringUtils;

public class RowEncoderBuilder
extends BaseBinaryEncoderBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(RowEncoderBuilder.class);
    static final String SCHEMA_NAME = "schema";
    static final String ROOT_ROW_NAME = "row";
    static final String ROOT_ROW_WRITER_NAME = "rowWriter";
    private final SortedMap<String, Descriptor> descriptorsMap;
    private final Schema schema;
    protected static final String BEAN_CLASS_NAME = "beanClass";
    protected Expression.Reference beanClassRef = new Expression.Reference("beanClass", TypeUtils.CLASS_TYPE);

    public RowEncoderBuilder(Class<?> beanClass) {
        this(TypeRef.of(beanClass));
    }

    public RowEncoderBuilder(TypeRef<?> beanType) {
        super(new CodegenContext(), beanType);
        Preconditions.checkArgument((boolean)TypeUtils.isBean(beanType));
        this.schema = TypeInference.inferSchema(TypeUtils.getRawType(beanType));
        this.descriptorsMap = Descriptor.getDescriptorsMap((Class)this.beanClass);
        this.ctx.reserveName(ROOT_ROW_WRITER_NAME);
        this.ctx.reserveName(SCHEMA_NAME);
        this.ctx.reserveName(ROOT_ROW_NAME);
        this.ctx.reserveName(BEAN_CLASS_NAME);
        Object clsExpr = Modifier.isPublic(this.beanClass.getModifiers()) ? Expression.Literal.ofClass((Class)this.beanClass) : new Expression.StaticInvoke(Class.class, "forName", TypeUtils.CLASS_TYPE, false, new Expression[]{Expression.Literal.ofClass((Class)this.beanClass)});
        this.ctx.addField(Class.class, BEAN_CLASS_NAME, (Expression)clsExpr);
        this.ctx.addImports(new Class[]{Field.class, Schema.class});
        this.ctx.addImports(new Class[]{Row.class, ArrayData.class, MapData.class});
        this.ctx.addImports(new Class[]{BinaryRow.class, BinaryArray.class, BinaryMap.class});
    }

    @Override
    protected String codecSuffix() {
        return "RowCodec";
    }

    public String genCode() {
        this.ctx.setPackage(CodeGenerator.getPackage((Class)this.beanClass));
        String className = this.codecClassName(this.beanClass);
        this.ctx.setClassName(className);
        this.ctx.implementsInterfaces(new String[]{this.ctx.type(GeneratedRowEncoder.class)});
        String constructorCode = StringUtils.format((String)"${schema} = (${schemaType})${references}[0];\n${rowWriter} = (${rowWriterType})${references}[1];\n${fury} = (${furyType})${references}[2];\n", (Object[])new Object[]{"references", "references", SCHEMA_NAME, SCHEMA_NAME, "schemaType", this.ctx.type(Schema.class), ROOT_ROW_WRITER_NAME, ROOT_ROW_WRITER_NAME, "rowWriterType", this.ctx.type(BinaryRowWriter.class), "fury", "fury", "furyType", this.ctx.type(Fury.class)});
        this.ctx.addField(this.ctx.type(Schema.class), SCHEMA_NAME);
        this.ctx.addField(this.ctx.type(BinaryRowWriter.class), ROOT_ROW_WRITER_NAME);
        this.ctx.addField(this.ctx.type(Fury.class), "fury");
        Expression encodeExpr = this.buildEncodeExpression();
        Expression decodeExpr = this.buildDecodeExpression();
        String encodeCode = encodeExpr.genCode(this.ctx).code();
        String decodeCode = decodeExpr.genCode(this.ctx).code();
        this.ctx.overrideMethod("toRow", encodeCode, BinaryRow.class, new Object[]{Object.class, "obj"});
        this.ctx.overrideMethod("fromRow", decodeCode, Object.class, new Object[]{BinaryRow.class, ROOT_ROW_NAME});
        this.ctx.addConstructor(constructorCode, new Object[]{Object[].class, "references"});
        long startTime = System.nanoTime();
        String code = this.ctx.genCode();
        long durationMs = (System.nanoTime() - startTime) / 1000L;
        LOG.info("Generate codec for class {} take {} us", (Object)this.beanClass, (Object)durationMs);
        return code;
    }

    public Expression buildEncodeExpression() {
        Expression.Reference inputObject = new Expression.Reference("obj", TypeUtils.OBJECT_TYPE, false);
        Expression.Reference writer = new Expression.Reference(ROOT_ROW_WRITER_NAME, rowWriterTypeToken, false);
        Expression.Reference schemaExpr = new Expression.Reference(SCHEMA_NAME, schemaTypeToken, false);
        int numFields = this.schema.getFields().size();
        Expression.ListExpression expressions = new Expression.ListExpression(new Expression[0]);
        Expression.Cast bean = new Expression.Cast((Expression)inputObject, this.beanType, this.ctx.newName(this.beanClass));
        for (int i = 0; i < numFields; ++i) {
            Descriptor d = this.getDescriptorByFieldName(((Field)this.schema.getFields().get(i)).getName());
            Preconditions.checkNotNull((Object)d);
            TypeRef fieldType = d.getTypeRef();
            Expression fieldValue = this.getFieldValue((Expression)bean, d);
            Expression.Literal ordinal = Expression.Literal.ofInt((int)i);
            Expression.StaticInvoke field = new Expression.StaticInvoke(DataTypes.class, "fieldOfSchema", ARROW_FIELD_TYPE, false, new Expression[]{schemaExpr, ordinal});
            Expression fieldExpr = this.serializeFor((Expression)ordinal, fieldValue, (Expression)writer, fieldType, (Expression)field);
            expressions.add(fieldExpr);
        }
        expressions.add((Expression)new Expression.Return((Expression)new Expression.Invoke((Expression)writer, "getRow", TypeRef.of(BinaryRow.class))));
        return expressions;
    }

    public Expression buildDecodeExpression() {
        Expression.Reference row = new Expression.Reference(ROOT_ROW_NAME, binaryRowTypeToken, false);
        Expression bean = this.newBean();
        int numFields = this.schema.getFields().size();
        Expression.ListExpression expressions = new Expression.ListExpression(new Expression[0]);
        expressions.add(bean);
        for (int i = 0; i < numFields; ++i) {
            Expression.Literal ordinal = Expression.Literal.ofInt((int)i);
            Descriptor d = this.getDescriptorByFieldName(((Field)this.schema.getFields().get(i)).getName());
            TypeRef fieldType = d.getTypeRef();
            Expression.Invoke isNullAt = new Expression.Invoke((Expression)row, "isNullAt", TypeUtils.PRIMITIVE_BOOLEAN_TYPE, new Expression[]{ordinal});
            String columnAccessMethodName = BinaryUtils.getElemAccessMethodName(fieldType);
            TypeRef<?> colType = BinaryUtils.getElemReturnType(fieldType);
            Expression.Invoke columnValue = new Expression.Invoke((Expression)row, columnAccessMethodName, this.ctx.newName(TypeUtils.getRawType(colType)), colType, false, new Expression[]{ordinal});
            Expression value = this.deserializeFor((Expression)columnValue, fieldType);
            Expression setActionExpr = this.setFieldValue(bean, d, value);
            Expression.If action = new Expression.If((Expression)ExpressionUtils.not((Expression)isNullAt), setActionExpr);
            expressions.add((Expression)action);
        }
        expressions.add((Expression)new Expression.Return(bean));
        return expressions;
    }

    private Descriptor getDescriptorByFieldName(String fieldName) {
        String name = StringUtils.lowerUnderscoreToLowerCamelCase((String)fieldName);
        return (Descriptor)this.descriptorsMap.get(name);
    }

    protected Expression beanClassExpr() {
        if (GraalvmSupport.isGraalBuildtime()) {
            return this.staticBeanClassExpr();
        }
        return this.beanClassRef;
    }
}

