/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.format.row.binary.writer;

import java.math.BigDecimal;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.fury.format.row.binary.BinaryRow;
import org.apache.fury.format.row.binary.writer.BinaryWriter;
import org.apache.fury.memory.BitUtils;
import org.apache.fury.memory.MemoryBuffer;
import org.apache.fury.memory.MemoryUtils;

public class BinaryRowWriter
extends BinaryWriter {
    private final Schema schema;
    private final int headerInBytes;
    private final int fixedSize;

    public BinaryRowWriter(Schema schema) {
        super(MemoryUtils.buffer((int)(schema.getFields().size() * 32)), 0);
        this.startIndex = 0;
        this.schema = schema;
        this.headerInBytes = BitUtils.calculateBitmapWidthInBytes((int)schema.getFields().size());
        this.fixedSize = this.headerInBytes + schema.getFields().size() * 8;
    }

    public BinaryRowWriter(Schema schema, BinaryWriter writer) {
        super(writer.getBuffer(), 0);
        writer.children.add(this);
        this.schema = schema;
        this.headerInBytes = BitUtils.calculateBitmapWidthInBytes((int)schema.getFields().size());
        this.fixedSize = this.headerInBytes + schema.getFields().size() * 8;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void reset() {
        this.startIndex = this.buffer.writerIndex();
        this.grow(this.fixedSize);
        this.buffer._increaseWriterIndexUnsafe(this.fixedSize);
        int end = this.startIndex + this.headerInBytes;
        for (int i = this.startIndex; i < end; i += 8) {
            this.buffer.putInt64(i, 0L);
        }
    }

    @Override
    public int getOffset(int ordinal) {
        return this.startIndex + this.headerInBytes + (ordinal << 3);
    }

    @Override
    public void write(int ordinal, byte value) {
        int offset = this.getOffset(ordinal);
        this.buffer.putInt64(offset, 0L);
        this.buffer.putByte(offset, value);
    }

    @Override
    public void write(int ordinal, boolean value) {
        int offset = this.getOffset(ordinal);
        this.buffer.putInt64(offset, 0L);
        this.buffer.putBoolean(offset, value);
    }

    @Override
    public void write(int ordinal, short value) {
        int offset = this.getOffset(ordinal);
        this.buffer.putInt64(offset, 0L);
        this.buffer.putInt16(offset, value);
    }

    @Override
    public void write(int ordinal, int value) {
        int offset = this.getOffset(ordinal);
        this.buffer.putInt64(offset, 0L);
        this.buffer.putInt32(offset, value);
    }

    @Override
    public void write(int ordinal, float value) {
        int offset = this.getOffset(ordinal);
        this.buffer.putInt64(offset, 0L);
        this.buffer.putFloat32(offset, value);
    }

    @Override
    public void write(int ordinal, BigDecimal value) {
        this.writeDecimal(ordinal, value, (ArrowType.Decimal)((Field)this.schema.getFields().get(ordinal)).getType());
    }

    public BinaryRow getRow() {
        BinaryRow row = new BinaryRow(this.schema);
        int size = this.size();
        row.pointTo(this.buffer, this.startIndex, size);
        return row;
    }

    public BinaryRow copyToRow() {
        BinaryRow row = new BinaryRow(this.schema);
        int size = this.size();
        MemoryBuffer buffer = MemoryUtils.buffer((int)size);
        this.buffer.copyTo(this.startIndex, buffer, 0, size);
        row.pointTo(buffer, 0, size);
        return row;
    }
}

