/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.format.vectorized;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ArrowStreamReader;
import org.apache.arrow.vector.ipc.ArrowStreamWriter;
import org.apache.arrow.vector.ipc.WriteChannel;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.ipc.message.IpcOption;
import org.apache.arrow.vector.ipc.message.MessageSerializer;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.fury.Fury;
import org.apache.fury.format.vectorized.ArrowTable;
import org.apache.fury.format.vectorized.ArrowTableSerializer;
import org.apache.fury.format.vectorized.ArrowUtils;
import org.apache.fury.io.MemoryBufferReadableChannel;
import org.apache.fury.io.MemoryBufferWritableChannel;
import org.apache.fury.io.MockWritableChannel;
import org.apache.fury.memory.MemoryBuffer;
import org.apache.fury.memory.MemoryUtils;
import org.apache.fury.memory.Platform;
import org.apache.fury.serializer.BufferObject;
import org.apache.fury.serializer.Serializer;
import org.apache.fury.serializer.Serializers;
import org.apache.fury.type.Type;

public class ArrowSerializers {
    public static void registerSerializers(Fury fury) {
        fury.registerSerializer(ArrowTable.class, (Serializer)new ArrowTableSerializer(fury));
        fury.registerSerializer(VectorSchemaRoot.class, (Serializer)new VectorSchemaRootSerializer(fury));
    }

    public static class ArrowTableBufferObject
    implements BufferObject {
        private final ArrowTable table;
        private final int totalBytes;

        public ArrowTableBufferObject(ArrowTable table) {
            this.table = table;
            MockWritableChannel mockWritableChannel = new MockWritableChannel();
            ArrowTableBufferObject.write(table, (WritableByteChannel)mockWritableChannel);
            this.totalBytes = mockWritableChannel.totalBytes();
        }

        public int totalBytes() {
            return this.totalBytes;
        }

        public void writeTo(MemoryBuffer buffer) {
            ArrowTableBufferObject.write(this.table, (WritableByteChannel)new MemoryBufferWritableChannel(buffer));
        }

        private static void write(ArrowTable table, WritableByteChannel byteChannel) {
            try (WriteChannel channel = new WriteChannel(byteChannel);){
                MessageSerializer.serialize((WriteChannel)channel, (Schema)table.getSchema());
                for (ArrowRecordBatch recordBatch : table.getRecordBatches()) {
                    MessageSerializer.serialize((WriteChannel)channel, (ArrowRecordBatch)recordBatch);
                }
                ArrowStreamWriter.writeEndOfStream((WriteChannel)channel, (IpcOption)new IpcOption());
            }
            catch (IOException e) {
                Platform.throwException((Throwable)e);
            }
        }

        public MemoryBuffer toBuffer() {
            MemoryBuffer buffer = MemoryUtils.buffer((int)this.totalBytes);
            ArrowTableBufferObject.write(this.table, (WritableByteChannel)new MemoryBufferWritableChannel(buffer));
            return buffer.slice(0, buffer.writerIndex());
        }
    }

    private static class VectorSchemaRootBufferObject
    implements BufferObject {
        private final int totalBytes;
        private final VectorSchemaRoot root;

        VectorSchemaRootBufferObject(VectorSchemaRoot root) {
            this.root = root;
            MockWritableChannel mockWritableChannel = new MockWritableChannel();
            VectorSchemaRootBufferObject.write(root, (WritableByteChannel)mockWritableChannel);
            this.totalBytes = mockWritableChannel.totalBytes();
        }

        public int totalBytes() {
            return this.totalBytes;
        }

        public void writeTo(MemoryBuffer buffer) {
            VectorSchemaRootBufferObject.write(this.root, (WritableByteChannel)new MemoryBufferWritableChannel(buffer));
        }

        private static void write(VectorSchemaRoot root, WritableByteChannel byteChannel) {
            try (ArrowStreamWriter writer = new ArrowStreamWriter(root, null, byteChannel);){
                writer.writeBatch();
            }
            catch (IOException e) {
                Platform.throwException((Throwable)e);
            }
        }

        public MemoryBuffer toBuffer() {
            MemoryBuffer buffer = MemoryUtils.buffer((int)this.totalBytes);
            VectorSchemaRootBufferObject.write(this.root, (WritableByteChannel)new MemoryBufferWritableChannel(buffer));
            return buffer.slice(0, buffer.writerIndex());
        }
    }

    public static class VectorSchemaRootSerializer
    extends Serializers.CrossLanguageCompatibleSerializer<VectorSchemaRoot> {
        private static final BufferAllocator defaultAllocator = ArrowUtils.allocator.newChildAllocator("arrow-vector-schema-root-reader", 64L, Long.MAX_VALUE);
        private final BufferAllocator allocator;

        public VectorSchemaRootSerializer(Fury fury) {
            this(fury, defaultAllocator);
        }

        public VectorSchemaRootSerializer(Fury fury, BufferAllocator allocator) {
            super(fury, VectorSchemaRoot.class, Type.FURY_ARROW_RECORD_BATCH.getId());
            this.allocator = allocator;
        }

        public void write(MemoryBuffer buffer, VectorSchemaRoot root) {
            this.fury.writeBufferObject(buffer, (BufferObject)new VectorSchemaRootBufferObject(root));
        }

        public VectorSchemaRoot read(MemoryBuffer buffer) {
            MemoryBuffer buf = this.fury.readBufferObject(buffer);
            try {
                MemoryBufferReadableChannel channel = new MemoryBufferReadableChannel(buf);
                ArrowStreamReader reader = new ArrowStreamReader((ReadableByteChannel)channel, this.allocator);
                VectorSchemaRoot root = reader.getVectorSchemaRoot();
                reader.loadNextBatch();
                return root;
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to read a record batch message", e);
            }
        }
    }
}

