/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.format.vectorized;

import java.util.Iterator;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.VectorLoader;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.fury.format.vectorized.ArrowUtils;
import org.apache.fury.util.Preconditions;

public class ArrowTable {
    private static final BufferAllocator tableBufferAllocator = ArrowUtils.allocator.newChildAllocator("table_buffer_allocator", 64L, Long.MAX_VALUE);
    private final Schema schema;
    private final BufferAllocator allocator;
    private Iterable<ArrowRecordBatch> recordBatches;
    private Iterator<ArrowRecordBatch> batchIterator;
    private VectorSchemaRoot root;

    public ArrowTable(Schema schema, Iterable<ArrowRecordBatch> recordBatches) {
        this(schema, recordBatches, tableBufferAllocator);
    }

    public ArrowTable(Schema schema, Iterable<ArrowRecordBatch> recordBatches, BufferAllocator allocator) {
        this.schema = schema;
        this.recordBatches = recordBatches;
        this.allocator = allocator;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public Iterable<ArrowRecordBatch> getRecordBatches() {
        return this.recordBatches;
    }

    public VectorSchemaRoot toVectorSchemaRoot() {
        return this.toVectorSchemaRoot(false);
    }

    public VectorSchemaRoot toVectorSchemaRoot(boolean reload) {
        if (!reload) {
            Preconditions.checkArgument((this.batchIterator == null ? 1 : 0) != 0);
        }
        this.batchIterator = this.recordBatches.iterator();
        this.root = VectorSchemaRoot.create((Schema)this.schema, (BufferAllocator)this.allocator);
        return this.root;
    }

    public boolean loadNextBatch() {
        VectorLoader loader = new VectorLoader(this.root);
        if (this.batchIterator.hasNext()) {
            loader.load(this.batchIterator.next());
            return true;
        }
        return false;
    }
}

