/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.format.vectorized;

import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.vector.ipc.ArrowStreamReader;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.fury.Fury;
import org.apache.fury.format.vectorized.ArrowSerializers;
import org.apache.fury.format.vectorized.ArrowTable;
import org.apache.fury.format.vectorized.ArrowUtils;
import org.apache.fury.io.MemoryBufferReadableChannel;
import org.apache.fury.memory.MemoryBuffer;
import org.apache.fury.memory.Platform;
import org.apache.fury.serializer.BufferObject;
import org.apache.fury.serializer.Serializers;
import org.apache.fury.type.Type;

public class ArrowTableSerializer
extends Serializers.CrossLanguageCompatibleSerializer<ArrowTable> {
    private static final BufferAllocator defaultAllocator = ArrowUtils.allocator.newChildAllocator("arrow-table-reader", 64L, Long.MAX_VALUE);
    private final BufferAllocator allocator;

    public ArrowTableSerializer(Fury fury) {
        this(fury, defaultAllocator);
    }

    public ArrowTableSerializer(Fury fury, BufferAllocator allocator) {
        super(fury, ArrowTable.class, Type.FURY_ARROW_TABLE.getId());
        this.allocator = allocator;
    }

    public void write(MemoryBuffer buffer, ArrowTable value) {
        this.fury.writeBufferObject(buffer, (BufferObject)new ArrowSerializers.ArrowTableBufferObject(value));
    }

    public ArrowTable read(MemoryBuffer buffer) {
        MemoryBuffer buf = this.fury.readBufferObject(buffer);
        ArrayList<ArrowRecordBatch> recordBatches = new ArrayList<ArrowRecordBatch>();
        try {
            MemoryBufferReadableChannel channel = new MemoryBufferReadableChannel(buf);
            ArrowStreamReader reader = new ArrowStreamReader((ReadableByteChannel)channel, this.allocator);
            VectorSchemaRoot root = reader.getVectorSchemaRoot();
            while (reader.loadNextBatch()) {
                recordBatches.add(new VectorUnloader(root).getRecordBatch());
            }
            return new ArrowTable(root.getSchema(), recordBatches, this.allocator);
        }
        catch (Exception e) {
            Platform.throwException((Throwable)e);
            throw new RuntimeException("unreachable");
        }
    }
}

