/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.format.encoder;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.fury.builder.CodecBuilder;
import org.apache.fury.codegen.CodeGenerator;
import org.apache.fury.codegen.CodegenContext;
import org.apache.fury.codegen.Expression;
import org.apache.fury.codegen.ExpressionUtils;
import org.apache.fury.format.encoder.ArrayDataForEach;
import org.apache.fury.format.encoder.GeneratedRowEncoder;
import org.apache.fury.format.row.Row;
import org.apache.fury.format.row.binary.BinaryArray;
import org.apache.fury.format.row.binary.BinaryRow;
import org.apache.fury.format.row.binary.writer.BinaryArrayWriter;
import org.apache.fury.format.row.binary.writer.BinaryRowWriter;
import org.apache.fury.format.row.binary.writer.BinaryWriter;
import org.apache.fury.format.type.DataTypes;
import org.apache.fury.memory.MemoryBuffer;
import org.apache.fury.reflect.ReflectionUtils;
import org.apache.fury.reflect.TypeRef;
import org.apache.fury.type.TypeUtils;
import org.apache.fury.util.DateTimeUtils;
import org.apache.fury.util.Preconditions;
import org.apache.fury.util.StringUtils;
import org.apache.fury.util.function.SerializableBiFunction;
import org.apache.fury.util.function.SerializableFunction;
import org.apache.fury.util.function.SerializableTriFunction;

public abstract class BaseBinaryEncoderBuilder
extends CodecBuilder {
    protected static final String REFERENCES_NAME = "references";
    protected static final TypeRef<Schema> SCHEMA_TYPE = TypeRef.of(Schema.class);
    protected static final TypeRef<Field> ARROW_FIELD_TYPE = TypeRef.of(Field.class);
    protected static TypeRef<Schema> schemaTypeToken = TypeRef.of(Schema.class);
    protected static TypeRef<BinaryWriter> writerTypeToken = TypeRef.of(BinaryWriter.class);
    protected static TypeRef<BinaryRowWriter> rowWriterTypeToken = TypeRef.of(BinaryRowWriter.class);
    protected static TypeRef<BinaryArrayWriter> arrayWriterTypeToken = TypeRef.of(BinaryArrayWriter.class);
    protected static TypeRef<Row> rowTypeToken = TypeRef.of(Row.class);
    protected static TypeRef<BinaryRow> binaryRowTypeToken = TypeRef.of(BinaryRow.class);
    protected static TypeRef<BinaryArray> binaryArrayTypeToken = TypeRef.of(BinaryArray.class);
    protected final Map<TypeRef<?>, Expression.Reference> arrayWriterMap = new HashMap();
    protected final Map<TypeRef<?>, Expression.Reference> beanEncoderMap = new HashMap();
    protected final Map<TypeRef<?>, Expression.Reference> rowWriterMap = new HashMap();

    public BaseBinaryEncoderBuilder(CodegenContext context, Class<?> beanClass) {
        this(context, TypeRef.of(beanClass));
    }

    public BaseBinaryEncoderBuilder(CodegenContext context, TypeRef<?> beanType) {
        super(context, beanType);
        this.ctx.reserveName(REFERENCES_NAME);
        this.ctx.addImport(BinaryRow.class.getPackage().getName() + ".*");
        this.ctx.addImport(BinaryWriter.class.getPackage().getName() + ".*");
        this.ctx.addImport(Schema.class.getPackage().getName() + ".*");
    }

    public String codecClassName(Class<?> beanClass) {
        return this.codecClassName(beanClass, "");
    }

    public String codecClassName(Class<?> beanClass, String prefix) {
        String name = ReflectionUtils.getClassNameWithoutPackage(beanClass) + prefix + this.codecSuffix() + CodeGenerator.getClassUniqueId(beanClass);
        return name.replace("$", "_");
    }

    protected String codecSuffix() {
        return "RowCodec";
    }

    public String codecQualifiedClassName(Class<?> beanClass) {
        return CodeGenerator.getPackage(beanClass) + "." + this.codecClassName(beanClass);
    }

    public String codecQualifiedClassName(Class<?> beanClass, String prefix) {
        return CodeGenerator.getPackage(beanClass) + "." + this.codecClassName(beanClass, prefix);
    }

    protected Expression serializeFor(Expression ordinal, Expression inputObject, Expression writer, TypeRef<?> typeRef, Expression arrowField) {
        Class rawType = TypeUtils.getRawType(typeRef);
        if (TypeUtils.isPrimitive((Class)rawType)) {
            return new Expression.ListExpression(new Expression[]{new Expression.Invoke(writer, "write", new Expression[]{ordinal, inputObject})});
        }
        if (TypeUtils.isBoxed((Class)rawType)) {
            return this.setValueOrNull(writer, ordinal, inputObject, inputObject);
        }
        if (rawType == BigDecimal.class) {
            return this.setValueOrNull(writer, ordinal, inputObject, inputObject);
        }
        if (rawType == BigInteger.class) {
            Expression.Invoke value = new Expression.Invoke(inputObject, "toByteArray", TypeRef.of(byte[].class));
            return this.setValueOrNull(writer, ordinal, inputObject, (Expression)value);
        }
        if (rawType == LocalDate.class) {
            Expression.StaticInvoke value = new Expression.StaticInvoke(DateTimeUtils.class, "localDateToDays", TypeUtils.PRIMITIVE_INT_TYPE, false, new Expression[]{inputObject});
            return this.setValueOrNull(writer, ordinal, inputObject, (Expression)value);
        }
        if (rawType == Date.class) {
            Expression.StaticInvoke value = new Expression.StaticInvoke(DateTimeUtils.class, "fromJavaDate", TypeUtils.PRIMITIVE_INT_TYPE, false, new Expression[]{inputObject});
            return this.setValueOrNull(writer, ordinal, inputObject, (Expression)value);
        }
        if (rawType == Timestamp.class) {
            Expression.StaticInvoke value = new Expression.StaticInvoke(DateTimeUtils.class, "fromJavaTimestamp", TypeUtils.PRIMITIVE_LONG_TYPE, false, new Expression[]{inputObject});
            return this.setValueOrNull(writer, ordinal, inputObject, (Expression)value);
        }
        if (rawType == Instant.class) {
            Expression.StaticInvoke value = new Expression.StaticInvoke(DateTimeUtils.class, "instantToMicros", TypeUtils.PRIMITIVE_LONG_TYPE, false, new Expression[]{inputObject});
            return this.setValueOrNull(writer, ordinal, inputObject, (Expression)value);
        }
        if (rawType == String.class) {
            return this.setValueOrNull(writer, ordinal, inputObject, inputObject);
        }
        if (rawType.isEnum()) {
            Expression.Invoke value = new Expression.Invoke(inputObject, "name", TypeUtils.STRING_TYPE);
            return this.setValueOrNull(writer, ordinal, inputObject, (Expression)value);
        }
        if (rawType.isArray() || TypeUtils.ITERABLE_TYPE.isSupertypeOf(typeRef)) {
            Expression.Invoke offset = new Expression.Invoke(writer, "writerIndex", "writerIndex", TypeUtils.PRIMITIVE_INT_TYPE);
            Expression serializeArray = this.serializeForArray(inputObject, writer, typeRef, arrowField);
            Expression.Arithmetic size = ExpressionUtils.subtract((Expression)new Expression.Invoke(writer, "writerIndex", "writerIndex", TypeUtils.PRIMITIVE_INT_TYPE), (Expression)offset);
            Expression.Invoke setOffsetAndSize = new Expression.Invoke(writer, "setOffsetAndSize", new Expression[]{ordinal, offset, size});
            Expression.ListExpression expression = new Expression.ListExpression(new Expression[]{offset, serializeArray, size, setOffsetAndSize});
            return new Expression.If(ExpressionUtils.eqNull((Expression)inputObject), (Expression)new Expression.Invoke(writer, "setNullAt", new Expression[]{ordinal}), (Expression)expression);
        }
        if (TypeUtils.MAP_TYPE.isSupertypeOf(typeRef)) {
            return this.serializeForMap(ordinal, writer, inputObject, typeRef, arrowField);
        }
        if (TypeUtils.isBean((Class)rawType)) {
            return this.serializeForBean(ordinal, writer, inputObject, typeRef, arrowField);
        }
        return this.serializeForObject(ordinal, writer, inputObject);
    }

    protected Expression serializeForArray(Expression inputObject, Expression writer, TypeRef<?> typeRef, Expression arrowField) {
        return this.serializeForArray(inputObject, writer, typeRef, arrowField, false);
    }

    protected Expression serializeForArray(Expression inputObject, Expression writer, TypeRef<?> typeRef, Expression arrowField, boolean reuse) {
        Expression.Reference arrayWriter = this.getOrCreateArrayWriter(typeRef, arrowField, writer, reuse);
        Expression.StaticInvoke arrayElementField = new Expression.StaticInvoke(DataTypes.class, "arrayElementField", "elemField", ARROW_FIELD_TYPE, false, new Expression[]{arrowField});
        Class rawType = TypeUtils.getRawType(typeRef);
        if (rawType.isArray()) {
            Expression.FieldValue length = new Expression.FieldValue(inputObject, "length", TypeUtils.PRIMITIVE_INT_TYPE);
            Expression.Invoke reset = new Expression.Invoke((Expression)arrayWriter, "reset", new Expression[]{length});
            if (rawType.getComponentType().isPrimitive()) {
                return new Expression.ListExpression(new Expression[]{reset, new Expression.Invoke((Expression)arrayWriter, "fromPrimitiveArray", new Expression[]{inputObject}), arrayWriter});
            }
            Expression.ForEach forEach = new Expression.ForEach(inputObject, (SerializableBiFunction & Serializable)(i, value) -> this.serializeFor((Expression)i, (Expression)value, (Expression)arrayWriter, (TypeRef<?>)Objects.requireNonNull(typeRef.getComponentType()), (Expression)arrayElementField));
            return new Expression.ListExpression(new Expression[]{reset, forEach, arrayWriter});
        }
        if (TypeUtils.getRawType(typeRef) == Iterable.class) {
            Expression.ListFromIterable listFromIterable = new Expression.ListFromIterable(inputObject);
            Expression.Invoke size = new Expression.Invoke((Expression)listFromIterable, "size", TypeUtils.PRIMITIVE_INT_TYPE);
            Expression.Invoke reset = new Expression.Invoke((Expression)arrayWriter, "reset", new Expression[]{size});
            Expression.ForEach forEach = new Expression.ForEach((Expression)listFromIterable, (SerializableBiFunction & Serializable)(i, value) -> this.serializeFor((Expression)i, (Expression)value, (Expression)arrayWriter, (TypeRef<?>)TypeUtils.getElementType((TypeRef)typeRef), (Expression)arrayElementField));
            return new Expression.ListExpression(new Expression[]{reset, forEach, arrayWriter});
        }
        Expression.Invoke size = new Expression.Invoke(inputObject, "size", TypeUtils.PRIMITIVE_INT_TYPE);
        Expression.Invoke reset = new Expression.Invoke((Expression)arrayWriter, "reset", new Expression[]{size});
        Expression.ForEach forEach = new Expression.ForEach(inputObject, (SerializableBiFunction & Serializable)(i, value) -> this.serializeFor((Expression)i, (Expression)value, (Expression)arrayWriter, (TypeRef<?>)TypeUtils.getElementType((TypeRef)typeRef), (Expression)arrayElementField));
        return new Expression.ListExpression(new Expression[]{reset, forEach, arrayWriter});
    }

    protected Expression.Reference getOrCreateArrayWriter(TypeRef<?> typeRef, Expression arrayDataType, Expression writer) {
        return this.getOrCreateArrayWriter(typeRef, arrayDataType, writer, false);
    }

    protected Expression.Reference getOrCreateArrayWriter(TypeRef<?> typeRef, Expression arrayDataType, Expression writer, boolean reuse) {
        if (reuse) {
            return (Expression.Reference)writer;
        }
        return this.arrayWriterMap.computeIfAbsent(typeRef, t -> {
            String name = this.ctx.newName("arrayWriter");
            this.ctx.addField(this.ctx.type(BinaryArrayWriter.class), name, (Expression)new Expression.NewInstance(arrayWriterTypeToken, new Expression[]{arrayDataType, writer}));
            return new Expression.Reference(name, arrayWriterTypeToken, false);
        });
    }

    protected Expression serializeForMap(Expression ordinal, Expression writer, Expression inputObject, TypeRef<?> typeRef, Expression arrowField) {
        Expression.StaticInvoke keyArrayField = new Expression.StaticInvoke(DataTypes.class, "keyArrayFieldForMap", "keyArrayField", ARROW_FIELD_TYPE, false, new Expression[]{arrowField});
        Expression.StaticInvoke valueArrayField = new Expression.StaticInvoke(DataTypes.class, "itemArrayFieldForMap", "valueArrayField", ARROW_FIELD_TYPE, false, new Expression[]{arrowField});
        TypeRef supertype = typeRef.getSupertype(Map.class);
        TypeRef keySetType = supertype.resolveType(TypeUtils.KEY_SET_RETURN_TYPE);
        TypeRef valuesType = supertype.resolveType(TypeUtils.VALUES_RETURN_TYPE);
        Expression.Invoke keySet = new Expression.Invoke(inputObject, "keySet", keySetType);
        Expression keySerializationExpr = this.serializeForArray((Expression)keySet, writer, keySetType, (Expression)keyArrayField);
        Expression.Invoke values = new Expression.Invoke(inputObject, "values", valuesType);
        Expression valueSerializationExpr = this.serializeForArray((Expression)values, writer, valuesType, (Expression)valueArrayField);
        Expression.Invoke offset = new Expression.Invoke(writer, "writerIndex", "writerIndex", TypeUtils.PRIMITIVE_INT_TYPE);
        Expression.Invoke preserve = new Expression.Invoke(writer, "writeDirectly", new Expression[]{new Expression.Literal((Object)-1, TypeUtils.PRIMITIVE_INT_TYPE)});
        Expression.Invoke writeKeyArrayNumBytes = new Expression.Invoke(writer, "writeDirectly", new Expression[]{offset, new Expression.Invoke(keySerializationExpr, "size", TypeUtils.PRIMITIVE_INT_TYPE)});
        Expression.Arithmetic size = ExpressionUtils.subtract((Expression)new Expression.Invoke(writer, "writerIndex", "writerIndex", TypeUtils.PRIMITIVE_INT_TYPE), (Expression)offset);
        Expression.Invoke setOffsetAndSize = new Expression.Invoke(writer, "setOffsetAndSize", new Expression[]{ordinal, offset, size});
        Expression.ListExpression expression = new Expression.ListExpression(new Expression[]{offset, preserve, keySerializationExpr, writeKeyArrayNumBytes, valueSerializationExpr, setOffsetAndSize});
        return new Expression.If(ExpressionUtils.eqNull((Expression)inputObject), (Expression)new Expression.Invoke(writer, "setNullAt", new Expression[]{ordinal}), (Expression)expression);
    }

    protected Expression serializeForBean(Expression ordinal, Expression writer, Expression inputObject, TypeRef<?> typeRef, Expression structField) {
        Expression.Reference rowWriter;
        Class rawType = TypeUtils.getRawType(typeRef);
        Expression.Reference beanEncoder = this.beanEncoderMap.get(typeRef);
        if (beanEncoder == null) {
            Expression.StaticInvoke schema = new Expression.StaticInvoke(DataTypes.class, "schemaFromStructField", "schema", SCHEMA_TYPE, false, new Expression[]{structField});
            String rowWriterName = this.ctx.newName(StringUtils.uncapitalize((String)(rawType.getSimpleName() + "RowWriter")));
            Expression.NewInstance newRowWriter = new Expression.NewInstance(rowWriterTypeToken, new Expression[]{schema, writer});
            this.ctx.addField(this.ctx.type(rowWriterTypeToken), rowWriterName, (Expression)newRowWriter);
            Preconditions.checkArgument((!this.codecClassName(rawType).contains(".") ? 1 : 0) != 0);
            String encoderName = this.ctx.newName(StringUtils.uncapitalize((String)this.codecClassName(rawType)));
            String encoderClass = this.codecQualifiedClassName(rawType);
            TypeRef codecTypeRef = TypeRef.of(GeneratedRowEncoder.class);
            Expression.NewInstance newEncoder = new Expression.NewInstance(codecTypeRef, encoderClass, new Expression[]{ExpressionUtils.newObjectArray((Expression[])new Expression[]{schema, newRowWriter, this.furyRef})});
            this.ctx.addField(encoderClass, encoderName, (Expression)newEncoder);
            rowWriter = new Expression.Reference(rowWriterName, rowWriterTypeToken);
            this.rowWriterMap.put(typeRef, rowWriter);
            beanEncoder = new Expression.Reference(encoderName, codecTypeRef);
            this.beanEncoderMap.put(typeRef, beanEncoder);
        }
        rowWriter = this.rowWriterMap.get(typeRef);
        Expression.Invoke reset = new Expression.Invoke((Expression)rowWriter, "reset", new Expression[0]);
        Expression.Invoke offset = new Expression.Invoke(writer, "writerIndex", "writerIndex", TypeUtils.PRIMITIVE_INT_TYPE);
        Expression.Invoke toRow = new Expression.Invoke((Expression)beanEncoder, "toRow", new Expression[]{inputObject});
        Expression.Arithmetic size = ExpressionUtils.subtract((Expression)new Expression.Invoke(writer, "writerIndex", "writerIndex", TypeUtils.PRIMITIVE_INT_TYPE), (Expression)offset);
        Expression.Invoke setOffsetAndSize = new Expression.Invoke(writer, "setOffsetAndSize", new Expression[]{ordinal, offset, size});
        Expression.ListExpression expression = new Expression.ListExpression(new Expression[]{offset, reset, toRow, size, setOffsetAndSize});
        return new Expression.If(ExpressionUtils.eqNull((Expression)inputObject), (Expression)new Expression.Invoke(writer, "setNullAt", new Expression[]{ordinal}), (Expression)expression);
    }

    protected Expression serializeForObject(Expression ordinal, Expression writer, Expression inputObject) {
        Expression.Invoke offset = new Expression.Invoke(writer, "writerIndex", "writerIndex", TypeUtils.PRIMITIVE_INT_TYPE);
        Expression.Invoke buffer = new Expression.Invoke(writer, "getBuffer", "buffer", TypeRef.of(MemoryBuffer.class));
        Expression.Invoke setWriterIndex = new Expression.Invoke((Expression)buffer, "writerIndex", new Expression[]{offset});
        Expression.Invoke serialize = new Expression.Invoke((Expression)this.furyRef, "serialize", new Expression[]{buffer, inputObject});
        Expression.Invoke newWriterIndex = new Expression.Invoke((Expression)buffer, "writerIndex", "writerIndex", TypeUtils.PRIMITIVE_INT_TYPE);
        Expression.Arithmetic size = ExpressionUtils.subtract((Expression)newWriterIndex, (Expression)offset, (String)"size");
        Expression.Invoke increaseWriterIndexToAligned = new Expression.Invoke(writer, "increaseWriterIndexToAligned", new Expression[]{size});
        Expression.Invoke setOffsetAndSize = new Expression.Invoke(writer, "setOffsetAndSize", new Expression[]{ordinal, offset, size});
        Expression.ListExpression expression = new Expression.ListExpression(new Expression[]{offset, buffer, setWriterIndex, serialize, increaseWriterIndexToAligned, setOffsetAndSize});
        return new Expression.If(ExpressionUtils.eqNull((Expression)inputObject), (Expression)new Expression.Invoke(writer, "setNullAt", new Expression[]{ordinal}), (Expression)expression);
    }

    protected Expression setValueOrNull(Expression writer, Expression ordinal, Expression inputObject, Expression value) {
        Expression.Invoke action = new Expression.Invoke(writer, "write", new Expression[]{ordinal, value});
        return new Expression.If(ExpressionUtils.eqNull((Expression)inputObject), (Expression)new Expression.Invoke(writer, "setNullAt", new Expression[]{ordinal}), (Expression)action);
    }

    protected Expression deserializeFor(Expression value, TypeRef<?> typeRef) {
        Class rawType = TypeUtils.getRawType(typeRef);
        if (TypeUtils.isPrimitive((Class)rawType) || TypeUtils.isBoxed((Class)rawType)) {
            return value;
        }
        if (rawType == BigDecimal.class) {
            return value;
        }
        if (rawType == BigInteger.class) {
            return new Expression.NewInstance(TypeUtils.BIG_INTEGER_TYPE, new Expression[]{value});
        }
        if (rawType == LocalDate.class) {
            return new Expression.StaticInvoke(DateTimeUtils.class, "daysToLocalDate", TypeUtils.LOCAL_DATE_TYPE, false, new Expression[]{value});
        }
        if (rawType == Date.class) {
            return new Expression.StaticInvoke(DateTimeUtils.class, "toJavaDate", TypeUtils.DATE_TYPE, false, new Expression[]{value});
        }
        if (rawType == Timestamp.class) {
            return new Expression.StaticInvoke(DateTimeUtils.class, "toJavaTimestamp", TypeUtils.TIMESTAMP_TYPE, false, new Expression[]{value});
        }
        if (rawType == Instant.class) {
            return new Expression.StaticInvoke(DateTimeUtils.class, "microsToInstant", TypeUtils.INSTANT_TYPE, false, new Expression[]{value});
        }
        if (rawType == String.class) {
            return value;
        }
        if (rawType.isEnum()) {
            return ExpressionUtils.valueOf(typeRef, (Expression)value);
        }
        if (rawType.isArray()) {
            return this.deserializeForArray(value, typeRef);
        }
        if (TypeUtils.ITERABLE_TYPE.isSupertypeOf(typeRef)) {
            return this.deserializeForCollection(value, typeRef);
        }
        if (TypeUtils.MAP_TYPE.isSupertypeOf(typeRef)) {
            return this.deserializeForMap(value, typeRef);
        }
        if (TypeUtils.isBean((Class)rawType)) {
            return this.deserializeForBean(value, typeRef);
        }
        return this.deserializeForObject(value, typeRef);
    }

    protected Expression deserializeForBean(Expression row, TypeRef<?> typeRef) {
        Expression.Reference beanEncoder = this.beanEncoderMap.get(typeRef);
        if (beanEncoder == null) {
            throw new IllegalStateException("beanEncoder should have be added in serializeForBean()");
        }
        Expression.Invoke beanObj = new Expression.Invoke((Expression)beanEncoder, "fromRow", TypeUtils.OBJECT_TYPE, false, new Expression[]{row});
        return new Expression.Cast((Expression)beanObj, typeRef, "bean");
    }

    protected Expression deserializeForMap(Expression mapData, TypeRef<?> typeRef) {
        Expression javaMap = this.newMap(typeRef);
        TypeRef supertype = typeRef.getSupertype(Map.class);
        TypeRef keySetType = supertype.resolveType(TypeUtils.KEY_SET_RETURN_TYPE);
        TypeRef keysType = TypeUtils.getCollectionType((TypeRef)keySetType);
        TypeRef valuesType = supertype.resolveType(TypeUtils.VALUES_RETURN_TYPE);
        Expression.Invoke keyArray = new Expression.Invoke(mapData, "keyArray", binaryArrayTypeToken, false, new Expression[0]);
        Expression.Invoke valueArray = new Expression.Invoke(mapData, "valueArray", binaryArrayTypeToken, false, new Expression[0]);
        Expression keyJavaArray = TypeUtils.ITERABLE_TYPE.isSupertypeOf(keysType) ? this.deserializeForCollection((Expression)keyArray, keysType) : this.deserializeForArray((Expression)keyArray, keysType);
        Expression valueJavaArray = TypeUtils.ITERABLE_TYPE.isSupertypeOf(valuesType) ? this.deserializeForCollection((Expression)valueArray, valuesType) : this.deserializeForArray((Expression)valueArray, valuesType);
        Expression.ZipForEach put = new Expression.ZipForEach(keyJavaArray, valueJavaArray, (SerializableTriFunction & Serializable)(i, key, value) -> new Expression.If(ExpressionUtils.notNull((Expression)key), (Expression)new Expression.Invoke(javaMap, "put", new Expression[]{key, value})));
        return new Expression.ListExpression(new Expression[]{javaMap, put, javaMap});
    }

    protected Expression deserializeForCollection(Expression arrayData, TypeRef<?> typeRef) {
        Expression collection = this.newCollection(typeRef);
        try {
            TypeRef elemType = TypeUtils.getElementType(typeRef);
            ArrayDataForEach addElemsOp = new ArrayDataForEach(arrayData, elemType, (SerializableBiFunction<Expression, Expression, Expression>)(SerializableBiFunction & Serializable)(i, value) -> new Expression.Invoke(collection, "add", new Expression[]{this.deserializeFor((Expression)value, (TypeRef<?>)elemType)}), (SerializableFunction<Expression, Expression>)(SerializableFunction & Serializable)i -> new Expression.Invoke(collection, "add", new Expression[]{ExpressionUtils.nullValue((TypeRef)elemType)}));
            return new Expression.ListExpression(new Expression[]{collection, addElemsOp, collection});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Expression newCollection(TypeRef<?> typeRef) {
        Expression.NewInstance collection;
        Class clazz = TypeUtils.getRawType(typeRef);
        if (TypeRef.of((Class)clazz).isSupertypeOf(TypeRef.of(ArrayList.class))) {
            collection = new Expression.NewInstance(TypeRef.of(ArrayList.class), new Expression[0]);
        } else if (TypeRef.of((Class)clazz).isSupertypeOf(TypeRef.of(HashSet.class))) {
            collection = new Expression.NewInstance(TypeRef.of(HashSet.class), new Expression[0]);
        } else {
            if (ReflectionUtils.isAbstract((Class)clazz) || clazz.isInterface()) {
                String msg = String.format("class %s can't be abstract or interface", clazz);
                throw new UnsupportedOperationException(msg);
            }
            collection = new Expression.NewInstance(typeRef, new Expression[0]);
        }
        return collection;
    }

    protected Expression newMap(TypeRef<?> typeRef) {
        Expression.NewInstance javaMap;
        Class clazz = TypeUtils.getRawType(typeRef);
        if (TypeRef.of((Class)clazz).isSupertypeOf(TypeRef.of(HashMap.class))) {
            javaMap = new Expression.NewInstance(TypeRef.of(HashMap.class), new Expression[0]);
        } else {
            if (ReflectionUtils.isAbstract((Class)clazz) || clazz.isInterface()) {
                String msg = String.format("class %s can't be abstract or interface", clazz);
                throw new UnsupportedOperationException(msg);
            }
            javaMap = new Expression.NewInstance(typeRef, new Expression[0]);
        }
        return javaMap;
    }

    protected Expression deserializeForMultiDimensionArray(Expression arrayData, Expression rootJavaArray, int numDimensions, TypeRef<?> typeRef, Expression[] indexes) {
        Preconditions.checkArgument((numDimensions > 1 ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)typeRef.isArray());
        TypeRef elemType = typeRef.getComponentType();
        if (numDimensions == 2) {
            return new ArrayDataForEach(arrayData, elemType, (SerializableBiFunction<Expression, Expression, Expression>)(SerializableBiFunction & Serializable)(i, value) -> {
                Expression[] newIndexes = Arrays.copyOf(indexes, indexes.length + 1);
                newIndexes[indexes.length] = i;
                Expression elemArr = this.deserializeForArray((Expression)value, (TypeRef<?>)Objects.requireNonNull(typeRef.getComponentType()));
                return new Expression.AssignArrayElem(rootJavaArray, elemArr, newIndexes);
            });
        }
        return new ArrayDataForEach(arrayData, elemType, (SerializableBiFunction<Expression, Expression, Expression>)(SerializableBiFunction & Serializable)(i, value) -> {
            Expression[] newIndexes = Arrays.copyOf(indexes, indexes.length + 1);
            newIndexes[indexes.length] = i;
            return this.deserializeForMultiDimensionArray((Expression)value, rootJavaArray, numDimensions - 1, (TypeRef<?>)elemType, newIndexes);
        });
    }

    protected Expression deserializeForArray(Expression arrayData, TypeRef<?> typeRef) {
        int numDimensions = TypeUtils.getArrayDimensions(typeRef);
        if (numDimensions > 1) {
            Expression.StaticInvoke dimensions = new Expression.StaticInvoke(BinaryArray.class, "getDimensions", "dims", TypeRef.of(int[].class), true, new Expression[]{arrayData, new Expression.Literal((Object)numDimensions, TypeUtils.INT_TYPE)});
            TypeRef innerElemType = TypeUtils.getMultiDimensionArrayElementType(typeRef);
            Class innerElemClass = TypeUtils.getRawType((TypeRef)innerElemType);
            Expression.NewArray rootJavaMultiDimArray = new Expression.NewArray(innerElemClass, numDimensions, (Expression)dimensions);
            Expression op = this.deserializeForMultiDimensionArray(arrayData, (Expression)rootJavaMultiDimArray, numDimensions, typeRef, new Expression[0]);
            return new Expression.If(ExpressionUtils.notNull((Expression)dimensions), (Expression)new Expression.ListExpression(new Expression[]{rootJavaMultiDimArray, op, rootJavaMultiDimArray}), (Expression)ExpressionUtils.nullValue((TypeRef)rootJavaMultiDimArray.type()), false);
        }
        TypeRef elemType = typeRef.getComponentType();
        Class innerElemClass = TypeUtils.getRawType((TypeRef)Objects.requireNonNull(elemType));
        if (Byte.TYPE == innerElemClass) {
            return new Expression.Invoke(arrayData, "toByteArray", TypeUtils.PRIMITIVE_BYTE_ARRAY_TYPE);
        }
        if (Boolean.TYPE == innerElemClass) {
            return new Expression.Invoke(arrayData, "toBooleanArray", TypeUtils.PRIMITIVE_BOOLEAN_ARRAY_TYPE);
        }
        if (Short.TYPE == innerElemClass) {
            return new Expression.Invoke(arrayData, "toShortArray", TypeUtils.PRIMITIVE_SHORT_ARRAY_TYPE);
        }
        if (Integer.TYPE == innerElemClass) {
            return new Expression.Invoke(arrayData, "toIntArray", TypeUtils.PRIMITIVE_INT_ARRAY_TYPE);
        }
        if (Long.TYPE == innerElemClass) {
            return new Expression.Invoke(arrayData, "toLongArray", TypeUtils.PRIMITIVE_LONG_ARRAY_TYPE);
        }
        if (Float.TYPE == innerElemClass) {
            return new Expression.Invoke(arrayData, "toFloatArray", TypeUtils.PRIMITIVE_FLOAT_ARRAY_TYPE);
        }
        if (Double.TYPE == innerElemClass) {
            return new Expression.Invoke(arrayData, "toDoubleArray", TypeUtils.PRIMITIVE_DOUBLE_ARRAY_TYPE);
        }
        Expression.Invoke dim = new Expression.Invoke(arrayData, "numElements", TypeUtils.PRIMITIVE_INT_TYPE);
        Expression.NewArray javaArray = new Expression.NewArray(innerElemClass, (Expression)dim);
        ArrayDataForEach op = new ArrayDataForEach(arrayData, elemType, (SerializableBiFunction<Expression, Expression, Expression>)(SerializableBiFunction & Serializable)(i, value) -> {
            Expression elemValue = this.deserializeFor((Expression)value, (TypeRef<?>)elemType);
            return new Expression.AssignArrayElem((Expression)javaArray, elemValue, new Expression[]{i});
        });
        return new Expression.ListExpression(new Expression[]{javaArray, op, javaArray});
    }

    protected Expression deserializeForObject(Expression value, TypeRef<?> typeRef) {
        return new Expression.Invoke((Expression)this.furyRef, "deserialize", typeRef, new Expression[]{value});
    }
}

