/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.format.encoder;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.fury.Fury;
import org.apache.fury.codegen.CodeGenerator;
import org.apache.fury.codegen.CompileUnit;
import org.apache.fury.collection.Tuple2;
import org.apache.fury.exception.ClassNotCompatibleException;
import org.apache.fury.format.encoder.ArrayEncoder;
import org.apache.fury.format.encoder.ArrayEncoderBuilder;
import org.apache.fury.format.encoder.EncoderException;
import org.apache.fury.format.encoder.GeneratedArrayEncoder;
import org.apache.fury.format.encoder.GeneratedMapEncoder;
import org.apache.fury.format.encoder.GeneratedRowEncoder;
import org.apache.fury.format.encoder.MapEncoder;
import org.apache.fury.format.encoder.MapEncoderBuilder;
import org.apache.fury.format.encoder.RowEncoder;
import org.apache.fury.format.encoder.RowEncoderBuilder;
import org.apache.fury.format.row.binary.BinaryArray;
import org.apache.fury.format.row.binary.BinaryMap;
import org.apache.fury.format.row.binary.BinaryRow;
import org.apache.fury.format.row.binary.writer.BinaryArrayWriter;
import org.apache.fury.format.row.binary.writer.BinaryRowWriter;
import org.apache.fury.format.type.DataTypes;
import org.apache.fury.format.type.TypeInference;
import org.apache.fury.logging.Logger;
import org.apache.fury.logging.LoggerFactory;
import org.apache.fury.memory.MemoryBuffer;
import org.apache.fury.memory.MemoryUtils;
import org.apache.fury.reflect.TypeRef;
import org.apache.fury.type.TypeUtils;

public class Encoders {
    private static final Logger LOG = LoggerFactory.getLogger(Encoders.class);

    public static <T> RowEncoder<T> bean(Class<T> beanClass) {
        return Encoders.bean(beanClass, 16);
    }

    public static <T> RowEncoder<T> bean(Class<T> beanClass, int initialBufferSize) {
        return Encoders.bean(beanClass, null, initialBufferSize);
    }

    public static <T> RowEncoder<T> bean(Class<T> beanClass, Fury fury) {
        return Encoders.bean(beanClass, fury, 16);
    }

    public static <T> RowEncoder<T> bean(Class<T> beanClass, Fury fury, final int initialBufferSize) {
        Schema schema = TypeInference.inferSchema(beanClass);
        final BinaryRowWriter writer = new BinaryRowWriter(schema);
        final RowEncoder<T> encoder = Encoders.bean(beanClass, writer, fury);
        return new RowEncoder<T>(){

            @Override
            public Schema schema() {
                return encoder.schema();
            }

            @Override
            public T fromRow(BinaryRow row) {
                return encoder.fromRow(row);
            }

            @Override
            public BinaryRow toRow(T obj) {
                writer.setBuffer(MemoryUtils.buffer((int)initialBufferSize));
                writer.reset();
                return encoder.toRow(obj);
            }

            @Override
            public T decode(byte[] bytes) {
                return encoder.decode(bytes);
            }

            @Override
            public byte[] encode(T obj) {
                return encoder.encode(obj);
            }
        };
    }

    public static <T> RowEncoder<T> bean(Class<T> beanClass, BinaryRowWriter writer) {
        return Encoders.bean(beanClass, writer, null);
    }

    public static <T> RowEncoder<T> bean(Class<T> beanClass, final BinaryRowWriter writer, Fury fury) {
        final Schema schema = writer.getSchema();
        try {
            Class<?> rowCodecClass = Encoders.loadOrGenRowCodecClass(beanClass);
            Object[] references = new Object[]{schema, writer, fury};
            final GeneratedRowEncoder codec = rowCodecClass.asSubclass(GeneratedRowEncoder.class).getConstructor(Object[].class).newInstance(new Object[]{references});
            final long schemaHash = DataTypes.computeSchemaHash(schema);
            return new RowEncoder<T>(){
                private final MemoryBuffer buffer = MemoryUtils.buffer((int)16);

                @Override
                public Schema schema() {
                    return schema;
                }

                @Override
                public T fromRow(BinaryRow row) {
                    return codec.fromRow(row);
                }

                @Override
                public BinaryRow toRow(T obj) {
                    return codec.toRow(obj);
                }

                @Override
                public T decode(byte[] bytes) {
                    MemoryBuffer buffer = MemoryUtils.wrap((byte[])bytes);
                    long peerSchemaHash = buffer.readInt64();
                    if (peerSchemaHash != schemaHash) {
                        throw new ClassNotCompatibleException(String.format("Schema is not consistent, encoder schema is %s. self/peer schema hash are %s/%s. Please check writer schema.", schema, schemaHash, peerSchemaHash));
                    }
                    BinaryRow row = new BinaryRow(schema);
                    row.pointTo(buffer, buffer.readerIndex(), buffer.size());
                    return this.fromRow(row);
                }

                @Override
                public byte[] encode(T obj) {
                    this.buffer.writerIndex(0);
                    this.buffer.writeInt64(schemaHash);
                    writer.setBuffer(this.buffer);
                    writer.reset();
                    BinaryRow row = this.toRow(obj);
                    return this.buffer.getBytes(0, 8 + row.getSizeInBytes());
                }
            };
        }
        catch (Exception e) {
            String msg = String.format("Create encoder failed, \nbeanClass: %s", beanClass);
            throw new EncoderException(msg, e);
        }
    }

    public static <T extends Collection> ArrayEncoder<T> arrayEncoder(TypeRef<T> token) {
        return Encoders.arrayEncoder(token, (Fury)null);
    }

    public static <T extends Collection> ArrayEncoder<T> arrayEncoder(TypeRef<T> token, Fury fury) {
        Schema schema = TypeInference.inferSchema(token, false);
        Field field = DataTypes.fieldOfSchema(schema, 0);
        BinaryArrayWriter writer = new BinaryArrayWriter(field);
        HashSet set = new HashSet();
        Encoders.findBeanToken(token, set);
        if (set.isEmpty()) {
            throw new IllegalArgumentException("can not find bean class.");
        }
        TypeRef typeRef = null;
        for (TypeRef typeRef2 : set) {
            typeRef = (TypeRef)set.iterator().next();
            Encoders.loadOrGenRowCodecClass(TypeUtils.getRawType((TypeRef)typeRef2));
        }
        final ArrayEncoder<T> encoder = Encoders.arrayEncoder(token, typeRef, writer, fury);
        return new ArrayEncoder<T>(){

            @Override
            public Field field() {
                return encoder.field();
            }

            @Override
            public T fromArray(BinaryArray array) {
                return (Collection)encoder.fromArray(array);
            }

            @Override
            public BinaryArray toArray(T obj) {
                return encoder.toArray(obj);
            }

            @Override
            public T decode(byte[] bytes) {
                return (Collection)encoder.decode(bytes);
            }

            @Override
            public byte[] encode(T obj) {
                return encoder.encode(obj);
            }
        };
    }

    public static <T extends Collection, B> ArrayEncoder<T> arrayEncoder(Class<? extends Collection> arrayCls, Class<B> elementType) {
        Preconditions.checkNotNull(elementType);
        return Encoders.arrayEncoder(TypeUtils.listOf(elementType), null);
    }

    public static <T extends Collection, B> ArrayEncoder<T> arrayEncoder(TypeRef<? extends Collection> arrayToken, TypeRef<B> elementType, final BinaryArrayWriter writer, Fury fury) {
        final Field field = writer.getField();
        try {
            Class<?> rowCodecClass = Encoders.loadOrGenArrayCodecClass(arrayToken, elementType);
            Object[] references = new Object[]{field, writer, fury};
            final GeneratedArrayEncoder codec = rowCodecClass.asSubclass(GeneratedArrayEncoder.class).getConstructor(Object[].class).newInstance(new Object[]{references});
            return new ArrayEncoder<T>(){

                @Override
                public Field field() {
                    return field;
                }

                @Override
                public T fromArray(BinaryArray array) {
                    return (Collection)codec.fromArray(array);
                }

                @Override
                public BinaryArray toArray(T obj) {
                    return codec.toArray(obj);
                }

                @Override
                public T decode(byte[] bytes) {
                    MemoryBuffer buffer = MemoryUtils.wrap((byte[])bytes);
                    BinaryArray array = new BinaryArray(field);
                    array.pointTo(buffer, buffer.readerIndex(), buffer.size());
                    return this.fromArray(array);
                }

                @Override
                public byte[] encode(T obj) {
                    writer.reset(obj.size());
                    BinaryArray array = this.toArray((T)obj);
                    return writer.getBuffer().getBytes(0, 8 + array.getSizeInBytes());
                }
            };
        }
        catch (Exception e) {
            String msg = String.format("Create encoder failed, \nelementType: %s", elementType);
            throw new EncoderException(msg, e);
        }
    }

    public static <T extends Map> MapEncoder<T> mapEncoder(TypeRef<T> token) {
        return Encoders.mapEncoder(token, null);
    }

    public static <T extends Map, K, V> MapEncoder<T> mapEncoder(Class<? extends Map> mapCls, Class<K> keyType, Class<V> valueType) {
        Preconditions.checkNotNull(keyType);
        Preconditions.checkNotNull(valueType);
        return Encoders.mapEncoder(TypeUtils.mapOf(keyType, valueType), null);
    }

    public static <T extends Map> MapEncoder<T> mapEncoder(TypeRef<T> token, Fury fury) {
        Preconditions.checkNotNull(token);
        Tuple2 tuple2 = TypeUtils.getMapKeyValueType(token);
        Set<TypeRef<?>> set1 = Encoders.beanSet((TypeRef)tuple2.f0);
        Set<TypeRef<?>> set2 = Encoders.beanSet((TypeRef)tuple2.f1);
        LOG.info("Find beans to load: {}, {}", set1, set2);
        if (set1.isEmpty() && set2.isEmpty()) {
            throw new IllegalArgumentException("can not find bean class.");
        }
        TypeRef<?> keyToken = Encoders.token4BeanLoad(set1, (TypeRef)tuple2.f0);
        TypeRef<?> valToken = Encoders.token4BeanLoad(set2, (TypeRef)tuple2.f1);
        MapEncoder<T> encoder = Encoders.mapEncoder(token, keyToken, valToken, fury);
        return Encoders.createMapEncoder(encoder);
    }

    public static <T extends Map, K, V> MapEncoder<T> mapEncoder(TypeRef<? extends Map> mapToken, TypeRef<K> keyToken, TypeRef<V> valToken, Fury fury) {
        Preconditions.checkNotNull(mapToken);
        Preconditions.checkNotNull(keyToken);
        Preconditions.checkNotNull(valToken);
        Schema schema = TypeInference.inferSchema(mapToken, false);
        final Field field = DataTypes.fieldOfSchema(schema, 0);
        final Field keyField = DataTypes.keyArrayFieldForMap(field);
        final Field valField = DataTypes.itemArrayFieldForMap(field);
        BinaryArrayWriter keyWriter = new BinaryArrayWriter(keyField);
        BinaryArrayWriter valWriter = new BinaryArrayWriter(valField);
        try {
            Class<?> rowCodecClass = Encoders.loadOrGenMapCodecClass(mapToken, keyToken, valToken);
            Object[] references = new Object[]{keyField, valField, keyWriter, valWriter, fury, field};
            final GeneratedMapEncoder codec = rowCodecClass.asSubclass(GeneratedMapEncoder.class).getConstructor(Object[].class).newInstance(new Object[]{references});
            return new MapEncoder<T>(){

                @Override
                public Field keyField() {
                    return keyField;
                }

                @Override
                public Field valueField() {
                    return valField;
                }

                @Override
                public T fromMap(BinaryArray key, BinaryArray value) {
                    return (Map)codec.fromMap(key, value);
                }

                @Override
                public BinaryMap toMap(T obj) {
                    return codec.toMap(obj);
                }

                @Override
                public T decode(byte[] bytes) {
                    MemoryBuffer buffer = MemoryUtils.wrap((byte[])bytes);
                    BinaryMap map = new BinaryMap(field);
                    map.pointTo(buffer, 0, buffer.size());
                    return (Map)this.fromMap(map);
                }

                @Override
                public byte[] encode(T obj) {
                    BinaryMap map = this.toMap((T)obj);
                    return map.getBuf().readBytes(map.getBuf().size());
                }
            };
        }
        catch (Exception e) {
            String msg = String.format("Create encoder failed, \nkeyType: %s, valueType: %s", keyToken, valToken);
            throw new EncoderException(msg, e);
        }
    }

    private static Set<TypeRef<?>> beanSet(TypeRef<?> token) {
        HashSet set = new HashSet();
        if (TypeUtils.isBean(token)) {
            set.add(token);
            return set;
        }
        Encoders.findBeanToken(token, set);
        return set;
    }

    private static TypeRef<?> token4BeanLoad(Set<TypeRef<?>> set, TypeRef<?> init) {
        TypeRef<?> keyToken = init;
        for (TypeRef<?> tt : set) {
            keyToken = tt;
            Encoders.loadOrGenRowCodecClass(TypeUtils.getRawType(tt));
            LOG.info("bean {} load finished", (Object)TypeUtils.getRawType(tt));
        }
        return keyToken;
    }

    private static <T> MapEncoder<T> createMapEncoder(final MapEncoder<T> encoder) {
        return new MapEncoder<T>(){

            @Override
            public Field keyField() {
                return encoder.keyField();
            }

            @Override
            public Field valueField() {
                return encoder.valueField();
            }

            @Override
            public T fromMap(BinaryArray key, BinaryArray value) {
                return encoder.fromMap(key, value);
            }

            @Override
            public BinaryMap toMap(T obj) {
                return encoder.toMap(obj);
            }

            @Override
            public T decode(byte[] bytes) {
                return encoder.decode(bytes);
            }

            @Override
            public byte[] encode(T obj) {
                return encoder.encode(obj);
            }
        };
    }

    private static void findBeanToken(TypeRef<?> typeRef, Set<TypeRef<?>> set) {
        while (TypeUtils.ITERABLE_TYPE.isSupertypeOf(typeRef) || TypeUtils.MAP_TYPE.isSupertypeOf(typeRef)) {
            if (TypeUtils.ITERABLE_TYPE.isSupertypeOf(typeRef)) {
                if (!TypeUtils.isBean((TypeRef)(typeRef = TypeUtils.getElementType(typeRef)))) continue;
                set.add(typeRef);
                continue;
            }
            Tuple2 tuple2 = TypeUtils.getMapKeyValueType(typeRef);
            if (TypeUtils.isBean((TypeRef)((TypeRef)tuple2.f0))) {
                set.add((TypeRef<?>)tuple2.f0);
            } else {
                typeRef = (TypeRef)tuple2.f0;
                Encoders.findBeanToken((TypeRef)tuple2.f0, set);
            }
            if (TypeUtils.isBean((TypeRef)((TypeRef)tuple2.f1))) {
                set.add((TypeRef<?>)tuple2.f1);
                continue;
            }
            typeRef = (TypeRef)tuple2.f1;
            Encoders.findBeanToken((TypeRef)tuple2.f1, set);
        }
    }

    public static Class<?> loadOrGenRowCodecClass(Class<?> beanClass) {
        LinkedHashSet classes = TypeUtils.listBeansRecursiveInclusive(beanClass);
        LOG.info("Create RowCodec for classes {}", (Object)classes);
        CompileUnit[] compileUnits = (CompileUnit[])classes.stream().map(cls -> {
            RowEncoderBuilder codecBuilder = new RowEncoderBuilder((Class<?>)cls);
            return new CompileUnit(CodeGenerator.getPackage((Class)cls), codecBuilder.codecClassName((Class<?>)cls), codecBuilder::genCode);
        }).toArray(CompileUnit[]::new);
        return Encoders.loadCls(compileUnits);
    }

    private static <B> Class<?> loadOrGenArrayCodecClass(TypeRef<? extends Collection> arrayCls, TypeRef<B> elementType) {
        LOG.info("Create ArrayCodec for classes {}", elementType);
        Class cls = TypeUtils.getRawType(elementType);
        String prefix = TypeInference.inferTypeName(arrayCls);
        ArrayEncoderBuilder codecBuilder = new ArrayEncoderBuilder(arrayCls, elementType);
        CompileUnit compileUnit = new CompileUnit(CodeGenerator.getPackage((Class)cls), codecBuilder.codecClassName(cls, prefix), codecBuilder::genCode);
        return Encoders.loadCls(compileUnit);
    }

    private static <K, V> Class<?> loadOrGenMapCodecClass(TypeRef<? extends Map> mapCls, TypeRef<K> keyToken, TypeRef<V> valueToken) {
        Object beanToken;
        Class cls;
        LOG.info("Create MapCodec for classes {}, {}", keyToken, valueToken);
        boolean keyIsBean = TypeUtils.isBean(keyToken);
        boolean valIsBean = TypeUtils.isBean(valueToken);
        if (keyIsBean) {
            cls = TypeUtils.getRawType(keyToken);
            beanToken = keyToken;
        } else if (valIsBean) {
            cls = TypeUtils.getRawType(valueToken);
            beanToken = valueToken;
        } else {
            throw new IllegalArgumentException("not find bean class.");
        }
        String prefix = TypeInference.inferTypeName(mapCls);
        MapEncoderBuilder codecBuilder = new MapEncoderBuilder(mapCls, (TypeRef<?>)beanToken);
        CompileUnit compileUnit = new CompileUnit(CodeGenerator.getPackage((Class)cls), codecBuilder.codecClassName(cls, prefix), codecBuilder::genCode);
        return Encoders.loadCls(compileUnit);
    }

    private static Class<?> loadCls(CompileUnit ... compileUnit) {
        CodeGenerator codeGenerator = CodeGenerator.getSharedCodeGenerator((ClassLoader)Thread.currentThread().getContextClassLoader());
        ClassLoader classLoader = codeGenerator.compile(compileUnit);
        String className = compileUnit[0].getQualifiedClassName();
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Impossible because we just compiled class", e);
        }
    }
}

