/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.lucene.LuceneServiceProvider;
import org.apache.geode.cache.lucene.internal.LuceneServiceImpl;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.PooledDistributionMessage;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class DestroyLuceneIndexMessage
extends PooledDistributionMessage
implements MessageWithReply {
    private static final Logger logger = LogService.getLogger();
    private int processorId;
    private String regionPath;
    private String indexName;

    public DestroyLuceneIndexMessage() {
    }

    protected DestroyLuceneIndexMessage(Collection recipients, int processorId, String regionPath, String indexName) {
        this.setRecipients(recipients);
        this.processorId = processorId;
        this.regionPath = regionPath;
        this.indexName = indexName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(DistributionManager dm) {
        ReplyException replyException = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("DestroyLuceneIndexMessage: Destroying regionPath=" + this.regionPath + "; indexName=" + this.indexName);
            }
            try {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                LuceneServiceImpl impl = (LuceneServiceImpl)LuceneServiceProvider.get((GemFireCache)cache);
                impl.destroyIndex(this.indexName, this.regionPath, false);
                if (logger.isDebugEnabled()) {
                    logger.debug("DestroyLuceneIndexMessage: Destroyed regionPath=" + this.regionPath + "; indexName=" + this.indexName);
                }
            }
            catch (Throwable e) {
                replyException = new ReplyException(e);
                if (logger.isDebugEnabled()) {
                    logger.debug("DestroyLuceneIndexMessage: Caught the following exception attempting to destroy indexName=" + this.indexName + "; regionPath=" + this.regionPath + ":", e);
                }
            }
        }
        finally {
            ReplyMessage replyMsg = new ReplyMessage();
            replyMsg.setRecipient(this.getSender());
            replyMsg.setProcessorId(this.processorId);
            if (replyException != null) {
                replyMsg.setException(replyException);
            }
            dm.putOutgoing((DistributionMessage)replyMsg);
        }
    }

    public int getDSFID() {
        return 2178;
    }

    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.processorId);
        DataSerializer.writeString((String)this.regionPath, (DataOutput)out);
        DataSerializer.writeString((String)this.indexName, (DataOutput)out);
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.processorId = in.readInt();
        this.regionPath = DataSerializer.readString((DataInput)in);
        this.indexName = DataSerializer.readString((DataInput)in);
    }
}

