/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal;

import java.util.Map;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.EvictionAlgorithm;
import org.apache.geode.cache.EvictionAttributes;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.asyncqueue.internal.AsyncEventQueueImpl;
import org.apache.geode.cache.lucene.internal.AbstractPartitionedRepositoryManager;
import org.apache.geode.cache.lucene.internal.LuceneIndexCreationProfile;
import org.apache.geode.cache.lucene.internal.LuceneIndexImpl;
import org.apache.geode.cache.lucene.internal.LuceneServiceImpl;
import org.apache.geode.internal.cache.CacheServiceProfile;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.cache.RegionListener;
import org.apache.lucene.analysis.Analyzer;

public class LuceneRegionListener
implements RegionListener {
    private final LuceneServiceImpl service;
    private final InternalCache cache;
    private final String indexName;
    private final String regionPath;
    private final Analyzer analyzer;
    private final Map<String, Analyzer> fieldAnalyzers;
    private final String[] fields;
    private LuceneIndexImpl luceneIndex;

    public LuceneRegionListener(LuceneServiceImpl service, InternalCache cache, String indexName, String regionPath, String[] fields, Analyzer analyzer, Map<String, Analyzer> fieldAnalyzers) {
        this.service = service;
        this.cache = cache;
        this.indexName = indexName;
        this.regionPath = regionPath;
        this.fields = fields;
        this.analyzer = analyzer;
        this.fieldAnalyzers = fieldAnalyzers;
    }

    public String getRegionPath() {
        return this.regionPath;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public RegionAttributes beforeCreate(Region parent, String regionName, RegionAttributes attrs, InternalRegionArguments internalRegionArgs) {
        String path;
        RegionAttributes updatedRA = attrs;
        String string = path = parent == null ? "/" + regionName : parent.getFullPath() + "/" + regionName;
        if (path.equals(this.regionPath)) {
            if (!attrs.getDataPolicy().withPartitioning()) {
                throw new UnsupportedOperationException("Lucene indexes on replicated regions are not supported");
            }
            EvictionAttributes evictionAttributes = attrs.getEvictionAttributes();
            EvictionAlgorithm evictionAlgorithm = evictionAttributes.getAlgorithm();
            if (evictionAlgorithm != EvictionAlgorithm.NONE && evictionAttributes.getAction().isLocalDestroy()) {
                throw new UnsupportedOperationException("Lucene indexes on regions with eviction and action local destroy are not supported");
            }
            String aeqId = LuceneServiceImpl.getUniqueIndexName(this.indexName, this.regionPath);
            if (!attrs.getAsyncEventQueueIds().contains(aeqId)) {
                AttributesFactory af = new AttributesFactory(attrs);
                af.addAsyncEventQueueId(aeqId);
                updatedRA = af.create();
            }
            internalRegionArgs.addCacheServiceProfile((CacheServiceProfile)new LuceneIndexCreationProfile(this.indexName, this.regionPath, this.fields, this.analyzer, this.fieldAnalyzers));
            this.luceneIndex = this.service.beforeDataRegionCreated(this.indexName, this.regionPath, attrs, this.analyzer, this.fieldAnalyzers, aeqId, this.fields);
            internalRegionArgs.addInternalAsyncEventQueueId(aeqId);
        }
        return updatedRA;
    }

    public void afterCreate(Region region) {
        if (region.getFullPath().equals(this.regionPath)) {
            this.service.afterDataRegionCreated(this.luceneIndex);
            String aeqId = LuceneServiceImpl.getUniqueIndexName(this.indexName, this.regionPath);
            AsyncEventQueueImpl aeq = (AsyncEventQueueImpl)this.cache.getAsyncEventQueue(aeqId);
            AbstractPartitionedRepositoryManager repositoryManager = (AbstractPartitionedRepositoryManager)this.luceneIndex.getRepositoryManager();
            repositoryManager.allowRepositoryComputation();
            this.cache.removeRegionListener((RegionListener)this);
        }
    }
}

