/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin;

import java.io.Serializable;
import org.apache.geode.admin.DistributedSystemHealthConfig;
import org.apache.geode.admin.GemFireHealthConfig;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.i18n.LocalizedStrings;

public interface GemFireHealth {
    public static final Health GOOD_HEALTH = new Health(Health.GOOD_STRING);
    public static final Health OKAY_HEALTH = new Health(Health.OKAY_STRING);
    public static final Health POOR_HEALTH = new Health(Health.POOR_STRING);

    public Health getHealth();

    public void resetHealth();

    public String getDiagnosis();

    public DistributedSystemHealthConfig getDistributedSystemHealthConfig();

    public void setDistributedSystemHealthConfig(DistributedSystemHealthConfig var1);

    public GemFireHealthConfig getDefaultGemFireHealthConfig();

    public void setDefaultGemFireHealthConfig(GemFireHealthConfig var1);

    public GemFireHealthConfig getGemFireHealthConfig(String var1);

    public void setGemFireHealthConfig(String var1, GemFireHealthConfig var2);

    public void close();

    public boolean isClosed();

    public static class Health
    implements Serializable {
        private static final long serialVersionUID = 3039539430412151801L;
        static final String GOOD_STRING = LocalizedStrings.GemFireHealth_GOOD.toLocalizedString();
        static final String OKAY_STRING = LocalizedStrings.GemFireHealth_OKAY.toLocalizedString();
        static final String POOR_STRING = LocalizedStrings.GemFireHealth_POOR.toLocalizedString();
        private String healthString;

        protected Health(String healthString) {
            this.healthString = healthString;
        }

        public Object readResolve() {
            if (this.healthString.equals(GOOD_STRING)) {
                return GOOD_HEALTH;
            }
            if (this.healthString.equals(OKAY_STRING)) {
                return OKAY_HEALTH;
            }
            if (this.healthString.equals(POOR_STRING)) {
                return POOR_HEALTH;
            }
            Assert.assertTrue(false, "Unknown healthString: " + this.healthString);
            return null;
        }

        public String toString() {
            return this.healthString;
        }
    }
}

