/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache;

import java.io.File;
import java.util.Properties;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.CacheExistsException;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.CacheLoader;
import org.apache.geode.cache.CacheWriter;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.CustomExpiry;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.DiskWriteAttributes;
import org.apache.geode.cache.EvictionAttributes;
import org.apache.geode.cache.ExpirationAttributes;
import org.apache.geode.cache.MembershipAttributes;
import org.apache.geode.cache.PartitionAttributes;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionExistsException;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.SubscriptionAttributes;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.compression.Compressor;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class RegionFactory<K, V> {
    private final AttributesFactory<K, V> attrsFactory;
    private final InternalCache cache;

    protected RegionFactory(InternalCache cache) {
        this.cache = cache;
        this.attrsFactory = new AttributesFactory();
    }

    protected RegionFactory(InternalCache cache, RegionShortcut pra) {
        this.cache = cache;
        RegionAttributes ra = cache.getRegionAttributes(pra.toString());
        if (ra == null) {
            throw new IllegalStateException("The region shortcut " + (Object)((Object)pra) + " has been removed.");
        }
        this.attrsFactory = new AttributesFactory(ra);
    }

    protected RegionFactory(InternalCache cache, RegionAttributes ra) {
        this.cache = cache;
        this.attrsFactory = new AttributesFactory(ra);
    }

    protected RegionFactory(InternalCache cache, String regionAttributesId) {
        this.cache = cache;
        RegionAttributes ra = this.getCache().getRegionAttributes(regionAttributesId);
        if (ra == null) {
            throw new IllegalStateException(LocalizedStrings.RegionFactory_NO_ATTRIBUTES_ASSOCIATED_WITH_0.toLocalizedString(regionAttributesId));
        }
        this.attrsFactory = new AttributesFactory(ra);
    }

    @Deprecated
    public RegionFactory() throws CacheWriterException, RegionExistsException, TimeoutException {
        this((InternalCache)new CacheFactory().create());
    }

    @Deprecated
    public RegionFactory(RegionAttributes<K, V> regionAttributes) throws CacheWriterException, RegionExistsException, TimeoutException {
        this((InternalCache)new CacheFactory().create(), regionAttributes);
    }

    @Deprecated
    public RegionFactory(String regionAttributesId) throws CacheWriterException, RegionExistsException, TimeoutException {
        this((InternalCache)new CacheFactory().create(), regionAttributesId);
    }

    @Deprecated
    public RegionFactory(Properties distributedSystemProperties) throws CacheWriterException, RegionExistsException, TimeoutException {
        this((InternalCache)new CacheFactory(distributedSystemProperties).create());
    }

    @Deprecated
    public RegionFactory(Properties distributedSystemProperties, RegionAttributes<K, V> regionAttributes) throws CacheWriterException, RegionExistsException, TimeoutException {
        this((InternalCache)new CacheFactory(distributedSystemProperties).create(), regionAttributes);
    }

    @Deprecated
    public RegionFactory(Properties distributedSystemProperties, String regionAttributesId) throws CacheWriterException, RegionExistsException, TimeoutException {
        this((InternalCache)new CacheFactory(distributedSystemProperties).create(), regionAttributesId);
    }

    private synchronized InternalCache getCache() {
        return this.cache;
    }

    public RegionFactory<K, V> setCacheLoader(CacheLoader<K, V> cacheLoader) {
        this.attrsFactory.setCacheLoader(cacheLoader);
        return this;
    }

    public RegionFactory<K, V> setCacheWriter(CacheWriter<K, V> cacheWriter) {
        this.attrsFactory.setCacheWriter(cacheWriter);
        return this;
    }

    public RegionFactory<K, V> addCacheListener(CacheListener<K, V> aListener) {
        this.attrsFactory.addCacheListener(aListener);
        return this;
    }

    public RegionFactory<K, V> initCacheListeners(CacheListener<K, V>[] newListeners) {
        this.attrsFactory.initCacheListeners(newListeners);
        return this;
    }

    public RegionFactory<K, V> setEvictionAttributes(EvictionAttributes evictionAttributes) {
        this.attrsFactory.setEvictionAttributes(evictionAttributes);
        return this;
    }

    public RegionFactory<K, V> setEntryIdleTimeout(ExpirationAttributes idleTimeout) {
        this.attrsFactory.setEntryIdleTimeout(idleTimeout);
        return this;
    }

    public RegionFactory<K, V> setCustomEntryIdleTimeout(CustomExpiry<K, V> custom) {
        this.attrsFactory.setCustomEntryIdleTimeout(custom);
        return this;
    }

    public RegionFactory<K, V> setEntryTimeToLive(ExpirationAttributes timeToLive) {
        this.attrsFactory.setEntryTimeToLive(timeToLive);
        return this;
    }

    public RegionFactory<K, V> setCustomEntryTimeToLive(CustomExpiry<K, V> custom) {
        this.attrsFactory.setCustomEntryTimeToLive(custom);
        return this;
    }

    public RegionFactory<K, V> setRegionIdleTimeout(ExpirationAttributes idleTimeout) {
        this.attrsFactory.setRegionIdleTimeout(idleTimeout);
        return this;
    }

    public RegionFactory<K, V> setRegionTimeToLive(ExpirationAttributes timeToLive) {
        this.attrsFactory.setRegionTimeToLive(timeToLive);
        return this;
    }

    public RegionFactory<K, V> setScope(Scope scopeType) {
        this.attrsFactory.setScope(scopeType);
        return this;
    }

    public RegionFactory<K, V> setDataPolicy(DataPolicy dataPolicy) {
        this.attrsFactory.setDataPolicy(dataPolicy);
        return this;
    }

    @Deprecated
    public RegionFactory<K, V> setEarlyAck(boolean earlyAck) {
        this.attrsFactory.setEarlyAck(earlyAck);
        return this;
    }

    public RegionFactory<K, V> setMulticastEnabled(boolean value) {
        this.attrsFactory.setMulticastEnabled(value);
        return this;
    }

    public RegionFactory<K, V> setPoolName(String poolName) {
        this.attrsFactory.setPoolName(poolName);
        return this;
    }

    @Deprecated
    public void setPublisher(boolean v) {
    }

    public RegionFactory<K, V> setEnableAsyncConflation(boolean value) {
        this.attrsFactory.setEnableAsyncConflation(value);
        return this;
    }

    public RegionFactory<K, V> setEnableSubscriptionConflation(boolean value) {
        this.attrsFactory.setEnableSubscriptionConflation(value);
        return this;
    }

    public RegionFactory<K, V> setKeyConstraint(Class<K> keyConstraint) {
        this.attrsFactory.setKeyConstraint(keyConstraint);
        return this;
    }

    public RegionFactory<K, V> setValueConstraint(Class<V> valueConstraint) {
        this.attrsFactory.setValueConstraint(valueConstraint);
        return this;
    }

    public RegionFactory<K, V> setInitialCapacity(int initialCapacity) {
        this.attrsFactory.setInitialCapacity(initialCapacity);
        return this;
    }

    public RegionFactory<K, V> setLoadFactor(float loadFactor) {
        this.attrsFactory.setLoadFactor(loadFactor);
        return this;
    }

    public RegionFactory<K, V> setConcurrencyLevel(int concurrencyLevel) {
        this.attrsFactory.setConcurrencyLevel(concurrencyLevel);
        return this;
    }

    public RegionFactory<K, V> setConcurrencyChecksEnabled(boolean enabled) {
        this.attrsFactory.setConcurrencyChecksEnabled(enabled);
        return this;
    }

    @Deprecated
    public RegionFactory<K, V> setDiskWriteAttributes(DiskWriteAttributes attrs) {
        this.attrsFactory.setDiskWriteAttributes(attrs);
        return this;
    }

    public RegionFactory<K, V> setDiskStoreName(String name) {
        this.attrsFactory.setDiskStoreName(name);
        return this;
    }

    public RegionFactory<K, V> setDiskSynchronous(boolean isSynchronous) {
        this.attrsFactory.setDiskSynchronous(isSynchronous);
        return this;
    }

    @Deprecated
    public RegionFactory<K, V> setDiskDirs(File[] diskDirs) {
        this.attrsFactory.setDiskDirs(diskDirs);
        return this;
    }

    @Deprecated
    public RegionFactory<K, V> setDiskDirsAndSizes(File[] diskDirs, int[] diskSizes) {
        this.attrsFactory.setDiskDirsAndSizes(diskDirs, diskSizes);
        return this;
    }

    public RegionFactory<K, V> setPartitionAttributes(PartitionAttributes partition) {
        this.attrsFactory.setPartitionAttributes(partition);
        return this;
    }

    @Deprecated
    public RegionFactory<K, V> setMembershipAttributes(MembershipAttributes ra) {
        this.attrsFactory.setMembershipAttributes(ra);
        return this;
    }

    public RegionFactory<K, V> setIndexMaintenanceSynchronous(boolean synchronous) {
        this.attrsFactory.setIndexMaintenanceSynchronous(synchronous);
        return this;
    }

    public RegionFactory<K, V> setStatisticsEnabled(boolean statisticsEnabled) {
        this.attrsFactory.setStatisticsEnabled(statisticsEnabled);
        return this;
    }

    public RegionFactory<K, V> setIgnoreJTA(boolean flag) {
        this.attrsFactory.setIgnoreJTA(flag);
        return this;
    }

    public RegionFactory<K, V> setLockGrantor(boolean isLockGrantor) {
        this.attrsFactory.setLockGrantor(isLockGrantor);
        return this;
    }

    public RegionFactory<K, V> setSubscriptionAttributes(SubscriptionAttributes sa) {
        this.attrsFactory.setSubscriptionAttributes(sa);
        return this;
    }

    public Region<K, V> create(String name) throws CacheExistsException, RegionExistsException, CacheWriterException, TimeoutException {
        RegionAttributes<K, V> ra = this.attrsFactory.create();
        return this.getCache().createRegion(name, ra);
    }

    public Region<K, V> createSubregion(Region<?, ?> parent, String name) throws RegionExistsException {
        RegionAttributes<K, V> ra = this.attrsFactory.create();
        return ((LocalRegion)parent).createSubregion(name, ra);
    }

    public RegionFactory<K, V> setCloningEnabled(boolean cloningEnable) {
        this.attrsFactory.setCloningEnabled(cloningEnable);
        return this;
    }

    public RegionFactory<K, V> addGatewaySenderId(String gatewaySenderId) {
        this.attrsFactory.addGatewaySenderId(gatewaySenderId);
        return this;
    }

    public RegionFactory<K, V> addAsyncEventQueueId(String asyncEventQueueId) {
        this.attrsFactory.addAsyncEventQueueId(asyncEventQueueId);
        return this;
    }

    public RegionFactory<K, V> setCompressor(Compressor compressor) {
        this.attrsFactory.setCompressor(compressor);
        return this;
    }

    public RegionFactory<K, V> setOffHeap(boolean offHeap) {
        this.attrsFactory.setOffHeap(offHeap);
        return this;
    }
}

