/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.net.SocketTimeoutException;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.cache.client.ServerConnectivityException;
import org.apache.geode.cache.client.ServerOperationException;
import org.apache.geode.cache.client.internal.Connection;
import org.apache.geode.cache.client.internal.ConnectionImpl;
import org.apache.geode.cache.client.internal.ConnectionStats;
import org.apache.geode.cache.client.internal.Op;
import org.apache.geode.cache.client.internal.UserAttributes;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.PutAllPartialResultException;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.tier.MessageType;
import org.apache.geode.internal.cache.tier.sockets.ChunkedMessage;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;

public abstract class AbstractOp
implements Op {
    private static final Logger logger = LogService.getLogger();
    private final Message msg;
    private boolean allowDuplicateMetadataRefresh;
    protected boolean failed;
    protected boolean timedOut;

    protected AbstractOp(int msgType, int msgParts) {
        this.msg = new Message(msgParts, Version.CURRENT);
        this.getMessage().setMessageType(msgType);
    }

    protected Message getMessage() {
        return this.msg;
    }

    protected void initMessagePart() {
    }

    private void setMsgTransactionId() {
        if (this.participateInTransaction() && this.getMessage().getTransactionId() == -1) {
            this.getMessage().setTransactionId(TXManagerImpl.getCurrentTXUniqueId());
        }
    }

    protected void attemptSend(Connection cnx) throws Exception {
        this.setMsgTransactionId();
        if (logger.isTraceEnabled(LogMarker.DISTRIBUTION_BRIDGE_SERVER) && logger.isDebugEnabled()) {
            logger.debug("Sending op={} using {}", (Object)this.getShortClassName(), (Object)cnx);
        }
        this.getMessage().setComms(cnx.getSocket(), cnx.getInputStream(), cnx.getOutputStream(), cnx.getCommBuffer(), cnx.getStats());
        try {
            this.sendMessage(cnx);
        }
        finally {
            this.getMessage().unsetComms();
        }
    }

    public String getShortClassName() {
        String cname = this.getClass().getName();
        return cname.substring(this.getClass().getPackage().getName().length() + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendMessage(Connection cnx) throws Exception {
        if (cnx.getServer().getRequiresCredentials()) {
            this.getMessage().setMessageHasSecurePartFlag();
            long userId = -1L;
            if (UserAttributes.userAttributes.get() == null) {
                userId = cnx.getServer().getUserId();
            } else {
                Long id = UserAttributes.userAttributes.get().getServerToId().get(cnx.getServer());
                if (id == null) {
                    throw new ServerConnectivityException("Connection error while authenticating user");
                }
                userId = id;
            }
            try (HeapDataOutputStream hdos = new HeapDataOutputStream(Version.CURRENT);){
                hdos.writeLong(cnx.getConnectionID());
                hdos.writeLong(userId);
                this.getMessage().setSecurePart(((ConnectionImpl)cnx).getHandShake().encryptBytes(hdos.toByteArray()));
            }
        }
        this.getMessage().send(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object attemptReadResponse(Connection cnx) throws Exception {
        Message msg = this.createResponseMessage();
        if (msg != null) {
            msg.setComms(cnx.getSocket(), cnx.getInputStream(), cnx.getOutputStream(), cnx.getCommBuffer(), cnx.getStats());
            if (msg instanceof ChunkedMessage) {
                try {
                    Object object = this.processResponse(msg, cnx);
                    return object;
                }
                finally {
                    msg.unsetComms();
                    this.processSecureBytes(cnx, msg);
                }
            }
            try {
                msg.recv();
            }
            finally {
                msg.unsetComms();
                this.processSecureBytes(cnx, msg);
            }
            return this.processResponse(msg, cnx);
        }
        return null;
    }

    protected void processSecureBytes(Connection cnx, Message message) throws Exception {
        if (cnx.getServer().getRequiresCredentials()) {
            if (!message.isSecureMode()) {
                if (logger.isDebugEnabled()) {
                    logger.trace(LogMarker.BRIDGE_SERVER, "Response message from {} for {} has no secure part.", (Object)cnx, (Object)this);
                }
                return;
            }
            byte[] partBytes = message.getSecureBytes();
            if (partBytes == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Response message for {} has no bytes in secure part.", (Object)this);
                }
                return;
            }
            byte[] bytes = ((ConnectionImpl)cnx).getHandShake().decryptBytes(partBytes);
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
            cnx.setConnectionID(dis.readLong());
        }
    }

    protected Message createResponseMessage() {
        return new Message(1, Version.CURRENT);
    }

    protected Object processResponse(Message m, Connection con) throws Exception {
        return this.processResponse(m);
    }

    protected abstract Object processResponse(Message var1) throws Exception;

    protected abstract boolean isErrorResponse(int var1);

    protected void processAck(Message msg, String opName) throws Exception {
        int msgType = msg.getMessageType();
        if (msgType == 6) {
            return;
        }
        Part part = msg.getPart(0);
        if (msgType == 2) {
            String s = ": While performing a remote " + opName;
            Throwable t = (Throwable)part.getObject();
            if (t instanceof PutAllPartialResultException) {
                throw (PutAllPartialResultException)t;
            }
            throw new ServerOperationException(s, t);
        }
        if (this.isErrorResponse(msgType)) {
            throw new ServerOperationException(part.getString());
        }
        throw new InternalGemFireError("Unexpected message type " + MessageType.getString(msgType));
    }

    protected Object processObjResponse(Message msg, String opName) throws Exception {
        Part part = msg.getPart(0);
        int msgType = msg.getMessageType();
        if (msgType == 1) {
            return part.getObject();
        }
        if (msgType == 2) {
            String s = "While performing a remote " + opName;
            throw new ServerOperationException(s, (Throwable)part.getObject());
        }
        if (this.isErrorResponse(msgType)) {
            throw new ServerOperationException(part.getString());
        }
        throw new InternalGemFireError("Unexpected message type " + MessageType.getString(msgType));
    }

    public boolean isAllowDuplicateMetadataRefresh() {
        return this.allowDuplicateMetadataRefresh;
    }

    public void setAllowDuplicateMetadataRefresh(boolean allowDuplicateMetadataRefresh) {
        this.allowDuplicateMetadataRefresh = allowDuplicateMetadataRefresh;
    }

    protected void processChunkedResponse(ChunkedMessage msg, String opName, ChunkHandler callback) throws Exception {
        msg.readHeader();
        int msgType = msg.getMessageType();
        if (msgType == 1) {
            do {
                msg.receiveChunk();
                callback.handle(msg);
            } while (!msg.isLastChunk());
        } else {
            if (msgType == 2) {
                msg.receiveChunk();
                Part part = msg.getPart(0);
                String s = "While performing a remote " + opName;
                throw new ServerOperationException(s, (Throwable)part.getObject());
            }
            if (this.isErrorResponse(msgType)) {
                msg.receiveChunk();
                Part part = msg.getPart(0);
                throw new ServerOperationException(part.getString());
            }
            throw new InternalGemFireError("Unexpected message type " + MessageType.getString(msgType));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object attempt(Connection cnx) throws Exception {
        this.failed = true;
        this.timedOut = false;
        long start = this.startAttempt(cnx.getStats());
        try {
            try {
                this.attemptSend(cnx);
                this.failed = false;
            }
            finally {
                this.endSendAttempt(cnx.getStats(), start);
            }
            this.failed = true;
            try {
                Object result = this.attemptReadResponse(cnx);
                this.failed = false;
                Object object = result;
                return object;
            }
            catch (SocketTimeoutException ste) {
                this.failed = false;
                this.timedOut = true;
                throw ste;
            }
        }
        finally {
            this.endAttempt(cnx.getStats(), start);
        }
    }

    protected boolean hasFailed() {
        return this.failed;
    }

    protected boolean hasTimedOut() {
        return this.timedOut;
    }

    protected abstract long startAttempt(ConnectionStats var1);

    protected abstract void endSendAttempt(ConnectionStats var1, long var2);

    protected abstract void endAttempt(ConnectionStats var1, long var2);

    protected boolean needsUserId() {
        return true;
    }

    protected boolean participateInTransaction() {
        return true;
    }

    @Override
    public boolean useThreadLocalConnection() {
        return true;
    }

    public boolean isGatewaySenderOp() {
        return false;
    }

    public static interface ChunkHandler {
        public void handle(ChunkedMessage var1) throws Exception;
    }
}

