/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import org.apache.geode.cache.client.internal.AbstractOp;
import org.apache.geode.cache.client.internal.Connection;
import org.apache.geode.cache.client.internal.ConnectionStats;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.internal.cache.tier.sockets.Message;

public class GetFunctionAttributeOp {
    public static Object execute(ExecutablePool pool, String functionId) {
        GetFunctionAttributeOpImpl op = new GetFunctionAttributeOpImpl(functionId);
        return pool.execute(op);
    }

    private GetFunctionAttributeOp() {
    }

    static class GetFunctionAttributeOpImpl
    extends AbstractOp {
        private String functionId = null;

        public GetFunctionAttributeOpImpl(String functionId) {
            super(91, 1);
            this.functionId = functionId;
            this.getMessage().addStringPart(this.functionId);
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            return this.processObjResponse(msg, "getFunctionAttribute");
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return msgType == 3;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startGet();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endGetSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endGet(start, this.hasTimedOut(), this.hasFailed());
        }

        @Override
        protected void processSecureBytes(Connection cnx, Message message) throws Exception {
        }

        @Override
        protected boolean needsUserId() {
            return false;
        }

        @Override
        protected void sendMessage(Connection cnx) throws Exception {
            this.getMessage().clearMessageHasSecurePartFlag();
            this.getMessage().send(false);
        }
    }
}

